package es.caib.ibkey.bpm.common.handler;

import org.hibernate.Session;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.graph.exe.ExecutionContext;

import es.caib.bpm.toolkit.exception.SystemWorkflowException;
import es.caib.ibkey.bpm.common.SyntaxQueryResolver;

/**
 * Handler to signal another process instance
 * @author u91940
 *
 */

public class SignalProcessHandler extends LoggerActionHandler {

	private static final long serialVersionUID = 1L;
	/** instance to signal **/
	public String processInstanceId="-1";
	/** transition name by default null **/
	private String transitionName=null;
	
	public void execute(ExecutionContext executionContext) throws Exception {
		super.execute(executionContext);
		
		if("-1".equals(processInstanceId)){
			SystemWorkflowException e= new SystemWorkflowException("ConfigurationException: processinstance argument not configured: -1");
			error(e.getMessage(),e);
			throw e;
		}
		JbpmContext context=executionContext.getJbpmContext();
		long pid=Long.parseLong(SyntaxQueryResolver.resolve(""+processInstanceId,executionContext.getContextInstance().getVariables()));
		debug("signalling process "+pid+" to transition "+((transitionName!=null)?transitionName:"default"));
		org.jbpm.graph.exe.ProcessInstance pi = context.loadProcessInstance(pid);


		//signal external node
		if(transitionName==null || (transitionName != null && "".equals(transitionName)))
			pi.signal();
		else
			pi.signal(transitionName);
		

		//signal current node
		executionContext.getProcessInstance().signal();
				
	}
	

	protected JbpmContext createContext() {
        JbpmContext myContext = JbpmConfiguration.getInstance().createJbpmContext();
        return myContext;
    }
	private void flushContext(JbpmContext myContext)  {
        if (myContext != null) {
            myContext.setActorId(null);
            try {
                myContext.close();
            } finally {
            	myContext = null;
            }
        }
    }	

}
