package es.caib.ibkey.bpm.conversion.handler;

import java.io.UnsupportedEncodingException;

import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.node.DecisionHandler;

import es.caib.bpm.exception.BPMException;
import es.caib.ibkey.bpm.common.IBkeyConfig;
import es.caib.ibkey.bpm.common.handler.LoggerDecisionHandler;
import es.caib.ibkey.bpm.document.stage.StageInfo;
import es.caib.ibkey.bpm.document.stage.StageManager;
import es.caib.ibkey.utils.KPM;

/**
 * Handler per a decidir si s'ha de convertir el document a PDF o no.
 * En aquesta implementació, si ja és pdf, no es converteix.
 * 
 * Si hi ha stageAnterior, s'agafa el content-type de l'stage anterior per a decidir si s'ha de convertir.
 * Si no hi ha stage anterior, és necessari configurar el handler per tal de definir quin serà en content-type del document
 * @author u91940
 *
 */
public class ConversionDecisionHandler extends LoggerDecisionHandler {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	
	protected String inputContentType=null;

	public String decide(ExecutionContext ctx) throws Exception {
		configure(ctx);
		
		StageManager stgMgr=StageManager.getStageManager(ctx);
		if(stgMgr!=null){		
			StageInfo stageAnterior=stgMgr.findLastCompletedStage();
			
			if(stageAnterior!=null){
				inputContentType=stageAnterior.getContentType();
				if(inputContentType==null)
					throw new BPMException("S'ha de definir el content-type del document de l'ultim stage executat",1);
			}else{	
				if(inputContentType==null){
					throw new BPMException("Si la tasca de conversió és la primera d'un workflow, s'ha d'especificar el content-type del document d'entrada", 1);
				}
			}
			
			if(isPDF(inputContentType)){
				if(isPDFA(stgMgr.getInputObject(ctx))){				
					warn("Document does not need conversion to PDF/A");
					return "no";
				}else{
					if(IBkeyConfig.isPDFToPDFAConversionsEnabled()!=null && "true".equals(IBkeyConfig.isPDFToPDFAConversionsEnabled())){
						return "si";
					}else{
						warn("Conversion PDF to PDF/A disabled");
						return "no";
					}
				}
			}else{
				
				return "si";
			}
			
		}else{
			throw new BPMException("L'ús del ConversionDecisionHandler depen d'un workflow amb un StageManager", 1);
		}
		
	}

	private boolean isPDFA(byte[] inputObject) throws Exception {
		try {
			byte[] checkString=new String("<pdfaid:conformance>A</pdfaid:conformance>").getBytes("UTF-8");
			int found=KPM.indexOf(inputObject, checkString);
			if(found==-1) return false;
		} catch (UnsupportedEncodingException e) {
			error("Error al codificar el UTF-8", e);
		}
		return true;
		
	}

	//lògica de decisió
	private boolean isPDF(String inputContentType2) {
		
		if(inputContentType2.equals("application/pdf")){
			return true;
		}else{
			return false;
		}
		
	}

	/**
	 * @return the inputContentType
	 */
	public synchronized String getInputContentType() {
		return inputContentType;
	}

	/**
	 * @param inputContentType the inputContentType to set
	 */
	public synchronized void setInputContentType(String inputContentType) {
		this.inputContentType = inputContentType;
	}
	
	
	
}
