package es.caib.ibkey.bpm.conversion.handler;



import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Map;

import org.apache.log4j.Logger;
import org.jbpm.graph.exe.ExecutionContext;

import es.caib.ibkey.bpm.common.IBkeyConfig;
import es.caib.ibkey.bpm.common.handler.AbstractIndexedHandler;
import es.caib.ibkey.bpm.conversion.exception.ConversionException;
import es.caib.ibkey.ghostscript.helper.GhostScriptConversionHelper;
import es.caib.ibkey.oppenoffice.helper.OpenOfficeDocumentConversionHelper;
import es.caib.ibkey.utils.KPM;

/**
 * Handler per a la conversió de documents mitjançant openOffice.
 * 
 * Variables d'entrada al context del procés:
 * VAR_FILTER_OPTIONS: 						(Opcional) opcions del conversor
 *
 *
 * Variables d'entrada a l'instància del handler:
 * formatDeSortida: 						(Opcional) per defecte pdf/A. (Correspon al nom del filtre de conversió)
 * extensioDocumentSortida: 				(opcional) per defecte ".pdf"
 * 
 * @author u91940
 *
 */



public class ConversionHandler extends AbstractIndexedHandler{

	private static final long serialVersionUID = 1L;
	private Map filterOptions=new Hashtable();
	
	/*variables que defineixen els codis dels paràmetres que utilitza el handler*/
	public String formatDeSortida=null;
	public String extensioDocumentSortida=null;
	

	protected File convertedDocument=null;
	protected File documentToConvert=null;
	private InputStream convertedStream;
	
	/**
	 * Mètode que converteix els documents attached a pdf via OpenOffice
	 */
	public void handleExecute(ExecutionContext ctx) throws Exception{
		

			
			//per defecte PDF
			if(formatDeSortida==null){
				formatDeSortida="writer_pdf_Export";
				if(extensioDocumentSortida==null){
					extensioDocumentSortida=".pdf";
				}
			}
			
			if(".pdf".equals(extensioDocumentSortida)){
				if("application/pdf".equals(getInputContentType())){
					if(!isPDFA((byte[])getInputObject())){
						if(IBkeyConfig.isPDFToPDFAConversionsEnabled()!=null && "true".equals(IBkeyConfig.isPDFToPDFAConversionsEnabled())){
							ghostScriptConversion(ctx);
						}else{
							warn("Conversion PDF to PDF/A disabled");
						}
					}else{
						warn("Document does not need conversion to PDF/A");
					}
				}else{
					openofficeConversion(ctx);
				}
					
			}
	}
	

	private boolean isPDFA(byte[] inputObject) throws Exception {
		try {
			byte[] checkString=new String("<pdfaid:conformance>A</pdfaid:conformance>").getBytes("UTF-8");
			int found=KPM.indexOf(inputObject, checkString);
			if(found==-1)return false;
		} catch (UnsupportedEncodingException e) {
			error("Error al codificar el UTF-8", e);
		}
		return true;
	}


	private void ghostScriptConversion(ExecutionContext ctx) throws Exception {
		GhostScriptConversionHelper helper= new GhostScriptConversionHelper();
			
		if(getInputObject()!=null){
			try{
				//creem el fitxer d'entrada, que ha de ser un titxer físic per a què l'openoffice el pugui processar
				documentToConvert=File.createTempFile(ctx.getProcessInstance().getId()+getStageAnterior().getName(),getMimeReg().getExtensionByContentType(getInputContentType()));
				documentToConvert.deleteOnExit();
				
				FileOutputStream outStr=null;
				try{
					outStr=new FileOutputStream(documentToConvert);
					outStr.write((byte[])getInputObject());
					outStr.flush();
				}catch(IOException th){
					throw th;
				}finally{
					if(outStr!=null)
						outStr.close();							
				}
				
				// Creem el fitxer de sortida, que ha de ser un titxer físic per a què l'openoffice el pugui processar				
				convertedDocument=File.createTempFile(ctx.getProcessInstance().getId()+getStageActual().getName(),extensioDocumentSortida);
				convertedDocument.deleteOnExit();
			} catch (java.lang.Exception e) {
				error(e.getMessage(),e);
				throw e;
			}
				//conversió de format
				helper.convertDocument(documentToConvert.getAbsolutePath(),formatDeSortida,convertedDocument.getAbsolutePath(),filterOptions);
			try{	
				//configurem el comportament abstracte
				//establim l'outputObject
				convertedStream=new BufferedInputStream(new FileInputStream(convertedDocument));
				setOutputObject(convertedStream);
				//establim l'outputContentType
				setOutputContentType(getMimeReg().getContentTypeByExtension(extensioDocumentSortida));
				//Establim l'outputOriginalName per al documentManager
				setOutputOriginalName(getOutputTag()+extensioDocumentSortida);
			}catch (java.lang.Exception e) {
				error(e.getMessage(),e);
				throw e;
			}
		}
	}


	private void openofficeConversion(ExecutionContext ctx) throws Exception {
		OpenOfficeDocumentConversionHelper helper=new OpenOfficeDocumentConversionHelper();
		
		try{
				
				if(getInputObject()!=null){
	
					//creem el fitxer d'entrada, que ha de ser un titxer físic per a què l'openoffice el pugui processar
					documentToConvert=File.createTempFile(ctx.getProcessInstance().getId()+getStageAnterior().getName(),getMimeReg().getExtensionByContentType(getInputContentType()));
					documentToConvert.deleteOnExit();
					
					FileOutputStream outStr=null;
					try{
						outStr=new FileOutputStream(documentToConvert);
						outStr.write((byte[])getInputObject());
						outStr.flush();
					}catch(IOException th){
						throw th;
					}finally{
						if(outStr!=null)
							outStr.close();							
					}
					
					// Creem el fitxer de sortida, que ha de ser un titxer físic per a què l'openoffice el pugui processar				
					convertedDocument=File.createTempFile(ctx.getProcessInstance().getId()+getStageActual().getName(),extensioDocumentSortida);
					convertedDocument.deleteOnExit();

					//conversió de format
					helper.convertDocument(documentToConvert.getAbsolutePath(),formatDeSortida,convertedDocument.getAbsolutePath(),filterOptions);
					
					//configurem el comportament abstracte
					//establim l'outputObject
					convertedStream=new BufferedInputStream(new FileInputStream(convertedDocument));
					setOutputObject(convertedStream);
					//establim l'outputContentType
					setOutputContentType(getMimeReg().getContentTypeByExtension(extensioDocumentSortida));
					//Establim l'outputOriginalName per al documentManager
					setOutputOriginalName(getOutputTag()+extensioDocumentSortida);
				}
			} catch(com.sun.star.uno.Exception e){
				error(e.getMessage(),e);
				throw new ConversionException(e);
	
			} catch (java.lang.Exception e) {
				error(e.getMessage(),e);
				throw e;
			}
	
	
	}






	/**
	 * Handler per a la gestió del rollback dels documents.
	 * @param oldDocuments
	 * @param convertedDocuments
	 * @param attMgr
	 * @throws Exception
	 */

	protected void handleRollBack(ExecutionContext ctx) {
		
	}





	/**
	 * @return the formatDeSortida
	 */
	public synchronized String getFormatDeSortida() {
		return formatDeSortida;
	}





	/**
	 * @param formatDeSortida the formatDeSortida to set
	 */
	public synchronized void setFormatDeSortida(String formatDeSortida) {
		this.formatDeSortida = formatDeSortida;
	}





	/**
	 * @return the extensioDocumentSortida
	 */
	public synchronized String getExtensioDocumentSortida() {
		return extensioDocumentSortida;
	}





	/**
	 * @param extensioDocumentSortida the extensioDocumentSortida to set
	 */
	public synchronized void setExtensioDocumentSortida(String extensioDocumentSortida) {
		this.extensioDocumentSortida = extensioDocumentSortida;
	}





	/**
	 * @return the varFilterOptions
	 */
	public synchronized Map getVarFilterOptions() {
		return filterOptions;
	}
	public synchronized void setVarFilterOptions(Map options) {
		filterOptions=options;
	}





	protected void freeResources(ExecutionContext ctx) {
		try{
			if(documentToConvert!=null)documentToConvert.delete();
			if(convertedStream!=null)convertedStream.close();
			if(convertedDocument!=null)convertedDocument.delete();
			
		}catch(Throwable th){
			error(th.getMessage(),th);
		}
	}	
	
	
}
