package es.caib.ibkey.bpm.custodia.handler;




import java.io.ByteArrayInputStream;

import org.jbpm.graph.exe.ExecutionContext;

import es.caib.bpm.toolkit.exception.SystemWorkflowException;
import es.caib.ibkey.bpm.common.handler.AbstractIndexedHandler;
import es.caib.ibkey.bpm.document.stage.StageInfo;
import es.caib.ibkey.bpm.document.stage.impl.StageInfoCustodia;
import es.caib.ibkey.bpm.document.stage.impl.StageInfoCustodiaAnonima;
import es.caib.signatura.cliente.ClienteCustodia;


/**
 * Handler per a l'enviament de documents a custòdia.
 * 
 * Variables d'entrada al context del procés:
 * DOCUMENTO_A_CUSTODIAR: 					(obligatori) tags del attachment a custodiar
 * DOCUMENTO_CUSTODIADO_ID:					(opcional) ID extern del document a custòdia
 * StageManager.CTX_VAR_NAME:				StateManager
 * 
 * 
 * @author u91940
 *
 */



public abstract class AbstractUploadCustodiaHandler extends AbstractIndexedHandler {


	private static final long serialVersionUID = 1L;

	/**
	 * Upload de documents a custòdia
	 */
	public void handleExecute(ExecutionContext ctx) throws Exception{
		
		ByteArrayInputStream bis=null;
		ClienteCustodia clienteCustodia=null;
		try{
		    
			String appId=((StageInfoCustodia)getStageActual()).getRepoAppID();
					
			clienteCustodia = new ClienteCustodia(appId);
	
           	bis=new ByteArrayInputStream((byte[])getInputObject());
           	debug("Obteniendo codigo externo de reserva custodia con hash: "+((StageInfoCustodiaAnonima)getStageActual()).getHash());
			byte[] codExternoCustodiaResp=clienteCustodia.consultarReservaDocumento(((StageInfoCustodiaAnonima)getStageActual()).getHash());
			ConsultaReservaDocumentoResponseParser parser=new ConsultaReservaDocumentoResponseParser(codExternoCustodiaResp);
			debug("Codigo externo "+parser.getCodigoExterno()+" para la reserva de custodia con hash "+((StageInfoCustodiaAnonima)getStageActual()).getHash());
			setOutputTag(parser.getCodigoExterno());

		}catch (Throwable ex){
			getStageActual().setStatus(StageInfo.STATUS_ERROR);
			error(ex.getMessage(),ex);
			if(bis!=null) bis.close();
			throw new Exception(ex);
		}	
		
		byte[] xml=null;		
        
		try{
			debug("Inicio de llamada a la custodia para el codigo externo "+getOutputTag());
			//custodiem el document
			xml=custodiaCall(clienteCustodia,bis, getOutputTag()+getMimeReg().getExtensionByContentType(getOutputContentType()) ,getOutputTag(), ((StageInfoCustodia)getStageActual()).getRepoTipoDoc(ctx));
		}catch (Throwable ex){
			getStageActual().setStatus(StageInfo.STATUS_ERROR);
			throw new Exception(ex);
		}finally{
			//no ponemos esto en el método freeresources para evitar olvidar llamar a super.freeresources en las clases que hereden
			if(bis!=null) bis.close();
			debug("Fin de llamada a la custodia para el codigo externo "+getOutputTag());
		}	
		
		if(xml==null) throw new SystemWorkflowException("Error en el cliente de custodia.");
		
		try{		
			debug(new String(xml,"UTF8"));
			debug("Inicio del parseo de la respuesta de llamada a la custodia para el codigo externo "+getOutputTag());
			CustodiaResponseParser responseParser=new CustodiaResponseParser(xml);
			
			//si ha anat malament, excepte si ha anat malament perquè el document ja existia
			if(!responseParser.getResultado().equals(CustodiaResponseParser.SUCCESS)){
				if(!responseParser.getException().equals(CustodiaResponseParser.ERROR_DOCUMENTO_ARCHIVADO)){
					throw new Exception(responseParser.getException());
				}else{
					debug("Ignoramos la acción porque el documento había sido custodiado con anterioridad");
				}
			}
			
			getStageActual().setStatus(StageInfo.STATUS_DONE);
		}catch (Throwable ex){
			getStageActual().setStatus(StageInfo.STATUS_ERROR);
			error(ex.getMessage(),ex);
			throw new Exception(ex);
		}		
		debug("Fin del parseo de la respuesta de llamada a la custodia para el codigo externo "+getOutputTag());
	}

	protected abstract byte[] custodiaCall(ClienteCustodia clienteCustodia, ByteArrayInputStream bis, String nombreDocumento, String documentoCustodiadoId, String repoTipoDoc) throws Exception;	

	protected void handleRollBack(ExecutionContext ctx) {
	
	}
	
	
	
}