package es.caib.ibkey.bpm.custodia.handler;

import java.io.ByteArrayInputStream;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;

import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class CustodiaResponseParser {
/**
 * Parser del resultat de custòdia.
 */
	
	private byte xml[]=null;
	private String resultado=null;
	private String exception=null;
	private String stackTrace=null;
	private Logger log=Logger.getLogger(this.getClass().getName());
	
	public final static String SUCCESS="Success";

	public static final String ERROR_DOCUMENTO_ARCHIVADO = "ERROR_DOCUMENTO_ARCHIVADO";
	
	public CustodiaResponseParser(byte [] xml) throws Exception {
		this.xml=xml;
		parse(xml);
	}

	private void parse(byte[] xml2) throws Exception {
		ByteArrayInputStream bis=null;
        Document doc=null;
        
		try{
			DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
			bis=new ByteArrayInputStream(xml2);
			doc=builder.parse(bis);
		}catch(Exception e){
			throw e;
		}finally{
			if(bis!=null)bis.close();
		}
        
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
 
        Node resultNode=((Node)xpath.evaluate("//CustodiaResponse/VerifyResponse/Result/ResultMajor/text()",doc,XPathConstants.NODE));
        String resultStr=(resultNode!=null)?resultNode.getNodeValue():null;
        if(resultStr==null){
        	log.error("Error en la respuesta de custodia: "+xml);
        	throw new Exception("Error en la respuesta de custodia: "+xml);
        }
        
        Node traceNode=((Node)xpath.evaluate("//CustodiaResponse/VerifyResponse/Result/ResultMessage/text()",doc,XPathConstants.NODE));
        String trace=(traceNode!=null)?traceNode.getNodeValue():null;
        
        Node excepNode= ((Node)xpath.evaluate("//CustodiaResponse/VerifyResponse/Result/ResultMinor/text()",doc,XPathConstants.NODE));
        String excep=(excepNode!=null)?excepNode.getNodeValue():null;
        
        setResultado(resultStr);
        setStackTrace(trace);
        setException(excep);
        
	}

	/**
	 * @return the xml
	 */
	public synchronized byte [] getXml() {
		return xml;
	}

	/**
	 * @param xml the xml to set
	 */
	public synchronized void setXml(byte [] xml) {
		this.xml = xml;
	}

	/**
	 * @return the resultado
	 */
	public synchronized String getResultado() {
		return resultado;
	}

	/**
	 * @param resultado the resultado to set
	 */
	public synchronized void setResultado(String resultado) {
		this.resultado = resultado;
	}

	/**
	 * @return the exception
	 */
	public synchronized String getException() {
		return exception;
	}

	/**
	 * @param exception the exception to set
	 */
	public synchronized void setException(String exception) {
		this.exception = exception;
	}

	/**
	 * @return the stackTrace
	 */
	public synchronized String getStackTrace() {
		return stackTrace;
	}

	/**
	 * @param stackTrace the stackTrace to set
	 */
	public synchronized void setStackTrace(String stackTrace) {
		this.stackTrace = stackTrace;
	}


	
}
