/**
 * 
 */
package es.caib.ibkey.bpm.custodia.handler;


import java.io.ByteArrayInputStream;
import java.security.InvalidParameterException;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;

import org.jbpm.graph.exe.ExecutionContext;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

import es.caib.ibkey.bpm.common.IBkeyConfig;
import es.caib.ibkey.bpm.common.SyntaxQueryResolver;
import es.caib.ibkey.bpm.common.handler.LoggerActionHandler;
import es.caib.ibkey.bpm.document.stage.StageInfo;
import es.caib.ibkey.bpm.document.stage.StageManager;
import es.caib.ibkey.bpm.document.stage.URLDescription;
import es.caib.ibkey.bpm.document.stage.impl.StageInfoCustodia;
import es.caib.ibkey.bpm.document.stage.impl.StageInfoCustodiaAnonima;
import es.caib.signatura.cliente.ClienteCustodia;

/**
 * @author u91940
 * Reserva un ID de documento para custodia, y añade en el stageManager una URL desde donde descargar el documento
 * El código externo del documento estará formado por codigo_externo_custodia=[ID del proceso]-[codigoDeReserva], donde codigoDeReserva ha de ser pasado como variable de contexto. Si no se pasa, se lanza una excepción.
 */
public class ReservaIdCustodiaHandlerV2 extends LoggerActionHandler {


	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	public String codigoStageDeReserva=null;
	
	
	public void execute(ExecutionContext ctx) throws Exception {
		super.execute(ctx);
		try{
			String stageName=SyntaxQueryResolver.resolve(codigoStageDeReserva,ctx.getContextInstance().getVariables());//Thread.currentThread().getContextClassLoader()//this.getClass().getClassLoader().getParent().getParent().getParent().loadClass("es.caib.cliente.ClienteCustodia")
			if(stageName==null) throw new InvalidParameterException("La variable de contexto codigoDeReserva es obligatoria.");
			StageManager manager=StageManager.getStageManager(ctx);
			StageInfo stageReservado=manager.find(stageName);
			if(stageName==null) throw new InvalidParameterException("No existe ningún stage con nombre "+stageName);
			/**<?xml version="1.0" encoding="UTF-8"?>
			 * <con:ReservaResponse xmlns:con="http://www.caib.es.signatura.custodia">
			 * 	<dss:Result xmlns:dss="urn:oasis:names:tc:dss:1.0:core:schema">
			 * 		<dss:ResultMajor>Success</dss:ResultMajor>
			 * 		<dss:ResultMinor></dss:ResultMinor>
			 * 		<dss:ResultMessage xml:lang="es"></dss:ResultMessage>
			 * 		</dss:Result>
			 * 	<con:Hash>1273750169457pepito1589766761425756644</con:Hash>
			 * 	<con:Codigo>pepito</con:Codigo>
			 * </con:ReservaResponse>
			 */
			String idReserva="-"+ctx.getProcessInstance().getId()+"-";
			ClienteCustodia clienteCustodia = new ClienteCustodia(((StageInfoCustodia)stageReservado).getRepoAppID()); //debemos tener el sar instalado.
			byte xmlResponse[]=clienteCustodia.reservarDocumento_v2(idReserva);
			byte hash_utf8[]=parse(xmlResponse);
			
			((StageInfoCustodiaAnonima)stageReservado).setHash(new String(hash_utf8,"UTF-8"));
			manager.getDownloadURL().put(stageName,new URLDescription(IBkeyConfig.getCustodiaAnonimaConsultaServletAddress()+"/"+new String(hash_utf8,"UTF8"),stageName));
		}catch(Exception e){
			error(e.getMessage(),e);
			throw e;
		}
		ctx.getProcessInstance().signal();
	}

	/**
	 * No genera documentos de salida que se tengan que enviar al document manager, por lo cual no hay que implementar el método.
	 */
	protected void handleRollBack(ExecutionContext ctx) {

	}
	
	protected void freeResources(ExecutionContext ctx) {
		
	}
	
	/**
	 * @return the codigoStageDeReserva
	 */
	public synchronized String getCodigoStageDeReserva() {
		return codigoStageDeReserva;
	}

	/**
	 * @param codigoStageDeReserva the codigoStageDeReserva to set
	 */
	public synchronized void setCodigoStageDeReserva(String codigoStageDeReserva) {
		this.codigoStageDeReserva = codigoStageDeReserva;
	}

	private byte [] parse(byte[] xml2) throws Exception {
		ByteArrayInputStream bis=null;
        Document doc=null;
        
		try{
			DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
			bis=new ByteArrayInputStream(xml2);
			doc=builder.parse(bis);
		}catch(Exception e){
			throw e;
		}finally{
			if(bis!=null)bis.close();
		}
        
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
 
        Node resultNode=((Node)xpath.evaluate("//ReservaResponse/Result/ResultMajor/text()",doc,XPathConstants.NODE));
        String resultStr=(resultNode!=null)?resultNode.getNodeValue():null;
        if(resultStr==null){
        	error("Error en la respuesta de custodia: "+xml2,new Exception("Error en la respuesta de custodia: "+xml2));
        	throw new Exception("Error en la respuesta de custodia: "+xml2);
        }
        
        Node traceNode=((Node)xpath.evaluate("//ReservaResponse/Result/ResultMessage/text()",doc,XPathConstants.NODE));
        String trace=(traceNode!=null)?traceNode.getNodeValue():null;
        
        Node excepNode= ((Node)xpath.evaluate("//ReservaResponse/Result/ResultMinor/text()",doc,XPathConstants.NODE));
        String excep=(excepNode!=null)?excepNode.getNodeValue():null;
        
        if("Success".equals(resultStr)){
        	Node hashNode=((Node)xpath.evaluate("//ReservaResponse/Hash/text()",doc,XPathConstants.NODE));
            String hashStr=(hashNode!=null)?hashNode.getNodeValue():null;
            if(hashStr!=null) 
            	return hashStr.getBytes("UTF-8");
            else
            	return null;
        }
        
        if(excep!=null){
        	throw new Exception(excep);
        }
        
        return null;
        
	}
	
	


}
