package es.caib.ibkey.bpm.custodia.handler;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;

import org.apache.log4j.Logger;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;

import es.caib.bpm.attachment.AttachmentManager;
import es.caib.ibkey.bpm.common.SyntaxQueryResolver;
import es.caib.ibkey.bpm.common.handler.AbstractIndexedHandler;
import es.caib.ibkey.bpm.document.stage.StageManager;
import es.caib.ibkey.bpm.document.stage.URLDescription;

/**
 * Emmagatzema AL DOCUMENT MANAGER  el tiquet de descàrrega del document.
 * 
 * @author u91940
 *
 */

public class TicketCustodiaIndexedHandler extends AbstractIndexedHandler{

	/** Identificador del procés de reserva (ReservaIdCustodiaStageInfo.name) per a recuperar nom i url **/
	public String idReserva=null;
	/** URL a la que redirigirà el tiquet, té preferència sobre idReserva **/
	public String url=null;
	/**Nom que figurarà al tiquet, té preferència sobre idReserva  **/
	public String name=null;
	/** Nom de l'identificador del document al document manager **/
	public String nombreVariableDestino=null;

	public void execute(ExecutionContext ctx) throws Exception {
		this.hasStageInput=new Boolean(false);
		super.execute(ctx);
	}
	
	public void handleExecute(ExecutionContext executionContext) throws Exception {
		debug("execute begin");

		//recuperem la URL del document custodiat
		StageManager mgr=StageManager.getStageManager(executionContext);

		//check destination name
		if(nombreVariableDestino==null) throw new Exception("TicketCustodiaHandler mal configurado: Se debe establecer un valor para nombreVariableDestino");
		
		//obtain url
		if(url==null){
			if(idReserva==null) 
				throw new Exception("TicketCustodiaHandler mal configurado: Se debe establecer un valor para idReserva");
			else
				url=((URLDescription)mgr.getDownloadURL().get(idReserva)).getURL();
		}else{
			url=SyntaxQueryResolver.resolve(url, executionContext.getContextInstance().getVariables());
		}

		//obtain name
		if(name==null){
			name=mgr.getProcessName();
		}else{
			name=SyntaxQueryResolver.resolve(name, executionContext.getContextInstance().getVariables());
		}

		//ticket generation
		InputStream tiquetIs=this.getClass().getClassLoader().getResourceAsStream("plantilla_tiquet.html");
		ByteArrayOutputStream bos=new ByteArrayOutputStream();
		String plantilla=null;
		
		byte bbuf[]=new byte[1024];
		int readed=-1;
		
		try{
			do{
				readed=tiquetIs.read(bbuf);
				if(readed!=-1)
					bos.write(bbuf,0,readed);			
			}while(readed!=-1);
			plantilla=bos.toString("ISO-8859-1");
		}catch(Exception e){
			error(e.getMessage(),e);
			throw e;
		}finally{
			try{
				if(tiquetIs!=null)
					tiquetIs.close();
			}catch(Exception e){
				error(e.getMessage(),e);
				throw e;
			}finally{
				if(bos!=null)
					bos.close();	
			}
			
		}
		
		
		
		plantilla=plantilla.replaceAll("\\$document.name\\$",name);
		plantilla=plantilla.replaceAll("\\$document.url\\$",url);
		
		//guardem el tiquet al documentManager
		setOutputObject(new ByteArrayInputStream(plantilla.getBytes("ISO-8859-1")));
		setOutputContentType("text/html");
		setOutputOriginalName("tiquet-"+mgr.getProcessName());
		
	
	}

	protected void freeResources(ExecutionContext ctx) {
	}

	protected void handleRollBack(ExecutionContext ctx) {
	}

}
