package es.caib.ibkey.bpm.custodia.handler;



import java.io.ByteArrayInputStream;

import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;

import es.caib.signatura.cliente.ClienteCustodia;


/**
 * Handler per a l'enviament de documents a custòdia.
 * 
 * Variables d'entrada al context del procés:
 * DOCUMENTO_A_CUSTODIAR: 					(obligatori) tags del attachment a custodiar
 * DOCUMENTO_CUSTODIADO_ID:					(opcional) ID extern del document a custòdia
 * StageManager.CTX_VAR_NAME:				(obligatori) StateManager
 *
 * @author u91940
 *
 */



public class UploadDocumentoCustodiaHandler extends AbstractUploadCustodiaHandler {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	protected byte[] custodiaCall(ClienteCustodia clienteCustodia, ByteArrayInputStream bis,  String nombreDocumento, String documentoCustodiadoId, String repoTipoDoc) throws Exception {
		
		try{
			byte[] xml=clienteCustodia.custodiarDocumento(bis, nombreDocumento, documentoCustodiadoId, repoTipoDoc);
			return xml;
		}catch(Exception e){
			error(e.getMessage(),e);
			throw e;
		}
	}

	protected void freeResources(ExecutionContext ctx) {
		// TODO Auto-generated method stub
		
	}	

	
}