package es.caib.ibkey.bpm.custodia.handler;



import java.io.ByteArrayInputStream;
import java.util.List;

import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;

import es.caib.ibkey.bpm.document.stage.StageInfo;
import es.caib.ibkey.bpm.document.stage.impl.StageInfoPortafirmasUploadRequest;
import es.caib.signatura.cliente.ClienteCustodia;


/**
 * Handler per a l'enviament de documents a custòdia.
 * 
 * Variables d'entrada al context del procés:
 * DOCUMENTO_A_CUSTODIAR: 					(obligatori) tags del attachment a custodiar
 * DOCUMENTO_CUSTODIADO_ID:					(opcional) ID extern del document a custòdia
 * StageManager.CTX_VAR_NAME:				(obligatori) StateManager
 * 
 * @author u91940
 *
 */



public class UploadPDFCustodiaHandler extends AbstractUploadCustodiaHandler {

		
		private static final long serialVersionUID = 1L;
		
		@Override
		protected byte[] custodiaCall(ClienteCustodia clienteCustodia, ByteArrayInputStream bis, String nombreDocumento, String documentoCustodiadoId, String repoTipoDoc) throws Exception {
			
			byte[] xml=clienteCustodia.custodiarPDFFirmado(bis, nombreDocumento, documentoCustodiadoId, repoTipoDoc);
			return xml;
		}


		protected void freeResources(ExecutionContext ctx) {
			
		}	

		
	
}