package es.caib.ibkey.bpm.domini.aapp.organitzacio.handlers;

import java.util.Map;


import org.jbpm.graph.exe.ExecutionContext;

import es.caib.bpm.identity.seycon.IdentityManager;
import es.caib.bpm.identity.vo.Group;
import es.caib.bpm.toolkit.exception.UserWorkflowException;
import es.caib.ibkey.bpm.common.SyntaxQueryResolver;
import es.caib.ibkey.bpm.common.handler.LoggerActionHandler;

/**
 * Obté la conselleria per a un usuari o direcció generals, que poden ser camps dinàmics i poden ser resolts per el SyntaxQueryResolver
 * La DG s'obté del LDAP, i la conselleria de les taules d'identitat del JBPM
 * @author u91940
 *
 */

public class ObtenirConselleria extends LoggerActionHandler {

	public String codiUsuari=null;
	public String direccioGeneral=null;
	public String nomVariableSortida=null;

	
	public void execute(ExecutionContext executionContext) throws Exception {
		super.execute(executionContext);
		
		IdentityManager idMgr=new IdentityManager();
		try{
			debug("Inicio de obtener Conselleria desde tablas de grupos de JBPM");
			//checks
			if(nomVariableSortida==null) throw new UserWorkflowException("És necessari definir el nom de la variable de sortida on emmagatzemar el nom de la conselleria");
			if(codiUsuari!=null && direccioGeneral!=null) throw new UserWorkflowException("codiUsuari i direccioGeneral són mutuament excloents");
			
			Map processVariablesMap=executionContext.getContextInstance().getVariables();
			
			
			if(codiUsuari!=null){
				//resolem valor dinàmic
				String resolverUser = SyntaxQueryResolver.resolve(codiUsuari,processVariablesMap);
				if(resolverUser==null)resolverUser=codiUsuari;
				
				//obtenim DG
				direccioGeneral=idMgr.obtenirDireccioGeneralPerCodiUsuari(resolverUser);
			}
	
			//resolem valor dinàmic
			String resolvedDG=SyntaxQueryResolver.resolve(direccioGeneral, processVariablesMap);
			if(resolvedDG==null)resolvedDG=direccioGeneral;
			
			//obtenim conselleria
			String out = idMgr.obtenirConselleriaPerDireccioGeneral(resolvedDG);
			
			//establim el resultat
			executionContext.setVariable(nomVariableSortida,out);
		}catch(Exception e){
			error(e.getMessage(),e);
			throw e;
		}
		
		debug("Fin de obtener Conselleria desde tablas de grupos de JBPM");
		//continuem el workflow
		executionContext.getProcessInstance().signal();

	
	}

	/**
	 * La conselleria s'obté des de les taules d'identitat de JBPM, i és el grup pare del grup corresponent a la direcció general.
	 * @param direccioGeneral
	 * @param ctx
	 * @return
	 * @throws Exception 
	 */
	public static String obtenirConselleria(String direccioGeneral) throws Exception {
        IdentityManager idMgr=new IdentityManager();
        Group g= idMgr.obtenirGrupParePerGrup(direccioGeneral);
        return g.getName();
	}
	


}
