package es.caib.ibkey.bpm.domini.aapp.organitzacio.handlers;

import org.jbpm.graph.exe.ExecutionContext;

import es.caib.bpm.identity.seycon.IdentityManager;
import es.caib.bpm.toolkit.exception.UserWorkflowException;
import es.caib.ibkey.bpm.common.SyntaxQueryResolver;
import es.caib.ibkey.bpm.common.handler.LoggerActionHandler;

/**
 * Obté del LDAP el grup de l'usuari, que pot ser un paràmetre dinàmic que resolgui el SyntaxQueryResolver amb les variables del procediment.
 * Amb el grup primari, mira quin dels grups als que pertany l'usuari té un IBK_DIRECTOR associat, per a saber quin grup és direcció general.
 * 
 * @author u91940
 *
 */
public class ObtenirDireccioGeneral extends LoggerActionHandler {

	public String codiUsuari=null;
	public String nomVariableSortida=null;
	
	
	public void execute(ExecutionContext executionContext) throws Exception {
		super.execute(executionContext);
		debug("Obtener Dirección General");
		try{
			if(nomVariableSortida==null) throw new UserWorkflowException("És necessari definir el nom de la variable de sortida on emmagatzemar el nom de la direcció general");
			IdentityManager idMgr=new IdentityManager();
			
			codiUsuari=SyntaxQueryResolver.resolve(codiUsuari,executionContext.getContextInstance().getVariables());
			
			String out=idMgr.obtenirDireccioGeneralPerCodiUsuari(codiUsuari);

			//establim el resultat
			executionContext.setVariable(nomVariableSortida,out);
		}catch(Exception e){
			error(e.getMessage(),e);
			throw e;
		}
		debug("Obtener Dirección General");
		//continuem el workflow
		executionContext.getProcessInstance().signal();
	}




}
