package es.caib.ibkey.bpm.domini.aapp.organitzacio.handlers;

import org.jbpm.graph.exe.ExecutionContext;

import es.caib.bpm.identity.seycon.IdentityManager;
import es.caib.bpm.toolkit.exception.UserWorkflowException;
import es.caib.ibkey.bpm.common.SyntaxQueryResolver;
import es.caib.ibkey.bpm.common.handler.LoggerActionHandler;

/**
 * Obté el nom del grup corresponent al codi de la secció pressupostària indicat.
 * @author u91940
 *
 */

public class ObtenirSeccioPressupostaria extends LoggerActionHandler {

	private String codiSeccioPressupostaria=null;
	private String nomVariableSortida=null;

	
	public void execute(ExecutionContext executionContext) throws Exception {
		super.execute(executionContext);
		String out=null;
		
		debug("Inicio de conexión al LDAP para recuperar sessión presupuestaria");
		try{
			
			if(codiSeccioPressupostaria !=null){ 
				//checks
				if(nomVariableSortida==null) throw new UserWorkflowException("És necessari definir el nom de la variable de sortida on emmagatzemar el nom de la secció pressupostària");
				
				
				if(codiSeccioPressupostaria!=null) {
					IdentityManager idMgr= new IdentityManager();
					out=idMgr.obtenirGrupPerSeccioPressupostaria(SyntaxQueryResolver.resolve(codiSeccioPressupostaria,executionContext.getContextInstance().getVariables()));
				}
			}else{
				throw new UserWorkflowException("La variable codiSeccioPressupostaria és obligatòria");
			}
			
			executionContext.setVariable(nomVariableSortida,out);
			
		}catch(Exception e){
			error(e.getMessage(),e);
			throw e;
		}
		
		debug("Fin de conexión al LDAP para recuperar sessión presupuestaria");
		executionContext.getProcessInstance().signal();
	}

}
