package es.caib.ibkey.bpm.domini.aapp.organitzacio.handlers;

import java.util.Collection;

import org.hibernate.Session;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.node.DecisionHandler;


import es.caib.bpm.identity.hibernate.BPMIdentitySessionFactory;
import es.caib.bpm.identity.seycon.IdentityManager;
import es.caib.bpm.identity.seycon.vo.User;
import es.caib.bpm.toolkit.exception.SystemWorkflowException;
import es.caib.ibkey.bpm.common.SyntaxQueryResolver;

public class SecretariORDirectorDecisionHandler implements DecisionHandler{
	private static final long serialVersionUID = 1L;
	public String direccioGeneral=null;
	public String conselleria=null;
	
	public String decide(ExecutionContext ctx) throws Exception {
		Session s = ctx.getJbpmContext().getSession();

        
        String dg=SyntaxQueryResolver.resolve(direccioGeneral, ctx.getContextInstance().getVariables());
        String cons=SyntaxQueryResolver.resolve(conselleria, ctx.getContextInstance().getVariables());
        
        IdentityManager idMgr=new IdentityManager();
        Collection directors=idMgr.obtenirUsuarisPerRolGrup(dg+"/IBK_DIRECTOR");
        Collection secretari=idMgr.obtenirUsuarisPerRolGrup(cons+"/IBK_SECRETARI");
        
        if(directors!=null && directors.size()>0)
        	return "DIRECTOR";
        else
        	if(secretari!=null)
        		return "SECRETARI";
        	else
        		throw new SystemWorkflowException("La Direcció General ("+dg+") no té assignat cap IBK_DIRECTOR i la conselleria ("+cons+") no té cap IBK_SECRETARI"); 
	}


}
