/**
 * 
 */
package es.caib.ibkey.bpm.mail;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import javax.naming.InitialContext;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Logger;

import es.caib.bpm.attachment.AttachmentManager;
import es.caib.bpm.beans.remote.Document;
import es.caib.ibkey.bpm.common.IBkeyConfig;
import es.caib.ibkey.bpm.custodia.handler.TicketCustodiaHandler;
import es.caib.ibkey.bpm.document.stage.StageManager;


/**
 * Envia un correo y continua la ejecución del workflow. El actionHandler Mail
 * de jbpm no hace un signal, y el proceso no continúa automáticamente.
 * 
 * @author u91940
 * 
 */
public class EnviarTiquetCustodiaHandler extends Mail {
	protected static Log log = LogFactory.getLog(EnviarTiquetCustodiaHandler.class);
	
	protected String nombreVariableTiquet=null;

	
	protected void sendMailInternal(Properties mailServerProperties, String fromAddress, List recipients, List bccRecipients, String subject, String text) throws Exception {
			sendMailInternal(mailServerProperties, fromAddress, recipients, bccRecipients, subject, text,nombreVariableTiquet);
	}
		
	
	protected void sendMailInternal(Properties mailServerProperties, String fromAddress, List recipients, List bccRecipients, String subject, String text,String attachment) throws Exception {
		debug("sending email to '" + recipients + "' " + (bccRecipients != null ? "and in bcc to '" + bccRecipients + "' " : "") + "about '" + subject + "'");
	    Session session =(Session) new InitialContext().lookup(IBkeyConfig.getIbkeyMailServiceJNDIAddress());//java:es.caib.ibkey.mail
	    MimeMessage message = new MimeMessage(session);
		if (fromAddress != null) {
			message.setFrom(new InternetAddress(fromAddress));
		}
		Iterator iter = recipients.iterator();
		while (iter.hasNext()) {
			InternetAddress recipient = new InternetAddress((String) iter.next());
			message.addRecipient(Message.RecipientType.TO, recipient);
		}
		if (bccRecipients != null) {
			iter = bccRecipients.iterator();
			while (iter.hasNext()) {
				InternetAddress recipient = new InternetAddress((String) iter.next());
				message.addRecipient(Message.RecipientType.BCC, recipient);
			}
		}
		if (subject != null) {
			message.setSubject(subject);
		}
		if (text != null) {
			message.setText(text);
		}
		message.setSentDate(new Date());

		// Create the message part
		BodyPart messageBodyPart1 = new MimeBodyPart();
		messageBodyPart1.setText(text);
		Multipart multipart = new MimeMultipart();
		multipart.addBodyPart(messageBodyPart1);

		// Part two is attachment

		BodyPart messageBodyPart2 = new MimeBodyPart();

			AttachmentManager attMgr=new AttachmentManager(executionContext.getContextInstance());
			Document document = attMgr.getDocument(nombreVariableTiquet);	
			document.openDownloadTransfer();
			ByteArrayOutputStream bos=new ByteArrayOutputStream();
			ByteArrayInputStream bis=null;
			
			byte bbuf[];
			try{
				do{
					bbuf=document.nextDownloadPackage(10240); //10K				
					if(bbuf!=null)
						bos.write(bbuf,0,bbuf.length);			
				}while(bbuf!=null);
				
				bis=new ByteArrayInputStream(bos.toByteArray());
			}catch(Exception e){
				error(e.getMessage(),e);
				throw e;
			}finally{
				bos.close();
			}
			try{
				DataSource source;
				source = new ByteArrayDataSource(bis, document.getMimeType());
	
				StageManager mgr=StageManager.getStageManager(executionContext);
				
				messageBodyPart2.setDataHandler(new DataHandler(source));
				messageBodyPart2.setFileName(mgr.getProcessName()+"-signat.html");
				messageBodyPart2.setDisposition(BodyPart.ATTACHMENT);
				multipart.addBodyPart(messageBodyPart2);
			
	
				// Put parts in message
				message.setContent(multipart);
				// Send the message
				Transport.send(message);
			}catch(Exception e){
				error(e.getMessage(),e);
				throw e;
			}finally{
				bis.close();
			
			}
	
	}


}