package es.caib.ibkey.bpm.oo.handlers;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Map;

import org.apache.log4j.Logger;
import org.jbpm.graph.exe.ExecutionContext;

import es.caib.bpm.toolkit.exception.UserWorkflowException;
import es.caib.ibkey.bpm.common.handler.AbstractIndexedHandler;
import es.caib.ibkey.bpm.conversion.exception.ConversionException;
import es.caib.ibkey.bpm.conversion.handler.ConversionHandler;
import es.caib.ibkey.oppenoffice.helper.OOReplaceFieldsHelper;

public class OOReplaceFieldsHandler extends AbstractIndexedHandler {

	private static final long serialVersionUID = 1L;
	private Map filterOptions=new Hashtable();
	
	/*variables que defineixen els codis dels paràmetres que utilitza el handler*/
	public String formatDeSortida=null;
	public String extensioDocumentSortida=null;

	

	protected File convertedDocument=null;
	protected File documentToConvert=null;
	private InputStream convertedStream;
	public String replacementTableCtxVarName=null;
	
	
	public void handleExecute(ExecutionContext ctx) throws Exception{
		Object table=null;
		
		//si la replacement table ve d'una variable de procés, la recuperem
		if(replacementTableCtxVarName instanceof String) table=(Object)ctx.getVariable(replacementTableCtxVarName);
		if (!(table instanceof Map)) throw new UserWorkflowException("ReplacementTable només pot ser un Map, o la sintaxis de resolució ha de resoldre a un Map"); 
		
		try{
			
			//per defecte PDF
			if(formatDeSortida==null){
				formatDeSortida="writer_pdf_Export";
				if(extensioDocumentSortida==null){
					extensioDocumentSortida=".pdf";
				}
			}
			
			OOReplaceFieldsHelper helper= new OOReplaceFieldsHelper();
			
			try{
					
					if(getInputObject()!=null){
		
						//creem el fitxer d'entrada, que ha de ser un titxer físic per a què l'openoffice el pugui processar
						documentToConvert=File.createTempFile(ctx.getProcessInstance().getId()+getStageAnterior().getName(),getMimeReg().getExtensionByContentType(getInputContentType()));
						documentToConvert.deleteOnExit();
						
						FileOutputStream outStr=null;
						try{
							outStr=new FileOutputStream(documentToConvert);
							outStr.write((byte[])getInputObject());
							outStr.flush();
						}catch(IOException th){
							throw th;
						}finally{
							if(outStr!=null)
								outStr.close();							
						}
						
						// Creem el fitxer de sortida, que ha de ser un titxer físic per a què l'openoffice el pugui processar				
						convertedDocument=File.createTempFile(ctx.getProcessInstance().getId()+getStageActual().getName(),extensioDocumentSortida);
						convertedDocument.deleteOnExit();
						
						
						//conversió de format
						helper.replaceFieldsAndConvert(documentToConvert,convertedDocument.getAbsolutePath(),(Map)table,formatDeSortida,filterOptions);
						
						//configurem el comportament abstracte
						//establim l'outputObject
						convertedStream=new BufferedInputStream(new FileInputStream(convertedDocument));
						setOutputObject(convertedStream);
						//establim l'outputContentType
						setOutputContentType(getMimeReg().getContentTypeByExtension(extensioDocumentSortida));
						//Establim l'outputOriginalName per al documentManager
						setOutputOriginalName(getOutputTag()+extensioDocumentSortida);
					}
				} catch(com.sun.star.uno.Exception e){
					throw new ConversionException(e);
		
				} catch (java.lang.Exception e) {
					error(e.getMessage(),e);
					throw e;
				}
		
		}catch (Exception ex){
			error(ex.getMessage(),ex);
			throw ex;
		}

	}
	

	protected void freeResources(ExecutionContext ctx) {
		try{
			if(convertedDocument!=null)convertedDocument.delete();
			if(convertedStream!=null)convertedStream.close();
		}catch(Throwable th){
			error(th.getMessage(),th);
		}
	}	


	protected void handleRollBack(ExecutionContext arg0) {
		// TODO Auto-generated method stub
		
	}

}
