package es.caib.ibkey.bpm.pdf.handler;


import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;

import java.awt.image.BufferedImage;
import java.io.File;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

import javax.imageio.ImageIO;

import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;

import com.sun.pdfview.PDFFile;
import com.sun.pdfview.PDFPage;


import es.caib.bpm.attachment.AttachmentManager;
import es.caib.bpm.exception.BPMException;
import es.caib.ibkey.bpm.common.handler.AbstractIndexedHandler;
import es.caib.ibkey.bpm.common.handler.LoggerActionHandler;
import es.caib.ibkey.bpm.document.stage.StageInfo;
import es.caib.ibkey.bpm.document.stage.StageManager;
import es.caib.ibkey.bpm.pdf.helper.PDFToImageHelper;

public class PDFToImageHandler extends LoggerActionHandler {


	public static final String COMPULSA_PREVIEW_IMAGE = "COMPULSA_PREVIEW_IMAGE";
	private static final String COMPULSA_HEIGHT = "COMPULSA_PREVIEW_IMAGE_HEIGHT";
	private static final String COMPULSA_WIDTH = "COMPULSA_PREVIEW_IMAGE_WIDTH";
	private static final String COMPULSA_OLD_HEIGHT = "COMPULSA_PREVIEW_OLD_IMAGE_HEIGHT";
	private static final String COMPULSA_OLD_WIDTH = "COMPULSA_PREVIEW_OLD_IMAGE_WIDTH";


	public float previewMaxHeight=800f;
	public float previewMaxWidth=800f;
	public int previewPage=0;


	public void execute(ExecutionContext ctx) throws Exception {
		super.execute(ctx);
		try{
			debug("PDFToImageHandler begin");
			//fichero temporal donde se almacena la imagen
			File cache=new File(System.getProperty("java.io.tmpdir")+"/"+ctx.getProcessInstance().getId()+"_preview.jpg");
			debug("Created file "+cache.getAbsolutePath());
			//si la imatge no existeix encara, la creem. Així millorem el rendiment en els casos en que la tasca no ha finalitzat.
			//És necessari crear un handler que s'encarreqgui d'esborrar la imatge una vegada el procediment ha finalitzat
			BufferedImage im_buf=null;
			
			ByteBuffer buf=ByteBuffer.wrap((byte[])StageManager.getInputObject(ctx));
			
			PDFFile pdffile = null;
			pdffile = new PDFFile(buf);
			
	        //cogemos la página
			PDFPage page =null;
			if(previewPage>=0)
				 page=pdffile.getPage(previewPage);
			else{
				
				page=pdffile.getPage(pdffile.getNumPages()+previewPage);
			}
			
			
			float oldWidth=page.getWidth();
			float oldHeight=page.getHeight();
			
			debug("Creating preview: dimensions "+previewMaxHeight+","+previewMaxWidth);
			if(!cache.exists()){
				im_buf=PDFToImageHelper.convertPDFToImage(page,previewMaxHeight,previewMaxWidth);
				PDFToImageHelper.saveImage(im_buf, cache.getAbsolutePath());
			}else{
					im_buf=ImageIO.read(cache);
			}
			
			ctx.setVariable(COMPULSA_PREVIEW_IMAGE, cache.getAbsolutePath());
			ctx.setVariable(COMPULSA_HEIGHT,new Integer(im_buf.getHeight()));
			ctx.setVariable(COMPULSA_WIDTH,new Integer(im_buf.getWidth()));
			ctx.setVariable(COMPULSA_OLD_HEIGHT,new Float(oldHeight));
			ctx.setVariable(COMPULSA_OLD_WIDTH,new Float(oldWidth));
			
			debug("Created preview: original dimensions "+oldHeight+","+oldWidth);
			debug("Created preview: destiny dimensions "+im_buf.getHeight()+","+im_buf.getWidth());
		}catch(Exception e){
			error(e.getMessage(), e);
			throw e;
		}
		ctx.getProcessInstance().signal();

	}





	protected void handleRollBack(ExecutionContext ctx) {
		//res a fer
	}




}
