/**
 * 
 */
package es.caib.ibkey.bpm.portafirma.handler;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.Properties;

import javax.activation.DataHandler;

import org.apache.axis.attachments.AttachmentPart;
import org.apache.log4j.Logger;
import org.jbpm.graph.exe.ExecutionContext;

import es.caib.ibkey.bpm.common.IBkeyConfig;
import es.caib.ibkey.bpm.common.handler.AbstractIndexedHandler;
import es.caib.ibkey.bpm.document.stage.StageInfo;
import es.caib.ibkey.bpm.document.stage.impl.StageInfoPortafirmasDownloadRequest;
import es.caib.ibkey.bpm.document.stage.impl.StageInfoPortafirmasUploadRequest;
import es.indra.www.portafirmasws.cws.CwsServiceLocator;
import es.indra.www.portafirmasws.cws.CwsStub;
import es.indra.www.portafirmasws.cws.DownloadRequest;
import es.indra.www.portafirmasws.cws.DownloadRequestDocument;
import es.indra.www.portafirmasws.cws.DownloadResponse;

/**
 * @author u91940
 *
 */
public class DownloadDocumentPortafirmasHandler extends AbstractIndexedHandler {
	
	/**
	 * configurem per defecte el handler, ja que no ha de tenir entrada del stage manager, sino del portafirmes.
	 */
	public void execute(ExecutionContext ctx) throws Exception {
		this.hasStageInput=new Boolean(false);
		this.inputContentType="application/pdf";
		super.execute(ctx);
	}
	
	protected void handleExecute(ExecutionContext ctx) throws Exception {	
		try{
			StageInfoPortafirmasDownloadRequest stageActual=(StageInfoPortafirmasDownloadRequest)getStageActual();
			
	
		    DownloadRequest request = new DownloadRequest();
	    	request.setApplication(
	    			new es.indra.www.portafirmasws.cws.Application(
	    					IBkeyConfig.getPortafirmasUser(), 
	    					IBkeyConfig.getPortafirmasPassword()));									
	    	DownloadRequestDocument requestDocument = new DownloadRequestDocument();
	    	
	    	//busquem l'upload stage associat per a obtenir l'id del document a baixar
	    	StageInfoPortafirmasUploadRequest uploadStage=(StageInfoPortafirmasUploadRequest)getStgMgr().find(stageActual.getUploadStageName());
	    	
	    	requestDocument.setId(uploadStage.getUploadedDocumentId()); 
	    	request.setDocument(requestDocument);
	    	request.setDownloadDocuments(Boolean.TRUE);
	    	request.setAdditionalInfo(Boolean.TRUE);
	    	
	    	// Se crea la conexion con el ws del portafirmas para solicitar el documento firmado
	    	CwsServiceLocator locator = new CwsServiceLocator();
	    	CwsStub stub = (CwsStub)locator.getCWS(new URL(IBkeyConfig.getPortafirmasWSEndpointAddress()));
	    	
	    	// Se recupera el documento firmado de la respuesta del ws
	    	DownloadResponse response = stub.downloadDocument(request);
	    	Iterator attachs = stub._getCall().getMessageContext().getCurrentMessage().getAttachments();
	    	AttachmentPart attach = (AttachmentPart) attachs.next();
	    	DataHandler dataH = attach.getActivationDataHandler();
	    	String attachPath = dataH.getName();
	    	if (dataH == null){
	    	 	//throw new ExcepcionDAO( "Problemas recuperando correctamente uno de los ficheros del Portafirmas");
	    	}
	    	File  documentFile = new File(attachPath);
	    	
			//inici de l'upload del document del portafirmes
	
	    	
	    	es.caib.bpm.beans.remote.Document remoteDoc = getAttMgr().createDocument("application/pdf",stageActual.getTag());
	
			remoteDoc.openUploadTransfer();
	    	
			BufferedInputStream in = null;
			
			try{
				in=new BufferedInputStream (new FileInputStream(documentFile));
				byte [] b = new byte [10240];
		        int read = in.read(b);
		        int blockCounter=0;
		         
		        while (read > 0){
		        	blockCounter++;
		         	
		         	remoteDoc.nextUploadPackage(b, read);
		            read = in.read(b);
		        }
		        
			}catch(Exception e){
				throw e;
			}finally{
				if(in!=null)in.close();
				if(remoteDoc!=null)remoteDoc.endUploadTransfer();
			}
			
	        getAttMgr().attach(stageActual.getTag(), remoteDoc);
	                    
	         //fi de l'upload
	    	attach.detachAttachmentFile();//pasa al siguiente fichero
	    	
	    	try{
	    		documentFile.delete();
	    	}catch(Exception oe){
	    		throw oe;
	    	}
	
	    	stageActual.setStatus(StageInfo.STATUS_DONE);
		    setOutputContentType("application/pdf");
		}catch(Exception e){
			error(e.getMessage(), e);
			throw e;
		}
	}

	/* (non-Javadoc)
	 * @see ibkey.bpm.common.AbstractIndexedHandler#handleRollBack(org.jbpm.graph.exe.ExecutionContext)
	 */
	protected void handleRollBack(ExecutionContext ctx) {
		//res a fer perque no hi ha outputObject

	}

	protected void freeResources(ExecutionContext ctx) {
		// TODO Auto-generated method stub
		
	}

}
