/**
 * 
 */
package es.caib.ibkey.bpm.portafirma.handler;

import java.io.ByteArrayOutputStream;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;

import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.util.ByteArrayDataSource;

import org.apache.log4j.Logger;
import org.jbpm.graph.exe.ExecutionContext;

import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.LDAPEntry;

import es.caib.bpm.attachment.AttachmentManager;
import es.caib.bpm.beans.remote.Document;
import es.caib.bpm.identity.seycon.IdentityManager;
import es.caib.bpm.identity.seycon.vo.User;

import es.caib.ibkey.bpm.common.IBkeyConfig;
import es.caib.ibkey.bpm.common.PropertiesFileUtil;
import es.caib.ibkey.bpm.common.handler.AbstractIndexedHandler;
import es.caib.ibkey.bpm.document.stage.StageInfo;
import es.caib.ibkey.bpm.document.stage.StageManager;
import es.caib.ibkey.bpm.document.stage.impl.StageInfoPortafirmasUploadRequest;
import es.indra.www.portafirmasws.cws.Annex;
import es.indra.www.portafirmasws.cws.Annexes;
import es.indra.www.portafirmasws.cws.Application;
import es.indra.www.portafirmasws.cws.CwsServiceLocator;
import es.indra.www.portafirmasws.cws.CwsStub;
import es.indra.www.portafirmasws.cws.Sender;
import es.indra.www.portafirmasws.cws.Signer;
import es.indra.www.portafirmasws.cws.UploadRequest;
import es.indra.www.portafirmasws.cws.UploadRequestDocument;
import es.indra.www.portafirmasws.cws.UploadResponse;
import es.indra.www.portafirmasws.cws.UploadStep;

/**
 * @author u91940
 *
 */
public class EnvioPortafirmasHandler extends AbstractIndexedHandler {

	/**
	 * 
	 */
	public EnvioPortafirmasHandler() {

	}

	
	public DataHandler getAttachment(String tag) throws Exception{
		//obtemim l'AttachmentManager associat al procés
		AttachmentManager am = this.getAttMgr();
        Document d = null;
        ByteArrayOutputStream theBAOS = null;
		try {
			//recuperem la referencia al document
			d = am.getDocument(tag);
			
			//si no hi ha referencia, retornem no trobat
	        if ( d == null) return null;
	        
	        //recuperem el document
	        d.openDownloadTransfer();
	        
	        theBAOS = new ByteArrayOutputStream(); 
	        
	        byte [] b;
	        b = d.nextDownloadPackage(8192);

	        //escribim el document a la sortida del servlet
	        while (b != null){
	            theBAOS.write(b, 0, b.length);
	            b = d.nextDownloadPackage(8192);
	        }
	        theBAOS.flush(); 
	        byte [] fileContent = theBAOS.toByteArray(); 
	        //	new String(fileContent)
			DataSource dataSource = new ByteArrayDataSource(fileContent,  d.getMimeType());
			DataHandler attachmentFile = new DataHandler(dataSource);  
	        
	        return attachmentFile;
	        
		} catch (Exception e) {			
			error(e.getMessage(),e);
			throw e;
		}  finally { 
			try{
			  if (theBAOS != null) theBAOS.close();
			}catch(Exception e){
				throw e;
				
			}finally{
				//tanquem la connexio de descarrega del document		        
				if(d != null) d.endDownloadTransfer();
			}
		}
	}
	
	
	/* (non-Javadoc)
	 * @see ibkey.bpm.common.AbstractIndexedHandler#handleExecute(org.jbpm.graph.exe.ExecutionContext)
	 */
	protected void handleExecute(ExecutionContext ctx) throws Exception {	
    	try{
			// Lectura de las credenciales de la aplicación del fichero de propiedades
			String pfiUser = IBkeyConfig.getPortafirmasUser();
			String pfiPass = IBkeyConfig.getPortafirmasPassword();
			
			// Se extrae la url donde está alojado el webservice, del fichero de propiedades	
			String urlWS = IBkeyConfig.getPortafirmasWSEndpointAddress();
			CwsServiceLocator locator=new CwsServiceLocator();
			CwsStub stub=(CwsStub) locator.getCWS(new URL(urlWS));
	
			//recuperamos el stage actual
	        StageInfoPortafirmasUploadRequest sip = (StageInfoPortafirmasUploadRequest)getStageActual();
	
			// Recuperar identificador del proceso para enviarlo como parte de la petición
			// para despues poder recuperarlo en el callback
			long idProcess = ctx.getProcessInstance().getId();
	
			
			//configuramos el uploadRequest
			Application application=new Application(pfiUser, pfiPass);
			UploadRequest request = new UploadRequest();
	        request.setApplication(application);
			UploadRequestDocument document = sip.getUploadRequestDocument(ctx);
			
			IdentityManager idMgr=new IdentityManager();

			User user=(User)idMgr.obtenirUsuariPerCodiUsuari((String)ctx.getVariable("initiator"));
			document.getAttributes().setSender(new Sender(user.getNom()+" "+user.getLlinatges(),user.getEmail()));
			
			document.getAttributes().setExternalData(String.valueOf(idProcess));
			
			//recuperamos el título del documento
			if(!"".equals(getStgMgr().getProcessName()) && getStgMgr().getProcessName()!=null){
				if(getStgMgr().getProcessName().length()>100){ //limitat a 100 caracters
					document.getAttributes().setTitle(getStgMgr().getProcessName().substring(0,100));
				}else{
					document.getAttributes().setTitle(getStgMgr().getProcessName());
				}
			}
			//recuperamos la descripción del documento
			if(getStgMgr().getDescription()==null)
				document.getAttributes().setDescription("");
			else
				document.getAttributes().setDescription(getStgMgr().getDescription());
				
			request.setDocument(document);	         
			document.getAttributes().setExtension("pdf");
			
			//Conevertir en array de bytes el input object
			byte[] bytes = null;
			if(this.getInputObject() instanceof byte[]){
				bytes = (byte[])this.getInputObject();
			}
			DataSource dataSource = new ByteArrayDataSource(bytes,  getInputContentType());
			DataHandler attachmentFile1 = new DataHandler(dataSource);  
		     	
			//Los documentos se env�an como adjuntos en el mensaje soap: 
		    
			// - Primero el documento a firmar
		    stub.addAttachment(attachmentFile1);  
	
		    // - Luego los adjuntos
		    StageManager stageManager = getStgMgr();
		    List attachmentsIdList = stageManager.getAttachmentTags();
		    Annexes annexes = new Annexes(new Annex[ attachmentsIdList.size()]);	    
		    Annex annex = null;
		    DataHandler attachmentFileAnn = null;
		    for(int i = 0; i < attachmentsIdList.size(); i++){
		    	String tag = (String)attachmentsIdList.get(i);
		    	annex = new Annex();
		    	annex.setDescription(tag);
		    	annex.setExtension(tag.substring(tag.lastIndexOf(".")+1));
		    	annex.setReference(stageManager.getProcessName()+tag);
		    	annex.setSender(document.getAttributes().getSender());
		    	annex.setSignAnnex(new Boolean(false));
		    	annex.setUrl("");
		    	
		    	annexes.setAnnex(i, annex); 
		    	
		    	attachmentFileAnn = this.getAttachment(tag);
		    	if(attachmentFileAnn != null) stub.addAttachment(attachmentFileAnn);
		    }
		    	    
		    if(annexes.getAnnex()!=null && annexes.getAnnex().length > 0) document.setAnnexes(annexes);
		   	    
		    UploadResponse response = stub.uploadDocument(request);

		    //important fer-ho avans de posar STATUS_DONE
		    setCallbackEventCounter(request,ctx);
		    
		    
		    sip.setUploadedDocumentId(response.getDocument().getId());
		    sip.setStatus(StageInfo.STATUS_DONE);
		    
		    setOutputContentType("application/pdf");
		    

		}catch(Exception e){
			error(e.getMessage(), e);
			throw e;
		}
	}

	private void setCallbackEventCounter(UploadRequest req, ExecutionContext ctx) {
		int counter=0;
		UploadRequestDocument doc=req.getDocument();
		for(int j=0;j<doc.getSteps().getStep().length;j++){
			
			UploadStep step=(UploadStep)doc.getSteps().getStep(j);
			Signer [] firmantsParalels=step.getSigners().getSigner();
			for(int k=0;k<firmantsParalels.length;k++){
				counter++;
			}
		}
		
		ctx.setVariable(StageInfoPortafirmasUploadRequest.PORTAFIRMAS_CALLBACK_COUNTER, new Integer(counter));
		
		
	}


	/* (non-Javadoc)
	 * @see ibkey.bpm.common.AbstractIndexedHandler#handleRollBack(org.jbpm.graph.exe.ExecutionContext)
	 */
	protected void handleRollBack(ExecutionContext ctx) {
		//res a fer perquè no hi ha outputObject

	}


	protected void freeResources(ExecutionContext ctx) {
		
	}

}
