package es.caib.ibkey.bpm.sap.handler;


import org.jbpm.graph.exe.ExecutionContext;

import es.caib.bpm.toolkit.exception.SystemWorkflowException;
import es.caib.ibkey.bpm.common.IBkeyConfig;
import es.caib.ibkey.bpm.sap.util.SAPConstants;
import es.caib.ibkey.bpm.sap.util.SAPManager;




public class ChangeStateExpedientHandler extends SAPAbstractActionHandler {
	
	public String codigoStateSAP = null;
	
	private static final String EXP_BLOQUETJAT = "El documento ha sido iniciado";
	private static final String EXP_REBUTJAT = "El documento ha sido rechazado";
	private static final String EXP_SIGNAT = "El documento ha sido firmado";
	private static final String EXP_ERROR = "El proceso de firma ha fallado: ";
	
	private String expcla = null;
	private String expeje = null;
	private String expnum = null;
	private String doceje = null;
	private String docnum = null;
	
	public String texto=null;
	/**
	 * 
	 */
	public ChangeStateExpedientHandler() {

	}
	
	private void changeStateSAP(ExecutionContext executionContext, String texto)  throws SystemWorkflowException{
		String s = null;
		try{
			// Recuperem les dades del expedient
			expcla = (String)executionContext.getVariable(SAPConstants.VAR_EXPCLA);
			expeje = (String)executionContext.getVariable(SAPConstants.VAR_EXPEJE);
			expnum = (String)executionContext.getVariable(SAPConstants.VAR_EXPNUM);
			doceje = (String)executionContext.getVariable(SAPConstants.VAR_DOCEJE);
			docnum = (String)executionContext.getVariable(SAPConstants.VAR_DOCNUM);
			
			// Recuperem les dades de conexio a sap configurats al jboss-service.xml 
			String user = IBkeyConfig.getSapUser();
			String pass = IBkeyConfig.getSapPassword();
			String host = IBkeyConfig.getSapHost();
			String client = IBkeyConfig.getSapClientId();
			String sys = IBkeyConfig.getSapSysId();
			
			SAPManager sap = new SAPManager(user, pass, host, client, sys, "es");
			
			sap.changeState(expcla, expeje, expnum, docnum, doceje, codigoStateSAP, texto);
		}catch(Throwable ex){
			error("Error al cambiar el estado en el sistema SAP: " + s, ex);
			throw new SystemWorkflowException ("Error al cambiar el estado en el sistema SAP:", ex);			
		}

	}

	public void handleExecute(ExecutionContext executionContext) throws SystemWorkflowException{				
		configuraTexto();
		changeStateSAP(executionContext, getTexto());			
		executionContext.getProcessInstance().signal();

	}

	protected void configuraTexto() {
		String codigo=getCodigoStateSAP();
		
		if( codigo!= null && texto==null){
			if("0".equals(codigo)) setTexto(ChangeStateExpedientHandler.EXP_BLOQUETJAT);
			if("1".equals(codigo)) setTexto(ChangeStateExpedientHandler.EXP_REBUTJAT);
		    if("2".equals(codigo) || "3".equals(codigo)) setTexto(ChangeStateExpedientHandler.EXP_SIGNAT);
		    if("9".equals(codigo)) setTexto(ChangeStateExpedientHandler.EXP_ERROR);
		}
		
	}

	/**
	 * @return the texto
	 */
	public synchronized String getTexto() {
		return texto;
	}

	/**
	 * @param texto the texto to set
	 */
	public synchronized void setTexto(String texto) {
		this.texto = texto;
	}

	/**
	 * @return the codigoStateSAP
	 */
	public synchronized String getCodigoStateSAP() {
		return codigoStateSAP;
	}

	/**
	 * @param codigoStateSAP the codigoStateSAP to set
	 */
	public synchronized void setCodigoStateSAP(String codigoStateSAP) {
		this.codigoStateSAP = codigoStateSAP;
	}
	
	

}