package es.caib.ibkey.bpm.sap.handler;

import java.rmi.RemoteException;
import java.util.Map;

import org.alfresco.www.ws.cml._1_0.CML;
import org.alfresco.www.ws.cml._1_0.CMLAddAspect;
import org.alfresco.www.ws.model.content._1_0.NamedValue;
import org.alfresco.www.ws.model.content._1_0.Predicate;
import org.alfresco.www.ws.model.content._1_0.Reference;
import org.alfresco.www.ws.model.content._1_0.Store;
import org.alfresco.www.ws.service.authentication._1_0.AuthenticationFault;
import org.alfresco.www.ws.service.content._1_0.ContentServiceSoapBindingStub;
import org.alfresco.www.ws.service.repository._1_0.GetStores;
import org.alfresco.www.ws.service.repository._1_0.RepositoryFault;
import org.alfresco.www.ws.service.repository._1_0.RepositoryServiceSoapBindingStub;
import org.alfresco.www.ws.service.repository._1_0.Update;
import org.alfresco.www.ws.service.repository._1_0.UpdateResult;
import org.jbpm.graph.exe.ExecutionContext;

import es.caib.bpm.toolkit.exception.SystemWorkflowException;
import es.caib.bpm.toolkit.exception.UserWorkflowException;
import es.caib.ibkey.alfresco.client.AlfrescoRepositoryClient;
import es.caib.ibkey.alfresco.ws.AuthenticationUtils;
import es.caib.ibkey.alfresco.ws.InternalErrorException;
import es.caib.ibkey.alfresco.ws.WebServiceFactory;
import es.caib.ibkey.alfresco.ws.WebServiceFactory.WebServiceFactoryConfig;
import es.caib.ibkey.bpm.common.IBkeyConfig;
import es.caib.ibkey.bpm.common.handler.AbstractIndexedHandler;
import es.caib.ibkey.bpm.document.stage.StageManager;
import es.caib.ibkey.bpm.document.stage.impl.StageInfoAlfrescoUploadFile;
import es.caib.ibkey.bpm.document.stage.impl.StageInfoCreateSapArchiveLink;
import es.caib.ibkey.bpm.sap.util.SAPManager;

/**
 * 
 * Passes:
 * 1-Mirar si el document existeix a la taula BKPF.
 * 2-Assignar l'aspecte al node del document d'alfresco.
 * 3-Cridar la RFC de SAP:  ARCHIV_CONNECTION_INSERT per a crear un archive-link
 * 4-Cridar la RFC de SAP ZSICODE_GEX04_ARC per a realitzar l'assignació entre el archive-link i el document.
 * @author u91940
 *
 */


public class CreateArchiveLinkToAlfrescoHandler extends AbstractIndexedHandler{
	
	public void execute(ExecutionContext ctx) throws Exception {
		this.hasStageInput=new Boolean(false);
		super.execute(ctx);
	}
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	public void handleExecute(ExecutionContext ctx) throws Exception {
		StageInfoCreateSapArchiveLink stage= (StageInfoCreateSapArchiveLink)getStageActual();
		
		Map variables=ctx.getContextInstance().getVariables();
		
		SAPManager sap = new SAPManager(
				IBkeyConfig.getSapUser()
				, IBkeyConfig.getSapPassword()
				, IBkeyConfig.getSapHost()
				, IBkeyConfig.getSapClientId()
				, IBkeyConfig.getSapSysId()
				, "es");		
		
		StageManager stgMgr=StageManager.getStageManager(ctx);

		StageInfoAlfrescoUploadFile uploadStage=null;
		String alfrescoDocumentId=null;
		String alfrescoStoreScheme=null;
		String alfrescoStoreAddress=null;
		String uploadStageTitle="";
		
		if(stage.getUploadStageName(variables)!=null){
			uploadStage=((StageInfoAlfrescoUploadFile)stgMgr.find(stage.getUploadStageName(variables)));
			uploadStageTitle=uploadStage.getDocumentTitle(variables);
			alfrescoDocumentId=uploadStage.getAlfrescoNodeRefId(ctx.getContextInstance().getVariables());
			alfrescoStoreScheme=uploadStage.getDocumentStoreScheme(ctx.getContextInstance().getVariables());
			alfrescoStoreAddress=uploadStage.getDocumentStoreAddress(ctx.getContextInstance().getVariables());
		}else{
			alfrescoDocumentId=stage.getArcDocId(variables);
			alfrescoStoreScheme=stage.getDocumentStoreScheme(variables);
			alfrescoStoreAddress=stage.getDocumentStoreAddress(variables);
		}
		uploadStageTitle+=(stage.getAppendDocumentTitle(variables)!=null)?stage.getAppendDocumentTitle(variables):"";
		
		//2-añade el aspecto del conector CTAC al documento alfresco
		asignarAspectoAlfresco(
				IBkeyConfig.getAlfrescoUser()
				,IBkeyConfig.getAlfrescoPassword()
				,alfrescoStoreScheme
				,alfrescoStoreAddress
				,IBkeyConfig.getAlfrescoIBkeySAPArchiveId()
				,alfrescoDocumentId);
		
		debug("Asignado aspecto de CTAC al nodo:"+alfrescoDocumentId);
		//3-crea el archivelink en SAP
		
/**		sap.creaArchiveLinkSAP(
				System.getProperty("es.caib.ibkey.sap.archiveId")
				, alfrescoDocumentId
				, stage.getArObject(variables)
				, System.getProperty("es.caib.ibkey.sap.client")
				, stage.getObjectId(variables)
				, stage.getSapObject(variables)
				, stage.getDocType(variables));
		debug("Creado archivelink al nodo:"+alfrescoDocumentId);
	**/	
		//4-substituye el documento SAP con el archivelink
		sap.appendArchiveLinkToExpedient(
				IBkeyConfig.getAlfrescoIBkeySAPArchiveId()
				, alfrescoDocumentId
				, stage.getArObject(variables)
				, stage.getObjectId(variables)
				, stage.getDocType(variables)
				, stage.getClasexp(variables)
				, stage.getEjexp(variables)
				, stage.getNumexp(variables)
				, uploadStageTitle
				);
		debug("Anexado al expediente archivelink al nodo:"+alfrescoDocumentId);
	}
	
	


	protected void asignarAspectoAlfresco( String alfrescoUser, String alfrescoPassword, String _documentStoreScheme, String _documentStoreAddress, String _archiveId ,String _arcDocId) throws Exception {
			//autentiquem agafant propietats de sistema
			Store store=null;
    		ContentServiceSoapBindingStub contentService=null;
			Reference currentFileRef=null;
			try {
				AuthenticationUtils.startSession(null,alfrescoUser, alfrescoPassword, 3600000);
				
				RepositoryServiceSoapBindingStub repo=null;
				repo=WebServiceFactory.getRepositoryService(null);

				
				Store stores[]=null;

				stores = repo.getStores(new GetStores());

				store = AlfrescoRepositoryClient.selectStore(stores,_documentStoreScheme,_documentStoreAddress);


					
					
	            currentFileRef=new Reference(store, _arcDocId, null );


    			contentService=WebServiceFactory.getContentService(null);

        		addNodeAspect(
        				null
        				,contentService
        				, store
        				, currentFileRef
        				,"{http://www.ctacpowerhouse.com/model/content/1.0}saparchivelinkaspect"
        				, new String []{
        						"{http://www.ctacpowerhouse.com/model/content/1.0}version"
        						,"{http://www.ctacpowerhouse.com/model/content/1.0}docprot"
        						,"{http://www.ctacpowerhouse.com/model/content/1.0}sapid"
        						,"{http://www.ctacpowerhouse.com/model/content/1.0}compid"
        						,"{http://www.ctacpowerhouse.com/model/content/1.0}archiveid"
        				}
        				,new String [] {
        						"0045"
        						,"crud"
        						,currentFileRef.getUuid()
        						,"data"
        						,_archiveId
        				}
        			);

			} catch (Exception e) {
				error(e.getMessage(),e);
				throw e;
			}finally{
		    	AuthenticationUtils.endSession(null);
		    }

		    		



	}

	/**
	 * cambia la propiedad de un nodo
	 * @param store
	 * @param reference
	 * @param mime 
	 * @param encoding 
	 * @throws InternalErrorException
	 */
	public void addNodeAspect(WebServiceFactoryConfig config,ContentServiceSoapBindingStub contentService,Store store,Reference reference,String aspect,String []property,String []value) throws Exception {
		
		
		NamedValue []props= new NamedValue[property.length];
		for(int i=0;i<property.length;i++){
			props[i]=new NamedValue(property[i], new Boolean(false), value[i], null);
		}			
		//a quien aplicar el aspecto
		Predicate predicate=new Predicate(new Reference[]{reference},null,null);
		//build the CML object
		CML cml = new CML();
		cml.setAddAspect(
				new CMLAddAspect[]{
						new CMLAddAspect(aspect, props, predicate,null)
						}
				);
		//perform a complete CML update
		UpdateResult[] result;
		try {
			result = WebServiceFactory.getRepositoryService(config).update(new Update(cml));
		} catch (RepositoryFault e) {
			error(e.getMessage(),e);
			throw e;
		} catch (RemoteException e) {
			error(e.getMessage(),e);
			throw e;
		} catch (InternalErrorException e) {
			error(e.getMessage(),e);
			throw e;
		}
		
		if(result== null || result.length==0 || result[result.length-1]==null){
			Exception e=new Exception("Alfresco Aspect not applied to path: "+reference.getPath()+" uuid:"+reference.getUuid());
			error(e.getMessage(),e);
			throw e;
		}
				
		
	}






	protected void freeResources(ExecutionContext ctx) {
		
	}



	protected void handleRollBack(ExecutionContext ctx) {
		
	}


	public static void main(String[] args) {
		SAPManager sap = new SAPManager(
				IBkeyConfig.getSapUser()
				, IBkeyConfig.getSapPassword()
				, IBkeyConfig.getSapHost()
				, IBkeyConfig.getSapClientId()
				, IBkeyConfig.getSapSysId()
				, "es");
		
		try {
			String pages[][]=sap.readTable(
					"TOAOM"
					, new String[]{
							"MANDT='210' AND"
							,"SAP_OBJECT='/GEX/TRAM2' AND"
							,"AR_STATUS='X' AND"
							,"AR_OBJECT='Z_ALF_HTML' AND"
							,"ARCHIV_ID='"+IBkeyConfig.getAlfrescoIBkeySAPArchiveId()+"' AND"
							,"DOC_TYPE='HTML'"
					}
					, new String[]{
					}
					);
			
			for(int i=0;i<pages.length;i++){
				String entries[][]=sap.readTable(
						pages[i][6] //connection
						, new String[]{
								"ARC_DOC_ID='367a6f72-c78f-428a-b736-f234fc5198c7' AND"
								,"MANDT='210' AND"
								,"SAP_OBJECT='/GEX/TRAM2' AND"
								,"AR_OBJECT='Z_ALF_HTML' AND"
								,"ARCHIV_ID='"+IBkeyConfig.getAlfrescoIBkeySAPArchiveId()+"' AND"
								,"DOC_TYPE='HTML'"
								
						}
						, new String[]{
						}
						);
				if(entries!=null && entries.length>0){
					throw new SystemWorkflowException("Ya existe una entrada");
				}
			}
		} catch (UserWorkflowException e) {
			e.printStackTrace();
		} catch (SystemWorkflowException e) {
			e.printStackTrace();
		}
		System.exit(0);
	}
}
