package es.caib.ibkey.bpm.sap.handler;

import java.io.IOException;
import java.util.Collection;
import java.util.Vector;

import javax.ejb.CreateException;
import javax.naming.NamingException;

import org.jbpm.graph.exe.ExecutionContext;

import es.caib.bpm.attachment.AttachmentManager;
import es.caib.bpm.beans.exception.DocumentBeanException;
import es.caib.bpm.beans.remote.Document;
import es.caib.bpm.exception.BPMException;
import es.caib.bpm.toolkit.exception.SystemWorkflowException;
import es.caib.ibkey.bpm.common.IBkeyConfig;
import es.caib.ibkey.bpm.document.stage.StageManager;
import es.caib.ibkey.bpm.sap.util.SAPConstants;
import es.caib.ibkey.bpm.sap.util.SAPManager;



public class RecuperarAnnexesExpedientHandler extends SAPAbstractActionHandler{	
	
	private String expcla = null;
	private String expeje = null;
	private String expnum = null;
	private String doceje = null;
	private String docnum = null;
	
	/**
	 * 
	 */
	public RecuperarAnnexesExpedientHandler() {

	}



	public void handleExecute(ExecutionContext ctx) throws SystemWorkflowException{
		try{
			// Recuperem les dades de conexio a sap configurats al jboss-service.xml
			String user = IBkeyConfig.getSapUser();
			String pass = IBkeyConfig.getSapPassword();
			String host = IBkeyConfig.getSapHost();
			String client = IBkeyConfig.getSapClientId();
			String sys = IBkeyConfig.getSapSysId();
			
			SAPManager sap = new SAPManager(user, pass, host, client, sys, "es");		
			expcla = (String)ctx.getVariable(SAPConstants.VAR_EXPCLA);
			expeje = (String)ctx.getVariable(SAPConstants.VAR_EXPEJE);
			expnum = (String)ctx.getVariable(SAPConstants.VAR_EXPNUM);
			doceje = (String)ctx.getVariable(SAPConstants.VAR_DOCEJE);
			docnum = (String)ctx.getVariable(SAPConstants.VAR_DOCNUM);
			
			//localitzem l'EJB amb els paràmetres definits al fitxer jndi.properties
		    StageManager stgMgr = (StageManager) ctx.getVariable(StageManager.CTX_VAR_NAME);
		    
		    es.caib.ibkey.utils.NamedContent[] anexosList = sap.getAnexos(expcla, expeje, expnum, docnum, doceje);
		    if(anexosList != null && anexosList.length > 0){
		    	for(int i = 0; i < anexosList.length; i++){	
		    		if(anexosList[i]!=null)
		    			uploadWorkflowDocument(ctx, anexosList[i].getMimeType(), anexosList[i].getContent(), anexosList[i].getName());
		    	}
		    }	
		    
			ctx.getContextInstance().setVariable(StageManager.CTX_VAR_NAME, null);
			ctx.getContextInstance().setVariable(StageManager.CTX_VAR_NAME, stgMgr);
			ctx.getProcessInstance().signal();
		} catch(Throwable  ex){	
			error(ex.getMessage(),ex);
			throw new SystemWorkflowException(ex);
		}

		
	}
	
	
	/**
	 * Puja un document, 
	 * l'associa a la tasca amb el tag "document" si és el document principal, sinó IdProcés+nomFitxer
	 * i actualitza el StageInfo de la tasca inicial si és document principal o el StageManager si és un attachment
	 * 
	 * @param fileContentBase64
	 * @param tag
	 * @param attMgr
	 * @param stageManager
	 * @param documentManagerContext
	 * @throws IOException
	 * @throws NamingException
	 * @throws CreateException
	 * @throws DocumentBeanException
	 * @throws InterruptedException
	 * @throws BPMException
	 */
	private void uploadWorkflowDocument(ExecutionContext ctx, String mime, byte[] decoded, String tag) 
				throws IOException, NamingException, CreateException, DocumentBeanException, 
					   InterruptedException, BPMException {
		
		
		
		//creem la representació del document
		AttachmentManager attMgr=new AttachmentManager(ctx.getContextInstance());
		Document doc= attMgr.createDocument(mime,tag);
		
		//iniciem la fase d'upload
		doc.openUploadTransfer();
        doc.nextUploadPackage(decoded, decoded.length);
		doc.endUploadTransfer();
		
		//Obtenim l'stageManager i l'StageInfo actual
		StageManager stgMgr=(StageManager)ctx.getContextInstance().getVariable(StageManager.CTX_VAR_NAME);
		if(stgMgr!=null){	
		 	//associem el document al tag
	        attMgr.attach(tag, doc);

	        //actualitzem la llista d'attachments de l'StageManager
	        Collection atts=stgMgr.getAttachmentTags();
	  		if(atts==null) atts=new Vector();
	  		atts.add(tag);
		}
			
		
	}




	
	


}