package es.caib.ibkey.bpm.sap.handler;

import java.util.Collection;

import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.mail.Mail;

import es.caib.bpm.toolkit.exception.SystemWorkflowException;
import es.caib.ibkey.bpm.common.handler.LoggerActionHandler;

public abstract class SAPAbstractActionHandler extends LoggerActionHandler {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	boolean handleRetry=false;
	
	public void execute(ExecutionContext executionContext) throws Exception {
		super.execute(executionContext);
		
		try{
			handleExecute(executionContext);
		}catch(Exception t){
			error(t.getMessage(),t);
			
			if(!handleRetry){
					throw t;
			}else{
				executionContext.getProcessInstance().signal("ERROR");
			}
		}
	}

	public abstract void handleExecute(ExecutionContext executionContext) throws SystemWorkflowException;


}
