package es.caib.ibkey.bpm.sap.handler;

import java.io.ByteArrayOutputStream;
import java.io.IOException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.graph.exe.ExecutionContext;

import es.caib.bpm.attachment.AttachmentManager;
import es.caib.bpm.beans.remote.Document;
import es.caib.bpm.toolkit.exception.SystemWorkflowException;
import es.caib.ibkey.bpm.common.IBkeyConfig;
import es.caib.ibkey.bpm.sap.util.SAPConstants;
import es.caib.ibkey.bpm.sap.util.SAPManager;

public class UploadTicketCustodiaHandler extends SAPAbstractActionHandler {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	protected static Log log = LogFactory.getLog(UploadTicketCustodiaHandler.class);
	
	protected String nombreVariableTiquet=null;
	
	private String expcla = null;
	private String expeje = null;
	private String expnum = null;
	private String doceje = null;
	private String docnum = null;
    

	public void handleExecute(ExecutionContext executionContext) throws SystemWorkflowException {
		ByteArrayOutputStream bos = null;
		debug("Inicio de subir el ticket de custodia a SAP");
		try{			
			// Recuperar ticket del DocumentManager
			AttachmentManager attMgr=new AttachmentManager(executionContext.getContextInstance());
			Document document = attMgr.getDocument(nombreVariableTiquet);	
			document.openDownloadTransfer();
			bos = new ByteArrayOutputStream();
			byte bbuf[];
			do{
				bbuf=document.nextDownloadPackage(10240); //10K				
				if(bbuf!=null)
					bos.write(bbuf,0,bbuf.length);			
			}while(bbuf!=null);
	
			String user = IBkeyConfig.getSapUser();
			String pass = IBkeyConfig.getSapPassword();
			String host = IBkeyConfig.getSapHost();
			String client = IBkeyConfig.getSapClientId();
			String sys = IBkeyConfig.getSapSysId();
			
			SAPManager sap = new SAPManager(user, pass, host, client, sys, "es");
			
			expcla = (String)executionContext.getVariable(SAPConstants.VAR_EXPCLA);
			expeje = (String)executionContext.getVariable(SAPConstants.VAR_EXPEJE);
			expnum = (String)executionContext.getVariable(SAPConstants.VAR_EXPNUM);
			doceje = (String)executionContext.getVariable(SAPConstants.VAR_DOCEJE);
			docnum = (String)executionContext.getVariable(SAPConstants.VAR_DOCNUM);
		    
			String encode = new sun.misc.BASE64Encoder().encode(bos.toString().getBytes("ISO-8859-1"));			
			// Enviar ticket codificado a SAP
			//sap.setTicket(expcla, expeje, expnum, docnum, doceje, bos.toString());
			sap.setTicket(expcla, expeje, expnum, docnum, doceje, encode);


		}catch(Throwable ex){
			throw new SystemWorkflowException(ex);
		}finally{
			if(bos != null)
				try {
					bos.close();
				} catch (IOException e) {
					log.error("No se ha podido cerrar correctamente la conexi�n con SAP: ", e);
				}
		}
		debug("Fin de subir el ticket de custodia a SAP");
		executionContext.getProcessInstance().signal();
	}

}
