package es.caib.ibkey.bpm.signers.handler;

import org.jbpm.graph.exe.ExecutionContext;

import es.caib.bpm.identity.seycon.IdentityManager;
import es.caib.ibkey.bpm.common.handler.LoggerActionHandler;
import es.caib.ibkey.bpm.sap.util.SAPConstants;


public class SignersMappedHandler extends LoggerActionHandler{

	public void execute(ExecutionContext executionContext) throws Exception {
		super.execute(executionContext);
	
		try{
			// Se recupera ol organo gestor derivado del word a firmar desde SAP
			String orgges = (String)executionContext.getVariable(SAPConstants.VAR_ORGGES);
			if(orgges == null || "".equals(orgges)){
				throw new Exception("No se ha recibido el organo gestor");
			}
			
			IdentityManager idMgr=new IdentityManager();
			
			String group = idMgr.obtenirGrupPerSeccioPressupostaria(orgges);
			
			executionContext.setVariable("seccioPressupostaria", group);	
		}catch(Exception e){
			error(e.getMessage(),e);
			throw e;
		}

		executionContext.getProcessInstance().signal();

	}

	
}
