package es.caib.ibkey.bpm.tasks;


import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

import org.apache.log4j.Logger;
import org.jbpm.command.GetTaskInstanceCommand;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zul.Iframe;

import es.caib.bpm.attachment.ProcessAttachmentManager;
import es.caib.bpm.attachment.TaskAttachmentManager;
import es.caib.bpm.beans.remote.Document;
import es.caib.bpm.toolkit.SignaturaHandler;
import es.caib.bpm.toolkit.WorkflowWindow;
import es.caib.bpm.toolkit.exception.UserWorkflowException;
import es.caib.bpm.toolkit.exception.WorkflowException;
import es.caib.ibkey.bpm.document.stage.StageInfo;
import es.caib.ibkey.bpm.document.stage.StageManager;
import es.caib.ibkey.bpm.document.stage.impl.StageInfoCertifyDigitalCopy;
import es.caib.ibkey.bpm.document.stage.impl.StageInfoFirmaPDFTask;
import es.caib.zkib.component.DataTextbox;


public class PreviewDocumentToCertifyDigitalCopyTask extends WorkflowWindow{
	
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;


	


	protected Iframe previewIframe=null;

	
	public PreviewDocumentToCertifyDigitalCopyTask() {
		super();
	}
	

	/**
	 * Quan s'ha carregat la pàgina:
	 * -carreguem a l'iframe el document de l'ultim stage completat 
	 */
	public void loadPDFIframe(Iframe iframe) {
//		System.out.println("*****************ONLOAD******************");
		StageManager stgMgr=(StageManager)getProcessInstance().getVariables().get(StageManager.CTX_VAR_NAME);
		StageInfo stgAnterior=(StageInfo)stgMgr.findLastCompletedStage();
	
		
		TaskAttachmentManager am = new TaskAttachmentManager(getTask());
		
		iframe.setSrc(am.getDownloadURL(stgAnterior.getTag()));
		
		previewIframe=iframe;
//		System.out.println("*****************FIN ONLOAD******************");
	};
	
	
	
	/**
	 * validaciones
	 */
	protected void prepareTransition(String transicionEjecutada) throws WorkflowException {
		super.prepareTransition(transicionEjecutada);
		
		//stages anterior i actual
		StageManager stgMgr=(StageManager)getProcessInstance().getVariables().get(StageManager.CTX_VAR_NAME);
		StageInfo stgInfoAnterior=stgMgr.findLastCompletedStage();
		String tagOrigen=stgInfoAnterior.getTag();
		//permetem forçar un stage en concret via la variable de tasca.
		String stageActualName=(String)getTask().getVariables().get("PreviewDocumentToCertifyDigitalCopyTask_stageActualName");
		StageInfoCertifyDigitalCopy stgInfoActual=null;
		
		if(stageActualName==null)
			stgInfoActual=(StageInfoCertifyDigitalCopy)stgMgr.findNextPendingStage();
		else
			stgInfoActual=(StageInfoCertifyDigitalCopy)stgMgr.find(stageActualName);
	
		String tagDesti=stgInfoActual.getTag();

		//si no té definit tag, el generem
		if(tagDesti==null){
			stgInfoActual.setTag(StageInfo.generateRandomCharSequence(20));
			tagDesti=stgInfoActual.getTag();
		}
		
		stgInfoActual.setPID(new Long(getProcessInstance().getId()));
		
		if (transicionEjecutada != null	&& transicionEjecutada.equals("Compulsa")) {
			
			try {

				
				log.debug("Traemos la interfaz HOME del documento.");
		
				HttpServletRequest request=(HttpServletRequest)Executions.getCurrent().getNativeRequest();
				request.getSession().setAttribute("ZKActualTask-"+getTask().getId(),getTask());
				
				
				// Generar applet
				Map processVariables=getProcessInstance().getVariables();
				stgInfoActual.setContentType("application/pdf");
				String url=stgInfoActual.getUrl(processVariables);
				
				float x=Float.parseFloat(stgInfoActual.getX(processVariables));
				float y=Float.parseFloat(stgInfoActual.getY(processVariables));
				float rotation=Float.parseFloat(stgInfoActual.getDegrees(processVariables));
				
				//localitat inicialment desconeguda
				//la localitat s'emmagatzema a una cookie
				//al tornar a entrar recuperem la localitat desde la cookie
				String location="";
				Cookie[] cookies = request.getCookies();
				 for(int i=0; i<cookies.length; i++) {
				      Cookie cookie = cookies[i];
				      if (SignaturaHandler.CERTIFY_LOCATION_COOKIEID.equals(cookie.getName()))
				        location=cookie.getValue();
				}

				previewIframe.setSrc("");
				getSignatureHandler().compulsaPDF(tagOrigen,tagDesti, url,location, x, y, rotation);

				
				
				stgInfoActual.setStatus(StageInfoFirmaPDFTask.STATUS_DONE);
				
				//update
				getTask().getVariables().put(StageManager.CTX_VAR_NAME, null);
				getTask().getVariables().put(StageManager.CTX_VAR_NAME, stgMgr);
				getEngine().update(getTask());
				//fin update
				
			} catch (Exception e) {
				Logger.getLogger(PreviewDocumentToCertifyDigitalCopyTask.class).error(e.getMessage(),e);
				throw new UserWorkflowException(e.getMessage());
			}

		
		}
		
	}

	/**
	 * download del document al stage completat i upload al stage per completar
	 * així firmem el tag de destí i no el d'entrada
	 * i el mecanisme de firma actualitza el de destí i no el d'entrada
	 * (mirar es.caib.bpm.servlet.DownloadServlet.doPut i es.caib.bpm.ui.SignatureManager.doSignPDF)
	 * 
	 * @param stgMgr
	 * @return Devuelve el tag del documento copiado que se tiene que firmar
	 * @throws Exception 
	 *
	private String prepareNewStageToBeSigned(StageManager stgMgr) throws Exception {
		StageInfo oldStage=stgMgr.findLastCompletedStage();
		StageInfo newStage=stgMgr.findNextPendingStage();
		
		String newTag=(newStage.getTag()!=null)?newStage.getTag():StageInfo.generateRandomCharSequence(10);
		newStage.setTag(newTag);
		
		
		try {
			oldDoc=File.createTempFile(getProcessInstance().getId()+"."+oldStage.getTag(),".pdf.tmp");
			newDoc=File.createTempFile(getProcessInstance().getId()+"."+newStage.getTag(),".pdf.tmp");
		} catch (Exception e) {
			if(oldDoc!=null) oldDoc.delete();
			
			Logger.getLogger(PreviewDocumentToSignTask.class).error(e.getMessage(),e);
			throw e;
		}	
			
			try {
				downloadDocument(oldStage,oldDoc);
					
				copyDocument(oldDoc,newDoc);
		
				//actualitzem la informació del nou stage a partir de la del anterior
				
				newStage.setContentType(oldStage.getContentType());
				newStage.setPID(new Long(getProcessInstance().getId()));
				
				uploadDocument(newStage,newDoc,newStage.getContentType());
			} catch (Exception e) {
				Logger.getLogger(PreviewDocumentToSignTask.class).error(e.getMessage(),e);
				
				throw e;
			}
			return newTag;

		
	}
	 */

	/**
	 * Upload d'un document al stage passat com a argument, i a la tasca associada a la finestra.
	 * No es marca com a stage completat per si ens interessa fer alguna cosa amb el fitxer
	 * 
	 * @param newStage
	 * @param newDoc
	 * @param mime
	 * @throws Exception
	 */
	private void uploadDocument(StageInfo newStage, File newDoc,String mime) throws Exception {
		ProcessAttachmentManager am = new ProcessAttachmentManager(getProcessInstance());
		BufferedInputStream in=null;

		try {
			in = new BufferedInputStream(new FileInputStream(newDoc));
		} catch (Exception e) {
			Logger.getLogger(PreviewDocumentToCertifyDigitalCopyTask.class).error(e.getMessage(),e);
			throw e;
		}

		//inici procés d'upload al document manager
		Document doc=null;
		try {
			doc = am.createDocument(mime,newStage.getTag());
			
					
		} catch (Exception e) {
			Logger.getLogger(PreviewDocumentToCertifyDigitalCopyTask.class).error(e.getMessage(),e);
			throw e;
		}
		
        
		byte [] b = new byte [10240];
		int read;
		try {

			doc.openUploadTransfer();
		
			read = in.read(b);
			while (read > 0)
			{
				doc.nextUploadPackage(b, read);
				read = in.read(b);
	         
			}
			//hacemos el attach del documento a las variables del proceso, ya que el StageManager trabaja con el ProcessAttachmentManager. 
			am.attach(newStage.getTag(), doc);

			
			//hacemos el attach del documento a las variables de la tarea, ya que el SignatureManager trabaja con el TaskAttachmentManager.
			TaskAttachmentManager tam=new TaskAttachmentManager(getTask());
			tam.attach(newStage.getTag(), doc); //tam.getDocument(newStage.getTag());

			getEngine().update(getTask());
		} catch (Exception e) {	
			Logger.getLogger(PreviewDocumentToCertifyDigitalCopyTask.class).error(e.getMessage(),e);
			
			//rollback de la creació del document
			doc.remove();
		}  finally{
			if(doc!=null)doc.endUploadTransfer();
			if(in!=null)in.close();
		}
	 
		
	}


	
	
	/**
	 * Copia de ficheros
	 * 
	 * @param oldDoc
	 * @param newDoc
	 * @throws Exception
	 */
	private void copyDocument(File oldDoc, File newDoc) throws Exception {
		InputStream in= null;
		OutputStream out= null;
		
		byte [] b = new byte [10240];
		int read;

		try {
			in= new BufferedInputStream(new FileInputStream(oldDoc));
			out=new BufferedOutputStream(new FileOutputStream(newDoc));
			
			read = in.read(b);
			while (read > 0)
			{	     	
				out.write(b,0,read);
				read = in.read(b); 
			}
		
			in.close();
			out.close();
			
		} catch (Exception e) {	
			Logger.getLogger(PreviewDocumentToCertifyDigitalCopyTask.class).error(e.getMessage(),e);
			throw e;
			
		}  finally{
			if(in!=null){ 
				try{
					in.close();
				}catch(Exception e){
					Logger.getLogger(PreviewDocumentToCertifyDigitalCopyTask.class).error(e.getMessage(),e);
					throw e;
				}finally{
					if(out!=null){ 
						try{
							out.close();
						}catch(Exception e){
							Logger.getLogger(PreviewDocumentToCertifyDigitalCopyTask.class).error(e.getMessage(),e);
							throw e;
						}
					}
				}
			}
		}
	 
		
	}



	private void downloadDocument(StageInfo oldStage, File oldDoc) throws Exception {
		OutputStream out=null;
		
		InputStream in = null;

		try{
		
			out=new BufferedOutputStream(new FileOutputStream(oldDoc));
			
			in = oldStage.getContentRetriever().getInputStream();  //java.io.FileOutputStream  a=new java.io.FileOutputStream("c:/util/ts_1.txt");int b; do {b=in.read();if(b!=-1)a.write(b);} while(b!=-1);a.close();
			
			int len=-1;
			byte buff[]=new byte[512];
			do{
				len=in.read(buff);
				if(len!=-1)
					out.write(buff,0,len);
			}while(len!=-1);
		}catch(Exception e){
			throw e;
		}finally{
			if(in!=null){ 
				try{
					in.close();
				}catch(Exception e){
					Logger.getLogger(PreviewDocumentToCertifyDigitalCopyTask.class).error(e.getMessage(),e);
					throw e;
				}finally{
					if(out!=null){ 
						try{
							out.close();
						}catch(Exception e){
							Logger.getLogger(PreviewDocumentToCertifyDigitalCopyTask.class).error(e.getMessage(),e);
							throw e;
						}
					}
				}
			}

		}
		
	}
	/**
	 * Quan es canvia de tab i es torna a la de la tasca, tornem a mostrar el preview del document a signar 
	 */
	public void onTaskTabSelected(String selectedId) {
		if(selectedId == null){
			log.warn("onTaskTabSelected:NULL tab selected");
			return;
		}
		
		if("tarea".equals(selectedId)){
			loadPDFIframe(previewIframe);
			
		}else{
			previewIframe.setSrc("");
		}
		
	}
	
	/**
	 * amaguem el preview per tal que no amagui la finestra de delegació
	 */
	public void onDelegationInit() {
		previewIframe.setSrc("");
	}
}
