package es.caib.ibkey.bpm.tasks;


import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.Iterator;
import java.util.Map;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

import org.apache.log4j.Logger;
import org.zkoss.zk.ui.Executions;

import es.caib.bpm.toolkit.SignaturaHandler;
import es.caib.bpm.toolkit.WorkflowWindow;
import es.caib.bpm.toolkit.exception.UserWorkflowException;
import es.caib.bpm.toolkit.exception.WorkflowException;
import es.caib.ibkey.bpm.document.stage.StageInfo;
import es.caib.ibkey.bpm.document.stage.StageManager;
import es.caib.ibkey.bpm.document.stage.impl.StageInfoCertifyDigitalCopy;
import es.caib.ibkey.bpm.document.stage.impl.StageInfoFirmaPDFTask;
import es.caib.ibkey.utils.ImageProxy;
import es.caib.ibkey.utils.PDFImageProxy;
import es.caib.zkib.zkiblaf.Stamp;


public class PreviewDocumentToCertifyDigitalCopyTask_V2 extends WorkflowWindow{
	
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;


	StageManager stgMgr=null;
	StageInfo stgInfoAnterior=null;
	String tagOrigen=null;
	String stageActualName=null;
	StageInfoCertifyDigitalCopy stgInfoActual=null;
	String tagDesti=null;
	float stampX=0.0f;
	float stampY=0.0f;
	float stampRotation=0.0f;
	
	int bgHeight=0;
	int bgWidth=0;
	
	Stamp stampElement=null;
	
	/** PREVIEW PARAMS **/
	protected int previewMaxHeight;
	protected int previewMaxWidth;
	
	private ImageProxy preview=null;
	
	public PreviewDocumentToCertifyDigitalCopyTask_V2() {
		super();
	}
	
	public void loadPDFPreview() throws Exception {
		Map processVariables=getProcessInstance().getVariables();
		//stages anterior i actual
		stgMgr=(StageManager)processVariables.get(StageManager.CTX_VAR_NAME);
		stgInfoAnterior=stgMgr.findLastCompletedStage();
		tagOrigen=stgInfoAnterior.getTag();
		//permetem forçar un stage en concret via la variable de tasca.
		stageActualName=(String)getProcessInstance().getVariables().get("PreviewDocumentToCertifyDigitalCopyTask_stageActualName");

		
		if(stageActualName==null)
			stgInfoActual=(StageInfoCertifyDigitalCopy)stgMgr.findNextPendingStage();
		else
			stgInfoActual=(StageInfoCertifyDigitalCopy)stgMgr.find(stageActualName);
	
		tagDesti=stgInfoActual.getTag();
		

		
		
		try{
			stampX=Float.parseFloat(stgInfoActual.getX(processVariables));
			stampY=Float.parseFloat(stgInfoActual.getY(processVariables));
			stampRotation=Float.parseFloat(stgInfoActual.getDegrees(processVariables));
		}catch(Exception e){
			Logger.getLogger(PreviewDocumentToCertifyDigitalCopyTask_V2.class).error(e.getMessage(),e);
			throw new UserWorkflowException(e);
		}
		
		
		//generem el preview
		preview=PDFImageProxy.getInstance((byte[])getInputObject(stgMgr),""+getProcessInstance().getId(),0, previewMaxHeight, previewMaxWidth);
		
		bgHeight=preview.getHeight().intValue();
		bgWidth=preview.getWidth().intValue();
		

		stampElement.setBgHeight(bgHeight);
		stampElement.setBgWidth(bgWidth);
		stampElement.setBgSrc("/ibkey/stamp-preview/"+getProcessInstance().getId()+"/0");
		stampElement.setStampSrc("/ibkey/compulsa_preview.gif");
		stampElement.setStampTop((int)stampY);
		stampElement.originalStampTop=new Integer((int)stampY);
		stampElement.setStampLeft((int)stampX);
		stampElement.originalStampLeft=new Integer((int)stampX);
		
		/*obtenim el tamany del preview:
		 * El document a acrobat a partir del qual obtenim la estapa de preview ocupa 910 pixels d'ample
		 * El preview obtingut ocupa 537 pixels d'ample
		 * El document que es previsualitza acabarà tenint una amplada de bgWidth pixels
		 * Hem de reduir el tamany del preview a la mateixa proporcio que el document pdf
		 * tamany_preview_ajustat=tamany_preview*factor d'escala
		 * on factor d'escala=tamany pdf previsualitzat / tamany pdf real 
		 */
		
		/*
		 * document vertical
		 * ADOBE 
		 * 1285*910
		 * 
		 * PDFViewer
		 * 842*595.5
		 * 
		 * PREVIEW
		 * 800*565
		 * 
		 * ITEXT
		 * 842*595
		 * 
		 */
		
		/*
		 * Estampa
		 * 
		 * Obtinguda d'adobe
		 * 105*537
		 * 
		 * preview
		 * 64*334
		 * 
		 * Itext
		 * 75*350
		 */
		if(bgHeight>bgWidth){
			stampElement.setStampWidth((int)(537.0f*((bgWidth)/910.0f))); 
			stampElement.setStampHeight((int)(105.0f*((bgWidth)/910.0f)));
		}else{
			stampElement.setStampWidth((int)(537.0f*((bgHeight)/910.0f))); 
			stampElement.setStampHeight((int)(105.0f*((bgHeight)/910.0f)));
		}
		
		
		
	}
	


	
	/**
	 * validaciones
	 */
	protected void prepareTransition(String transicionEjecutada) throws WorkflowException {
		super.prepareTransition(transicionEjecutada);
		

		
		if (transicionEjecutada != null	&& transicionEjecutada.equals("Compulsa")) {
			//si no té definit tag, el generem
			if(tagDesti==null){
				stgInfoActual.setTag(StageInfo.generateRandomCharSequence(20));
				tagDesti=stgInfoActual.getTag();
			}
			
			stgInfoActual.setPID(new Long(getProcessInstance().getId()));
					
			try {

								
		
				HttpServletRequest request=(HttpServletRequest)Executions.getCurrent().getNativeRequest();
				request.getSession().setAttribute("ZKActualTask-"+getTask().getId(),getTask());
				
				
				// Generar applet
				Map processVariables=getProcessInstance().getVariables();
				stgInfoActual.setContentType("application/pdf");
				String url=stgInfoActual.getUrl(processVariables);
				
				
				
				//localitat inicialment desconeguda
				//la localitat s'emmagatzema a una cookie
				//al tornar a entrar recuperem la localitat desde la cookie
				String location="";
				Cookie[] cookies = request.getCookies();
				 for(int i=0; i<cookies.length; i++) {
				      Cookie cookie = cookies[i];
				      if (SignaturaHandler.CERTIFY_LOCATION_COOKIEID.equals(cookie.getName()))
				        location=URLDecoder.decode(cookie.getValue());
				}
				
				//recuperamos el tamaño en que itext lo tratará
				com.lowagie.text.pdf.PdfReader reader=null;
				float itextHeight=1;
				float itextWidth=1;
				
				try{	
					reader = new com.lowagie.text.pdf.PdfReader(stgInfoAnterior.getContentRetriever().getInputStream());
					itextHeight=reader.getPageSize(1).getHeight();
					itextWidth=reader.getPageSize(1).getWidth();
					reader.close();
				}catch(IOException ioe){
					Logger.getLogger(PreviewDocumentToCertifyDigitalCopyTask_V2.class).error(ioe.getMessage(), ioe);
				}
				 

				//CALCULEM LA POSICIO DE LA ESTAMPA TORNANT AL TAMANY ORIGINAL DE LA IMATGE
				float previewResizeRatio=(preview.getWidth().intValue()<preview.getHeight().intValue())?((float)preview.getHeight().intValue())/itextHeight:((float)preview.getWidth().intValue())/itextWidth;
				//la nova posició no serà exacta, degut als redondeigs del tamany de la imatge durant les transformacions 
				stampY=(stampElement.getBgHeight()-stampElement.getStampTop()-stampElement.getStampHeight())/previewResizeRatio;
				stampX=(stampElement.getStampLeft()/previewResizeRatio); 

				//controlem els límits per tal que la imatge no caigui fora
				if(stampX<0) stampX=0;
				else if(stampX>(itextWidth-350)) stampX=itextWidth-350.0f; //350 es el tamany de la estampa
				
				if(stampY<0) stampY=0;
				else if(stampY>(itextHeight-75)) stampY=(itextHeight-75); //75 es el tamany de la estampa
				
				getSignatureHandler().compulsaPDF(tagOrigen,tagDesti, url,location, stampX, stampY, stampRotation);

				
				
				stgInfoActual.setStatus(StageInfoFirmaPDFTask.STATUS_DONE);
				
				//update
				getTask().getVariables().put(StageManager.CTX_VAR_NAME, null);
				getTask().getVariables().put(StageManager.CTX_VAR_NAME, stgMgr);
				getEngine().update(getTask());
				//fin update
				
			} catch (Exception e) {
				Logger.getLogger(PreviewDocumentToCertifyDigitalCopyTask_V2.class).error(e.getMessage(),e);
				throw new UserWorkflowException(e.getMessage());
			}

		
		}
		//esborrem els previews una vegada acabada la tasca
		try{
			preview.delete();
		}catch(FileNotFoundException fne){}
	}



	/**
	 * Quan es canvia de tab i es torna a la de la tasca, tornem a mostrar el preview del document a signar 
	 */
	public void onTaskTabSelected(String selectedId) {

		
	}
	
	/**
	 * amaguem el preview per tal que no amagui la finestra de delegació
	 */
	public void onDelegationInit() {

	}

	
	protected static byte[] getInputObject(StageManager stgMgr) throws Exception {
		
		//Obtenim l'stageManager i l'StageInfo actual
	
		StageInfo stageAnterior = stgMgr.findLastCompletedStage();
		InputStream in = stageAnterior.getContentRetriever().getInputStream();
		ByteArrayOutputStream outputStream=new ByteArrayOutputStream();
		try{
			int len=-1;
			byte buff[]=new byte[512];
			do{
				len=in.read(buff);
				if(len!=-1)
					outputStream.write(buff,0,len);
			}while(len!=-1);
		}catch(Exception e){
			throw e;
		}finally{
			in.close();
		}

		return outputStream.toByteArray();

	}
	
	/**
	 * @return the stampElement
	 */
	public synchronized Stamp getStampElement() {
		return stampElement;
	}

	/**
	 * @param stampElement the stampElement to set
	 */
	public synchronized void setStampElement(Stamp stampElement) {
		this.stampElement = stampElement;
	}
	
	

	/**
	 * @param previewMaxHeight the previewMaxHeight to set
	 */
	public synchronized void setPreviewMaxHeight(int previewMaxHeight) {
		this.previewMaxHeight = previewMaxHeight;
	}

	/**
	 * @param previewMaxWidth the previewMaxWidth to set
	 */
	public synchronized void setPreviewMaxWidth(int previewMaxWidth) {
		this.previewMaxWidth = previewMaxWidth;
	}

}
