package es.caib.ibkey.bpm.tasks;


import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

import javax.servlet.http.HttpServletRequest;

import org.apache.log4j.Logger;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Path;
import org.zkoss.zul.Checkbox;
import org.zkoss.zul.Iframe;
import org.zkoss.zul.Vbox;
import org.zkoss.zul.Window;

import com.sun.pdfview.PDFFile;
import com.sun.pdfview.PDFPage;


import es.caib.bpm.attachment.ProcessAttachmentManager;
import es.caib.bpm.attachment.TaskAttachmentManager;
import es.caib.bpm.beans.remote.Document;
import es.caib.bpm.toolkit.WorkflowWindow;
import es.caib.bpm.toolkit.exception.UserWorkflowException;
import es.caib.bpm.toolkit.exception.WorkflowException;
import es.caib.ibkey.bpm.document.stage.StageInfo;
import es.caib.ibkey.bpm.document.stage.StageManager;
import es.caib.ibkey.bpm.document.stage.impl.StageInfoFirmaPDFPosicionada;
import es.caib.ibkey.bpm.document.stage.impl.StageInfoFirmaPDFTask;
import es.caib.ibkey.bpm.pdf.handler.PDFToImageHandler;
import es.caib.ibkey.bpm.pdf.helper.PDFToImageHelper;
import es.caib.ibkey.bpm.tasks.PreviewDocumentToCertifyDigitalCopyTask_V2;
import es.caib.ibkey.utils.ImageProxy;
import es.caib.ibkey.utils.PDFImageProxy;
import es.caib.zkib.zkiblaf.Stamp;


public class PreviewDocumentToSignTaskV2 extends WorkflowWindow{
	
	private static final long serialVersionUID = 1L;
	
	/** CONSTANTS **/
	public final static String STAMP_TYPE_ALL="ALL";
	public final static String STAMP_TYPE_ADOBE="ADOBE";
	public final static String STAMP_TYPE_PDF417="PDF417";
	public final static String STAMP_TYPE_NONE="NONE";

	public final static String STAMP_POSITION_ALL_TOP="TOP";
	public final static String STAMP_POSITION_ADOBE_TOP_LEFT="TOP_LEFT";
	public final static String STAMP_POSITION_ADOBE_TOP_RIGHT="TOP_RIGHT";
	public final static String STAMP_POSITION_PDF417_LEFT="LEFT";
	public final static String STAMP_POSITION_PDF417_RIGHT="RIGHT";
	public final static String STAMP_POSITION_ALL_BOTTOM="BOTTOM";
	public final static String STAMP_POSITION_ADOBE_BOTTOM_LEFT="BOTTOM_LEFT";
	public final static String STAMP_POSITION_ADOBE_BOTTOM_RIGHT="BOTTOM_RIGHT";
	
	/** STAGE VARS **/
	public StageManager stgMgr=null;
	
	/** ZUL VARS **/
	Stamp stampElement=null;
	
	/** SIGN VARS **/
	protected String enabledStampType=null;
	protected String[] enabledPositions=null;
	protected String forcedAdditionalText=null;
	protected float stampTop=0.0f;
	protected float stampLeft=0.0f;
	protected float stampHeight=50;
	protected float stampWidth=260;
	protected float stampRotation=0.0f;
	
	
	protected String documentURL;

	/** PREVIEW PARAMS **/
	protected int previewMaxHeight;
	protected int previewMaxWidth;
	

	/** PREVIEW VARS **/
	protected Map previews=new HashMap();  
	protected int selectedPreview=0;

	

	
	
	public PreviewDocumentToSignTaskV2() {
		super();
	}
	
	public void onCreateTask() throws Exception {
	
		stgMgr=(StageManager)getProcessInstance().getVariables().get(StageManager.CTX_VAR_NAME);
		previews.put(new Integer(0) ,generatePreview((byte[])getInputObject(stgMgr),0));
		previews.put(new Integer(-1),generatePreview((byte[])getInputObject(stgMgr),-1));
		
		StageInfo stgAnterior=(StageInfo)stgMgr.findLastCompletedStage();
		StageInfoFirmaPDFPosicionada stgActual=(StageInfoFirmaPDFPosicionada)stgMgr.findNextPendingStage();
		
		this.enabledPositions=stgActual.getEnabledPositions();
		this.enabledStampType=stgActual.getEnabledStampType();
		this.forcedAdditionalText=stgActual.getForcedAdditionalText();
		
		Map processVariables=getProcessInstance().getVariables();
		TaskAttachmentManager am = new TaskAttachmentManager(getTask());
		documentURL=am.getDownloadURL(stgAnterior.getTag());
		
		
		if(enabledPositions!=null && enabledPositions.length>0 && enabledPositions[0].equals("LAST_PAGE")){
			Window windowFirma = (Window) Path.getComponent("//windowPDF");
			((Vbox)windowFirma.getFellow("paginaEstampa")).setVisible(false);
			selectedPreview=-1;
			
		}

		//si tenemos un valor establecido lo sobreescribimos
		if(stgActual.getTop()!=null)
			stampTop=stgActual.getTop().floatValue();
		if(stgActual.getLeft()!=null)
			stampLeft=stgActual.getLeft().floatValue();
		
		showStamp("/ibkey/adobe_signature_widget_preview.gif",(int)stampTop,(int)stampLeft);
		showImagePreview(selectedPreview);
		
				
		
//		System.out.println("*****************FIN ONLOAD******************");
	};
	
	
	
	private ImageProxy generatePreview(byte [] content,int page) throws Exception {
		return PDFImageProxy.getInstance(content,""+getProcessInstance().getId(),page, previewMaxHeight, previewMaxWidth);
	}

	public void showStamp(String src,int top, int left) {
		stampElement.setStampSrc(src);
		stampElement.setStampTop(top);
		stampElement.setStampLeft(left);
		stampElement.originalStampTop=new Integer(top);
		stampElement.originalStampLeft=new Integer(left);
	}

	public void showImagePreview(int page) throws Exception {
		ImageProxy preview=generatePreview((byte[])getInputObject(stgMgr),page);
		stampElement.setBgHeight(preview.getHeight().intValue());
		stampElement.setBgWidth(preview.getWidth().intValue());
		stampElement.setBgSrc("/ibkey/stamp-preview/"+getProcessInstance().getId()+"/"+page);
		/*obtenim el tamany del preview:
		 * El document a acrobat a partir del qual obtenim la estapa de preview ocupa 910 pixels d'ample
		 * El preview obtingut ocupa x pixels d'ample
		 * El document que es previsualitza acabarà tenint una amplada de bgWidth pixels
		 * Hem de reduir el tamany del preview a la mateixa proporcio que el document pdf
		 * tamany_preview_ajustat=tamany_preview*factor d'escala
		 * on factor d'escala=tamany pdf previsualitzat / tamany pdf real 
		 */
		
		/*
		 * document vertical
		 * ADOBE 
		 * 1285*910 / 1212*936
		 * 
		 * PDFViewer
		 * 842*595.5 / 792*612
		 * *
		 * PREVIEW
		 * 800*565
		 * 
		 * ITEXT
		 * 842*595 / 792*612
		 * 
		 */
		
		/*
		 * Estampa
		 * 
		 * Obtinguda d'adobe
		 * 54*405
		 * 
		 * preview
		 * 18*137
		 * 
		 * Itext
		 * 50*200
		 */
		if(preview.getHeight().intValue()>preview.getWidth().intValue()){
			stampElement.setStampWidth((int)(405.0f*((preview.getWidth().intValue())/910.0f))); 
			stampElement.setStampHeight((int)(54.0f*((preview.getWidth().intValue())/910.0f)));
		}else{
			stampElement.setStampWidth((int)(405.0f*((preview.getHeight().intValue())/910.0f))); 
			stampElement.setStampHeight((int)(54.0f*((preview.getHeight().intValue())/910.0f)));
		}
	}

	



	/**
	 * validaciones
	 */
	protected void prepareTransition(String transicionEjecutada) throws WorkflowException {
		super.prepareTransition(transicionEjecutada);
		ImageProxy preview=(ImageProxy)previews.get(new Integer(selectedPreview));
		//stages anterior i actual
		StageInfo stgInfoAnterior=stgMgr.findLastCompletedStage();
		String tagOrigen=stgInfoAnterior.getTag();
		StageInfo stgInfoActual=stgMgr.findNextPendingStage();
		String tagDesti=stgInfoActual.getTag();

		//si no té definit tag, el generem
		if(tagDesti==null){
			stgInfoActual.setTag(StageInfo.generateRandomCharSequence(20));
			tagDesti=stgInfoActual.getTag();
		}
		
		stgInfoActual.setPID(new Long(getProcessInstance().getId()));
		
		if (transicionEjecutada != null	&& transicionEjecutada.toLowerCase().contains("signa")) {
			
			log.debug("Traemos la interfaz HOME del documento.");
			
			try {
				//ocultamos el preview para que la ventana de firma no aparezca por debajo del iframe
				HttpServletRequest request=(HttpServletRequest)Executions.getCurrent().getNativeRequest();
				request.getSession().setAttribute("ZKActualTask-"+getTask().getId(),getTask());
				
				
				
				
				//recuperamos el tamaño en que itext lo tratará
				com.lowagie.text.pdf.PdfReader reader=null;
				float itextHeight=1;
				float itextWidth=1;
				
				try{	
					reader = new com.lowagie.text.pdf.PdfReader(stgInfoAnterior.getContentRetriever().getInputStream());
					itextHeight=reader.getPageSize(1).getHeight();
					itextWidth=reader.getPageSize(1).getWidth();
					reader.close();
				}catch(IOException ioe){
					Logger.getLogger(PreviewDocumentToCertifyDigitalCopyTask_V2.class).error(ioe.getMessage(), ioe);
				}
				 

				//CALCULEM LA POSICIO DE LA ESTAMPA TORNANT AL TAMANY ORIGINAL DE LA IMATGE
				//itextWidth/itextHeight
				float previewResizeRatio=(preview.getWidth().intValue()<preview.getHeight().intValue())?((float)preview.getHeight().intValue())/itextHeight:((float)preview.getWidth().intValue())/itextWidth;
				//la nova posició no serà exacta, degut als redondeigs del tamany de la imatge durant les transformacions 
				float stampTop=(stampElement.getBgHeight()-stampElement.getStampTop())/previewResizeRatio;
				float stampLeft=(stampElement.getStampLeft()/previewResizeRatio); 

				//controlem els límits per tal que la imatge no caigui fora
				if(stampLeft<0) stampLeft=0;
				else if(stampLeft>(itextWidth-265)) stampLeft=itextWidth-265.0f; //265 es el tamany de la estampa itext
				
				if(stampTop<0) stampTop=0;
				else if(stampTop>(itextHeight)) stampTop=(itextHeight);

				//comprobem si hem d'estampar la ultima pagina

				if(((Checkbox)getFellow("paginaEstampaLast")).isChecked())enabledPositions=new String []{"LAST_PAGE"};
				
				// Generar applet
				getSignatureHandler().signPDF(tagOrigen,tagDesti,enabledStampType,enabledPositions,stampTop,stampLeft,stampHeight,stampWidth,stampRotation,forcedAdditionalText);

				
				stgInfoActual.setContentType("application/pdf");
				
				stgInfoActual.setStatus(StageInfoFirmaPDFTask.STATUS_DONE);
				
				//update
				getTask().getVariables().put(StageManager.CTX_VAR_NAME, null);
				getTask().getVariables().put(StageManager.CTX_VAR_NAME, stgMgr);
				getEngine().update(getTask());
				//fin update
				
				
				
			} catch (Exception e) {
				Logger.getLogger(PreviewDocumentToSignTaskV2.class).error(e.getMessage(),e);		
				throw new UserWorkflowException(e.getMessage());
			}

		
		}
		
		
		//esborrem els previews una vegada acabada la tasca
		Iterator it=previews.keySet().iterator();
		while(it.hasNext()){
			try{
				ImageProxy image=((ImageProxy)previews.get(it.next()));
				image.delete();
			}catch(FileNotFoundException fne){}
		}
	
		
	}


	protected static byte[] getInputObject(StageManager stgMgr) throws Exception {
		
		//Obtenim l'stageManager i l'StageInfo actual
	
		StageInfo stageAnterior = stgMgr.findLastCompletedStage();
		InputStream in = stageAnterior.getContentRetriever().getInputStream();
		ByteArrayOutputStream outputStream=new ByteArrayOutputStream();
		try{
			int len=-1;
			byte buff[]=new byte[512];
			do{
				len=in.read(buff);
				if(len!=-1)
					outputStream.write(buff,0,len);
			}while(len!=-1);
		}catch(Exception e){
			throw e;
		}finally{
			in.close();
		}

		return outputStream.toByteArray();

	}
	
	
	private void error(String message, Exception e) {
		Logger.getLogger(PreviewDocumentToSignTaskV2.class).error(message,e);
		
	}
	private void debug(String string) {
		Logger.getLogger(PreviewDocumentToSignTaskV2.class).debug(string);
		
	}

	
	
	/**
	 * @return the stampElement
	 */
	public synchronized Stamp getStampElement() {
		return stampElement;
	}

	/**
	 * @param stampElement the stampElement to set
	 */
	public synchronized void setStampElement(Stamp stampElement) {
		this.stampElement = stampElement;
	}

	/**
	 * @param previewMaxHeight the previewMaxHeight to set
	 */
	public synchronized void setPreviewMaxHeight(int previewMaxHeight) {
		this.previewMaxHeight = previewMaxHeight;
	}

	/**
	 * @param previewMaxWidth the previewMaxWidth to set
	 */
	public synchronized void setPreviewMaxWidth(int previewMaxWidth) {
		this.previewMaxWidth = previewMaxWidth;
	}

	/**
	 * @param stampHeight the stampHeight to set
	 */
	public synchronized void setStampHeight(float stampHeight) {
		this.stampHeight = stampHeight;
	}

	/**
	 * @param stampWidth the stampWidth to set
	 */
	public synchronized void setStampWidth(float stampWidth) {
		this.stampWidth = stampWidth;
	}

	/**
	 * @return the selectedPreview
	 */
	public synchronized int getSelectedPreview() {
		return selectedPreview;
	}

	/**
	 * @param selectedPreview the selectedPreview to set
	 */
	public synchronized void setSelectedPreview(int selectedPreview) {
		this.selectedPreview = selectedPreview;
	}

	/**
	 * @return the stampTop
	 */
	public synchronized float getStampTop() {
		return stampTop;
	}

	/**
	 * @param stampTop the stampTop to set
	 */
	public synchronized void setStampTop(float stampTop) {
		this.stampTop = stampTop;
	}

	/**
	 * @return the stampWidth
	 */
	public synchronized float getStampWidth() {
		return stampWidth;
	}

	


}
