package es.caib.ibkey.bpm.tasks;


import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

import javax.servlet.http.HttpServletRequest;

import org.apache.log4j.Logger;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zul.Iframe;

import es.caib.bpm.attachment.ProcessAttachmentManager;
import es.caib.bpm.attachment.TaskAttachmentManager;
import es.caib.bpm.beans.remote.Document;
import es.caib.bpm.toolkit.WorkflowWindow;
import es.caib.bpm.toolkit.exception.UserWorkflowException;
import es.caib.bpm.toolkit.exception.WorkflowException;
import es.caib.ibkey.bpm.document.stage.StageInfo;
import es.caib.ibkey.bpm.document.stage.StageManager;
import es.caib.ibkey.bpm.document.stage.impl.StageInfoFirmaPDFTask;


public class SLCSignTask extends WorkflowWindow{
	
	

	protected String enabledStampType=null;
	protected String[] enabledPositions=null;
	protected String forcedAdditionalText=null;


	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;


	private String documentURL;
	
	public SLCSignTask() {
		super();
	}
	

	
	
	
	/**
	 * validaciones
	 */
	protected void prepareTransition(String transicionEjecutada) throws WorkflowException {
		super.prepareTransition(transicionEjecutada);
		
		//stages anterior i actual
		StageManager stgMgr=(StageManager)getProcessInstance().getVariables().get(StageManager.CTX_VAR_NAME);
		StageInfo stgInfoAnterior=stgMgr.findLastCompletedStage();
		String tagOrigen=stgInfoAnterior.getTag();


		
		if (transicionEjecutada != null	&& transicionEjecutada.equals("Signa")) {
			
			log.debug("Traemos la interfaz HOME del documento.");
			
			try {
				//ocultamos el preview para que la ventana de firma no aparezca por debajo del iframe
			
				HttpServletRequest request=(HttpServletRequest)Executions.getCurrent().getNativeRequest();
				request.getSession().setAttribute("ZKActualTask-"+getTask().getId(),getTask());
				// Generar applet
				getSignatureHandler().sign(tagOrigen);
				
				
				
			} catch (Exception e) {
				Logger.getLogger(SLCSignTask.class).error(e.getMessage(),e);		
				throw new UserWorkflowException(e.getMessage());
			}finally{
			}

		
		}
		
	}



	
	/**
	 * Quan es canvia de tab i es torna a la de la tasca, tornem a mostrar el preview del document a signar 
	 */
	public void onTaskTabSelected(String selectedId) {

		
	}
	
	/**
	 * amaguem el preview per tal que no amagui la finestra de delegació
	 */
	public void onDelegationInit() {

	}

}
