package es.caib.ibkey.signer.web;

import java.io.IOException;
import java.io.UnsupportedEncodingException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class HttpRequestUTF8 implements Filter{
	
	private HttpServletRequest request;
	
	public HttpRequestUTF8(HttpServletRequest req) {
		
		request = req;
		
	}
	
	


	public void destroy() {
		// TODO Auto-generated method stub
		
	}


	public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
		ServletRequest wrapper=new HTTPServletRequestUTF8Wrapper((HttpServletRequest)request);
		chain.doFilter(wrapper, response);
		
	}

	public void init(FilterConfig filterConfig) throws ServletException {
		// TODO Auto-generated method stub
		
	}
	
	class HTTPServletRequestUTF8Wrapper extends HttpServletRequestWrapper{
	    
		public HTTPServletRequestUTF8Wrapper(HttpServletRequest request) {
	        super(request);
	    }
		

		public String getParameter(String name) {
			
			return getUTF8Parameter(name);
		}
		
		public String getUTF8Parameter(String paramName) {
			
			String encoding = super.getCharacterEncoding();
			String parameter = super.getParameter(paramName);
			
			try {
			
				if (encoding == null) {
					
					// Suponemos ISO8859-1, por estándar
					return new String( parameter.getBytes("ISO-8859-1"), "UTF-8" );
					
				} else {
					
					return new String( parameter.getBytes( encoding ), "UTF-8" );
								
				}
				
			} catch (UnsupportedEncodingException uee) {
				
				uee.printStackTrace();
				return parameter;
				
			}
					
		}
		
	}

}