package es.caib.ibkey.web.test;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import java.util.HashMap;
import java.util.Vector;

import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;

import org.apache.log4j.Logger;




/**
 * Agente que gestiona los usuarios y contraseñas de los dominios de seguridad
 * Weblogic y JBoss. Hace uso de las tablas SC_WL_USUARI y SC_WL_USUGRU
 * <P>
 * 
 * @author $Author$
 * @version $Revision$
 */

public class JBPMRoles extends HttpServlet{

	DataSource ds=null;
	Connection sqlConnection = null;
	
	protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
		
		try{
			if("list".equals(req.getParameter("action"))){
				list(req,resp);
			}else if("add".equals(req.getParameter("action"))){
				add(req,resp);
			}else if("delete".equals(req.getParameter("action"))){
				delete(req,resp);
			}
		}catch(Throwable e){
			
			
			req.setAttribute("exception", e);
			try {
				req.getRequestDispatcher("error.jsp").forward(req, resp);
			} catch (ServletException e1) {
				Logger.getLogger(JBPMRoles.class).error(e1.getMessage(),e1);
			} catch (IOException e1) {
				Logger.getLogger(JBPMRoles.class).error(e1.getMessage(),e1);
			}

		}finally{
			if(sqlConnection!=null){
				try{
					sqlConnection.close();
				}catch(Exception e1){
					throw new ServletException(e1);
				}
			}
		}
		
		if(sqlConnection!=null){
			try{
				sqlConnection.close();
			}catch(Exception e){
				throw new ServletException(e);
			}
		}
			
		
		
	
	}


	
private void delete(HttpServletRequest req, HttpServletResponse resp) throws Exception {
	String rol=req.getParameter("rol"); //req.getParameterMap()
	String codiUsuari=req.getParameter("usuari");

	long groupId;
	if(checkUser(codiUsuari)){
		try{
			
			
			//abans d'esborrar verifiquem que es pugui inserir 
	
				String rg[]=rol.split("/");
	
				groupId=getGroupIdByCodi(rg[0]);
	
				PreparedStatement stmtA = getSqlConnection().prepareStatement("delete  from JBPM_ID_MEMBERSHIP where id_=(select p.id_ from JBPM_ID_MEMBERSHIP P, JBPM_ID_USER u where p.user_=u.id_ and u.name_=? and p.role_=?  and p.group_=?)");
				stmtA.setString(1, codiUsuari);
				stmtA.setString(2, rg[1]);
				stmtA.setLong(3, groupId);
				stmtA.execute();
				stmtA.close();
				
	
		}catch(Exception e){
			Logger.getLogger(JBPMRoles.class).error(e.getMessage(),e);
			throw e;
		}
		req.setAttribute("msg","Esborrat rol: "+ rol+ " de l'usuari: "+codiUsuari);
	}else{
		req.setAttribute("msg","No es pot donar d'alta rols per a aquest usuari");
	}
	
	try {
		listFiltered(null, null, req, resp);
	} catch (ServletException e1) {
		Logger.getLogger(JBPMRoles.class).error(e1.getMessage(),e1);
	} catch (IOException e1) {
		Logger.getLogger(JBPMRoles.class).error(e1.getMessage(),e1);
	}	

}

private void add(HttpServletRequest req, HttpServletResponse resp) throws Exception {
	String rol=req.getParameter("rol"); //req.getParameterMap()

	String codiUsuari=req.getParameter("usuari");
	
	long roleId;
	long groupId;
	long userId;
	
	if(checkUser(codiUsuari) ){
		PreparedStatement stmt=null;	
		PreparedStatement stmt1=null;
		ResultSet rs=null;
		try{
			
			
			String rg[]=rol.split("/");
	
	
			groupId=getGroupIdByCodi(rg[0]);
			userId=getUserIdByCodi(codiUsuari);
			 
			
			stmt = getSqlConnection().prepareStatement("select count(p.id_) from  JBPM_ID_MEMBERSHIP p where  role_=? and user_=? and group_=?");
			stmt.setString(1, rg[1]);
			stmt.setLong(2, userId);
			stmt.setLong(3, groupId);
			stmt.execute();				
			
			boolean exists=false;
			rs=stmt.getResultSet();
			rs.next();
			if(rs.getInt(1)!=0) exists=true;

			
			if(exists)throw new Exception("ya existe la asociación del usuario: "+codiUsuari+" con el rol: "+rol);
			
			long id=getNextHibernateSequenceValue();
				
			stmt1 = getSqlConnection().prepareStatement("insert into JBPM_ID_MEMBERSHIP (id_,class_,role_,user_,group_) values  (?,'M',?,?,?)");
			stmt1.setLong(1, id);
			stmt1.setString(2, rg[1]);
			stmt1.setLong(3, userId);
			stmt1.setLong(4, groupId);
			stmt1.execute();
			
			
			stmt1.close();
					
			
		}catch(Exception e){
			Logger.getLogger(JBPMRoles.class).error(e.getMessage(),e);
			throw e;
		}finally{
			try{
				if(rs!=null)rs.close();
			}catch(Exception x1){}
			try{
				if(stmt!=null)stmt.close();
			}catch(Exception x1){}

			try{
				if(stmt1!=null)stmt1.close();
			}catch(Exception x1){}
		}
		req.setAttribute("msg","Assignat rol: "+ rol+ " a l'usuari: "+codiUsuari);
	}else{
		req.setAttribute("msg","No es pot donar d'alta rols per a aquest usuari");
	}
	try {

		listFiltered(null,null,req, resp);
		
		
	} catch (ServletException e1) {
		Logger.getLogger(JBPMRoles.class).error(e1.getMessage(),e1);
	} catch (IOException e1) {
		Logger.getLogger(JBPMRoles.class).error(e1.getMessage(),e1);
	}	
	
}


	

	protected boolean checkUser(String codiUsuari) {
		if(codiUsuari.contains("u80571")
		|| codiUsuari.contains("u80023")
		|| codiUsuari.contains("u91854")
		|| codiUsuari.contains("u83593")
		|| codiUsuari.contains("u86703")
		|| codiUsuari.contains("u86423")
		|| codiUsuari.contains("u82239"))
			return true;
		else
			return false;
}



	private void list(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		String codiUsuari=req.getParameter("usuari");
		String [] order=req.getParameterValues("order");

		listFiltered(codiUsuari,order,req,resp);
	}



	private long getNextHibernateSequenceValue() throws Exception{
		PreparedStatement stmt1=null;
		ResultSet rs=null;
		long out=-1;
		try{
			stmt1= getSqlConnection().prepareStatement("select HIBERNATE_SEQUENCE.nextval from dual");
			stmt1.execute();
			rs=stmt1.getResultSet();
			if(!rs.next()) throw new Exception ("No s'ha obtingut valor del sequence: HIBERNATE_SEQUENCE");
			out=rs.getLong(1);
		}catch(Exception e){
			Logger.getLogger(JBPMRoles.class).error(e.getMessage(),e);
			throw e;
		}finally{
			try{
				if(rs!=null) rs.close();
			}catch(Exception x1){}
			try{
				if(stmt1!=null)stmt1.close();
			}catch(Exception x1){}
		}
		
		return out;
}

	private long getRoleIdByCodi(String string) throws Exception {
		PreparedStatement stmt1=null;
		ResultSet rs=null;
		long out=-1;
		try{
			stmt1= getSqlConnection().prepareStatement("select id_ from JBPM_ID_GROUP where name_=?  and type_='security-role'");
			stmt1.setString(1, string);
			stmt1.execute();
			rs=stmt1.getResultSet();
			if(!rs.next()) throw new Exception ("No existeix el grup: "+string);
			out=rs.getLong(1);
		}catch(Exception e){
			Logger.getLogger(JBPMRoles.class).error(e.getMessage(),e);
			throw e;
		}finally{
			try{
				if(rs!=null) rs.close();
			}catch(Exception x1){}
			try{
				if(stmt1!=null)stmt1.close();
			}catch(Exception x1){}
		}
		
		return out;
			
	}

	private long getGroupIdByCodi(String string) throws Exception{
		PreparedStatement stmt1=null;
		ResultSet rs=null;
		long out=-1;
		try{
			stmt1= getSqlConnection().prepareStatement("select id_ from JBPM_ID_GROUP where name_=?  and type_='organisation'");
			stmt1.setString(1, string);
			stmt1.execute();
			rs=stmt1.getResultSet();
			if(!rs.next()) throw new Exception ("No existeix el grup: "+string);
			
			out=rs.getLong(1);
		}catch(Exception e){
			Logger.getLogger(JBPMRoles.class).error(e.getMessage(),e);
			throw e;
		}finally{
			try{
				if(rs!=null) rs.close();
			}catch(Exception x1){}
			try{
				if(stmt1!=null)stmt1.close();
			}catch(Exception x1){}
		}
		
		return out;
	}

	private long getUserIdByCodi(String string) throws Exception {
		PreparedStatement stmt1=null;
		ResultSet rs=null;
		long out=-1;
		
		try{
			stmt1= getSqlConnection().prepareStatement("select id_ from JBPM_ID_USER where name_=?");
			stmt1.setString(1, string);
			stmt1.execute();
			rs=stmt1.getResultSet();
			if(!rs.next()) throw new Exception ("No existeix el grup: "+string);
			
			out=rs.getLong(1);
		}catch(Exception e){
			Logger.getLogger(JBPMRoles.class).error(e.getMessage(),e);
			throw e;
		}finally{
			try{
				if(rs!=null) rs.close();
			}catch(Exception x1){}
			try{
				if(stmt1!=null)stmt1.close();
			}catch(Exception x1){}
		}
		
		return out;
}

	protected void listFiltered(String codiUsuari, String [] order, HttpServletRequest req, HttpServletResponse resp) throws Exception {
		StringBuffer sb=new StringBuffer("");
		StringBuffer sbg=new StringBuffer("");
		
		HashMap columns =new HashMap();
		columns.put("name","u.name_");
		columns.put("role","  g.name_ || '/' || p.role_");

		if(order!=null){
			for (int i=0;i<order.length;i++){
				if(columns.get(order[i])!=null){
					if(i!=0){
						sb.append(",");
					}
					
					if("name".equals(order[i]))
						sb.append("u.name_");
					else if("role".equals(order[i]))
						sb.append(" g.name_ || '/' || p.role_");
				}
				
			}
		}else{
			sb.append("u.name_ , g.name_ || '/' || p.role_ ");

		}
		
		
		

		PreparedStatement stmt1=null;
		ResultSet rs=null;
		try{
			
				
				
				//recupera grups i rols
				String sql1="" +
				"select "+sb.toString()+" from JBPM_ID_USER U, JBPM_ID_MEMBERSHIP P "+
				" , JBPM_ID_GROUP G" +
				" where" +
				" p.role_ is not null" +
				" and u.iD_=p.USER_" +
				" and g.id_=p.group_" +
				" and u.name_ in ('u80571','u80023','u91854','u83593','u86703','u86423','u82239')" ;
				sql1+=(codiUsuari!=null )?" and u.name_=? " :"";
				sql1+=" group by " +sb.toString()+" " +
						" order by "+sb.toString();
				
//				" union " +
//				" select u.name_,g.name_ from JBPM_ID_USER U, JBPM_ID_MEMBERSHIP P "+
//				" , JBPM_ID_GROUP G" +
//				" where" +
//				" p.role_ is null" +
//				" and u.iD_=p.USER_" +
//				" and g.id_=p.group_" +
//				" and u.name_=? " +
//				"";
				stmt1 = getSqlConnection().prepareStatement(sql1);
				
				Logger.getLogger(this.getClass()).debug(sql1);
				if(codiUsuari!=null ) stmt1.setString(1, codiUsuari);
				stmt1.execute();
	
				rs=stmt1.getResultSet();
				Vector list=new Vector();
				
				while(rs.next()){
					Vector o=new Vector();
					for(int j=0;j<rs.getMetaData().getColumnCount();j++){
						o.add(rs.getObject(j+1));
					}
					list.add(o.toArray(new Object[o.size()]));
				}
				
				req.setAttribute("list", list);
					

		}catch(SQLException e){
			Logger.getLogger(JBPMRoles.class).error(e.getMessage(),e);
			throw e;
		}finally{
			try{
				if(rs!=null)rs.close();
			}catch(Exception x1){}
			try{
				if(stmt1!=null)stmt1.close();
			}catch(Exception x1){}
		}
		
		try {
			req.getRequestDispatcher("jbpmroles.jsp").forward(req, resp);
		} catch (ServletException e) {
			Logger.getLogger(JBPMRoles.class).error(e.getMessage(),e);
		} catch (IOException e) {
			Logger.getLogger(JBPMRoles.class).error(e.getMessage(),e);
		}

	}

	private Connection getSqlConnection() throws Exception{
		if(sqlConnection==null || (sqlConnection!=null && sqlConnection.isClosed())){
			if(ds==null){
				ds=(DataSource) new InitialContext().lookup("java:/es.caib.bpm.db");
			}
			sqlConnection=ds.getConnection();
		}
		return sqlConnection;
	}



}

