/*
 * Decompiled with CFR 0.152.
 */
package es.caib.ibkey.web.test;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

public class JBPMRoles
extends HttpServlet {
    DataSource ds = null;
    Connection sqlConnection = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            if ("list".equals(req.getParameter("action"))) {
                this.list(req, resp);
            } else if ("add".equals(req.getParameter("action"))) {
                this.add(req, resp);
            } else if ("delete".equals(req.getParameter("action"))) {
                this.delete(req, resp);
            }
        }
        catch (Throwable e) {
            req.setAttribute("exception", (Object)e);
            try {
                req.getRequestDispatcher("error.jsp").forward((ServletRequest)req, (ServletResponse)resp);
            }
            catch (ServletException e1) {
                Logger.getLogger(JBPMRoles.class).error((Object)e1.getMessage(), (Throwable)e1);
            }
            catch (IOException e1) {
                Logger.getLogger(JBPMRoles.class).error((Object)e1.getMessage(), (Throwable)e1);
            }
        }
        finally {
            if (this.sqlConnection != null) {
                try {
                    this.sqlConnection.close();
                }
                catch (Exception e1) {
                    throw new ServletException((Throwable)e1);
                }
            }
        }
        if (this.sqlConnection != null) {
            try {
                this.sqlConnection.close();
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }
    }

    private void delete(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        String rol = req.getParameter("rol");
        String codiUsuari = req.getParameter("usuari");
        if (this.checkUser(codiUsuari)) {
            try {
                String[] rg = rol.split("/");
                long groupId = this.getGroupIdByCodi(rg[0]);
                PreparedStatement stmtA = this.getSqlConnection().prepareStatement("delete  from JBPM_ID_MEMBERSHIP where id_=(select p.id_ from JBPM_ID_MEMBERSHIP P, JBPM_ID_USER u where p.user_=u.id_ and u.name_=? and p.role_=?  and p.group_=?)");
                stmtA.setString(1, codiUsuari);
                stmtA.setString(2, rg[1]);
                stmtA.setLong(3, groupId);
                stmtA.execute();
                stmtA.close();
            }
            catch (Exception e) {
                Logger.getLogger(JBPMRoles.class).error((Object)e.getMessage(), (Throwable)e);
                throw e;
            }
            req.setAttribute("msg", (Object)("Esborrat rol: " + rol + " de l'usuari: " + codiUsuari));
        } else {
            req.setAttribute("msg", (Object)"No es pot donar d'alta rols per a aquest usuari");
        }
        try {
            this.listFiltered(null, null, req, resp);
        }
        catch (ServletException e1) {
            Logger.getLogger(JBPMRoles.class).error((Object)e1.getMessage(), (Throwable)e1);
        }
        catch (IOException e1) {
            Logger.getLogger(JBPMRoles.class).error((Object)e1.getMessage(), (Throwable)e1);
        }
    }

    private void add(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        String rol = req.getParameter("rol");
        String codiUsuari = req.getParameter("usuari");
        if (this.checkUser(codiUsuari)) {
            Statement stmt = null;
            Statement stmt1 = null;
            ResultSet rs = null;
            try {
                String[] rg = rol.split("/");
                long groupId = this.getGroupIdByCodi(rg[0]);
                long userId = this.getUserIdByCodi(codiUsuari);
                stmt = this.getSqlConnection().prepareStatement("select count(p.id_) from  JBPM_ID_MEMBERSHIP p where  role_=? and user_=? and group_=?");
                stmt.setString(1, rg[1]);
                stmt.setLong(2, userId);
                stmt.setLong(3, groupId);
                stmt.execute();
                boolean exists = false;
                rs = stmt.getResultSet();
                rs.next();
                if (rs.getInt(1) != 0) {
                    exists = true;
                }
                if (exists) {
                    throw new Exception("ya existe la asociaci\u00c3\u00b3n del usuario: " + codiUsuari + " con el rol: " + rol);
                }
                long id = this.getNextHibernateSequenceValue();
                stmt1 = this.getSqlConnection().prepareStatement("insert into JBPM_ID_MEMBERSHIP (id_,class_,role_,user_,group_) values  (?,'M',?,?,?)");
                stmt1.setLong(1, id);
                stmt1.setString(2, rg[1]);
                stmt1.setLong(3, userId);
                stmt1.setLong(4, groupId);
                stmt1.execute();
                stmt1.close();
            }
            catch (Exception e) {
                Logger.getLogger(JBPMRoles.class).error((Object)e.getMessage(), (Throwable)e);
                throw e;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception x1) {}
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception x1) {}
                try {
                    if (stmt1 != null) {
                        stmt1.close();
                    }
                }
                catch (Exception x1) {}
            }
            req.setAttribute("msg", (Object)("Assignat rol: " + rol + " a l'usuari: " + codiUsuari));
        } else {
            req.setAttribute("msg", (Object)"No es pot donar d'alta rols per a aquest usuari");
        }
        try {
            this.listFiltered(null, null, req, resp);
        }
        catch (ServletException e1) {
            Logger.getLogger(JBPMRoles.class).error((Object)e1.getMessage(), (Throwable)e1);
        }
        catch (IOException e1) {
            Logger.getLogger(JBPMRoles.class).error((Object)e1.getMessage(), (Throwable)e1);
        }
    }

    protected boolean checkUser(String codiUsuari) {
        return codiUsuari.contains("u80571") || codiUsuari.contains("u80023") || codiUsuari.contains("u91854") || codiUsuari.contains("u83593") || codiUsuari.contains("u86703") || codiUsuari.contains("u86423") || codiUsuari.contains("u82239");
    }

    private void list(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        String codiUsuari = req.getParameter("usuari");
        String[] order = req.getParameterValues("order");
        this.listFiltered(codiUsuari, order, req, resp);
    }

    private long getNextHibernateSequenceValue() throws Exception {
        PreparedStatement stmt1 = null;
        ResultSet rs = null;
        long out = -1L;
        try {
            stmt1 = this.getSqlConnection().prepareStatement("select HIBERNATE_SEQUENCE.nextval from dual");
            stmt1.execute();
            rs = stmt1.getResultSet();
            if (!rs.next()) {
                throw new Exception("No s'ha obtingut valor del sequence: HIBERNATE_SEQUENCE");
            }
            out = rs.getLong(1);
        }
        catch (Exception e) {
            Logger.getLogger(JBPMRoles.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception x1) {}
            try {
                if (stmt1 != null) {
                    stmt1.close();
                }
            }
            catch (Exception x1) {}
        }
        return out;
    }

    private long getRoleIdByCodi(String string) throws Exception {
        PreparedStatement stmt1 = null;
        ResultSet rs = null;
        long out = -1L;
        try {
            stmt1 = this.getSqlConnection().prepareStatement("select id_ from JBPM_ID_GROUP where name_=?  and type_='security-role'");
            stmt1.setString(1, string);
            stmt1.execute();
            rs = stmt1.getResultSet();
            if (!rs.next()) {
                throw new Exception("No existeix el grup: " + string);
            }
            out = rs.getLong(1);
        }
        catch (Exception e) {
            Logger.getLogger(JBPMRoles.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception x1) {}
            try {
                if (stmt1 != null) {
                    stmt1.close();
                }
            }
            catch (Exception x1) {}
        }
        return out;
    }

    private long getGroupIdByCodi(String string) throws Exception {
        PreparedStatement stmt1 = null;
        ResultSet rs = null;
        long out = -1L;
        try {
            stmt1 = this.getSqlConnection().prepareStatement("select id_ from JBPM_ID_GROUP where name_=?  and type_='organisation'");
            stmt1.setString(1, string);
            stmt1.execute();
            rs = stmt1.getResultSet();
            if (!rs.next()) {
                throw new Exception("No existeix el grup: " + string);
            }
            out = rs.getLong(1);
        }
        catch (Exception e) {
            Logger.getLogger(JBPMRoles.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception x1) {}
            try {
                if (stmt1 != null) {
                    stmt1.close();
                }
            }
            catch (Exception x1) {}
        }
        return out;
    }

    private long getUserIdByCodi(String string) throws Exception {
        PreparedStatement stmt1 = null;
        ResultSet rs = null;
        long out = -1L;
        try {
            stmt1 = this.getSqlConnection().prepareStatement("select id_ from JBPM_ID_USER where name_=?");
            stmt1.setString(1, string);
            stmt1.execute();
            rs = stmt1.getResultSet();
            if (!rs.next()) {
                throw new Exception("No existeix el grup: " + string);
            }
            out = rs.getLong(1);
        }
        catch (Exception e) {
            Logger.getLogger(JBPMRoles.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception x1) {}
            try {
                if (stmt1 != null) {
                    stmt1.close();
                }
            }
            catch (Exception x1) {}
        }
        return out;
    }

    protected void listFiltered(String codiUsuari, String[] order, HttpServletRequest req, HttpServletResponse resp) throws Exception {
        StringBuffer sb = new StringBuffer("");
        StringBuffer sbg = new StringBuffer("");
        HashMap<String, String> columns = new HashMap<String, String>();
        columns.put("name", "u.name_");
        columns.put("role", "  g.name_ || '/' || p.role_");
        if (order != null) {
            for (int i = 0; i < order.length; ++i) {
                if (columns.get(order[i]) == null) continue;
                if (i != 0) {
                    sb.append(",");
                }
                if ("name".equals(order[i])) {
                    sb.append("u.name_");
                    continue;
                }
                if (!"role".equals(order[i])) continue;
                sb.append(" g.name_ || '/' || p.role_");
            }
        } else {
            sb.append("u.name_ , g.name_ || '/' || p.role_ ");
        }
        Statement stmt1 = null;
        ResultSet rs = null;
        try {
            String sql1 = "select " + sb.toString() + " from JBPM_ID_USER U, JBPM_ID_MEMBERSHIP P " + " , JBPM_ID_GROUP G" + " where" + " p.role_ is not null" + " and u.iD_=p.USER_" + " and g.id_=p.group_" + " and u.name_ in ('u80571','u80023','u91854','u83593','u86703','u86423','u82239')";
            sql1 = sql1 + (codiUsuari != null ? " and u.name_=? " : "");
            sql1 = sql1 + " group by " + sb.toString() + " " + " order by " + sb.toString();
            stmt1 = this.getSqlConnection().prepareStatement(sql1);
            Logger.getLogger(this.getClass()).debug((Object)sql1);
            if (codiUsuari != null) {
                stmt1.setString(1, codiUsuari);
            }
            stmt1.execute();
            rs = stmt1.getResultSet();
            Vector<Object[]> list = new Vector<Object[]>();
            while (rs.next()) {
                Vector<Object> o = new Vector<Object>();
                for (int j = 0; j < rs.getMetaData().getColumnCount(); ++j) {
                    o.add(rs.getObject(j + 1));
                }
                list.add(o.toArray(new Object[o.size()]));
            }
            req.setAttribute("list", list);
        }
        catch (SQLException e) {
            Logger.getLogger(JBPMRoles.class).error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception x1) {}
            try {
                if (stmt1 != null) {
                    stmt1.close();
                }
            }
            catch (Exception x1) {}
        }
        try {
            req.getRequestDispatcher("jbpmroles.jsp").forward((ServletRequest)req, (ServletResponse)resp);
        }
        catch (ServletException e) {
            Logger.getLogger(JBPMRoles.class).error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            Logger.getLogger(JBPMRoles.class).error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private Connection getSqlConnection() throws Exception {
        if (this.sqlConnection == null || this.sqlConnection != null && this.sqlConnection.isClosed()) {
            if (this.ds == null) {
                this.ds = (DataSource)new InitialContext().lookup("java:/es.caib.bpm.db");
            }
            this.sqlConnection = this.ds.getConnection();
        }
        return this.sqlConnection;
    }
}

