/*
 * Decompiled with CFR 0.152.
 */
package es.caib.signatura.api;

import es.caib.signatura.api.Signer;
import es.caib.signatura.api.UpgradeNeededException;
import es.caib.signatura.impl.CAIBSigner;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Properties;

public class SignerFactory {
    static boolean started = false;
    private static final String INSTALL_URL = "http://www.caib.es/signaturacaib/install.jnlp";

    public String getAPIVersion() throws FileNotFoundException, IOException {
        InputStream inputStream = SignerFactory.class.getResourceAsStream("version.properties");
        if (inputStream == null) {
            throw new FileNotFoundException();
        }
        Properties tempProperties = new Properties();
        tempProperties.load(inputStream);
        inputStream.close();
        return tempProperties.getProperty("Version");
    }

    public Signer getSigner() throws UpgradeNeededException {
        try {
            if (!started) {
                started = true;
            }
            CAIBSigner s = new CAIBSigner();
            if (!this.isValidVersion(this.getAPIVersion(), s.getAPIVersion())) {
                System.out.println("Necesita actualizarse a la versi\u00f3n " + this.getAPIVersion() + " o superior. Actualmente tiene instalada la versi\u00f3n " + s.getAPIVersion());
                throw new UpgradeNeededException("Necesita actualizarse a la versi\u00f3n " + this.getAPIVersion() + " o superior. Actualmente tiene instalada la versi\u00f3n " + s.getAPIVersion(), this.getUpgradeUrl());
            }
            return s;
        }
        catch (Throwable e) {
            throw new UpgradeNeededException("Sistema de firma no instalado", this.getUpgradeUrl(), e);
        }
    }

    private URL getUpgradeUrl() {
        String url = INSTALL_URL;
        try {
            url = url + "?key1=" + URLEncoder.encode(System.getProperty("java.home"), "UTF-8");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isValidVersion(String apiVersion, String jreVersion) {
        if (jreVersion == null) {
            return false;
        }
        if (apiVersion == null) {
            return false;
        }
        String[] splitJRE = jreVersion.split("[.-]");
        String[] splitAPI = apiVersion.split("[.-]");
        for (int i = 0; i < splitAPI.length && i < 3; ++i) {
            if (i >= splitJRE.length) {
                return false;
            }
            try {
                int v1 = Integer.parseInt(splitJRE[i]);
                int v2 = Integer.parseInt(splitAPI[i]);
                if (v1 > v2) {
                    return true;
                }
                if (v1 >= v2) continue;
                return false;
            }
            catch (NumberFormatException e) {
                if (splitJRE[i].compareTo(splitAPI[i]) > 0) {
                    return true;
                }
                if (splitJRE[i].compareTo(splitAPI[i]) >= 0) continue;
                return false;
            }
        }
        return true;
    }
}

