/*
 * Decompiled with CFR 0.152.
 */
package es.caib.signatura.mbean;

import es.caib.signatura.cliente.services.custodia.Custodia;
import es.caib.signatura.cliente.services.custodia.CustodiaService;
import es.caib.signatura.cliente.services.custodia.CustodiaServiceLocator;
import es.caib.signatura.cliente.services.custodia.CustodiaSoapBindingStub;
import es.caib.signatura.mbean.ClienteCustodiaMBean;
import es.caib.signatura.utils.ClientMultipartFormData;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import javax.xml.rpc.ServiceException;
import org.jboss.system.ServiceMBeanSupport;

public class ClienteCustodia
extends ServiceMBeanSupport
implements ClienteCustodiaMBean {
    private String usuario = null;
    private String password = null;
    private String urlServicioCustodia = null;
    private CustodiaService service = null;
    private Custodia custodiaPort = null;
    public static String SMIME = "SMIME";
    public static String PDF_FIRMADO = "PDF_FIRMADO";
    public static String XADES = "XADES";
    public static String SIN_FIRMAR = "SIN_FIRMAR";

    private void init() {
        try {
            if (this.custodiaPort == null) {
                this.service = new CustodiaServiceLocator();
                this.custodiaPort = this.service.getCustodia(new URL(this.urlServicioCustodia));
                ((CustodiaSoapBindingStub)this.custodiaPort).setUsername(this.usuario);
                ((CustodiaSoapBindingStub)this.custodiaPort).setPassword(this.password);
            }
        }
        catch (ServiceException sex) {
            sex.printStackTrace();
        }
        catch (MalformedURLException mux) {
            mux.printStackTrace();
        }
    }

    public String getUsuario() {
        return this.usuario;
    }

    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUrlServicioCustodia() {
        return this.urlServicioCustodia;
    }

    public void setUrlServicioCustodia(String urlServicioCustodia) {
        this.urlServicioCustodia = urlServicioCustodia;
    }

    public byte[] custodiarDocumentoSMIME(ByteArrayInputStream documento, String nombreDocumento, String codigoExterno, String codigoExternoTipoDocumento) throws RemoteException {
        return this.uploadDocumento(documento, SMIME, nombreDocumento, codigoExterno, codigoExternoTipoDocumento, this.usuario, this.password);
    }

    public byte[] custodiarDocumentoXAdES(ByteArrayInputStream documento, String nombreDocumento, String codigoExterno, String codigoExternoTipoDocumento) throws RemoteException {
        return this.uploadDocumento(documento, XADES, nombreDocumento, codigoExterno, codigoExternoTipoDocumento, this.usuario, this.password);
    }

    public byte[] custodiarDocumento(ByteArrayInputStream documento, String nombreDocumento, String codigoExterno, String codigoExternoTipoDocumento) throws RemoteException {
        return this.uploadDocumento(documento, SIN_FIRMAR, nombreDocumento, codigoExterno, codigoExternoTipoDocumento, this.usuario, this.password);
    }

    public byte[] custodiarPDFFirmado(ByteArrayInputStream documento, String nombreDocumento, String codigoExterno, String codigoExternoTipoDocumento) throws RemoteException {
        return this.uploadDocumento(documento, PDF_FIRMADO, nombreDocumento, codigoExterno, codigoExternoTipoDocumento, this.usuario, this.password);
    }

    public byte[] purgarDocumento(String codigoExterno) throws RemoteException {
        this.init();
        return this.custodiaPort.purgarDocumento_v2(this.usuario, this.password, codigoExterno);
    }

    public byte[] recuperarDocumento(String codigoExterno) throws RemoteException {
        this.init();
        return this.custodiaPort.recuperarDocumento_v2(this.usuario, this.password, codigoExterno);
    }

    public byte[] eliminarDocumento(String codigoExterno) throws RemoteException {
        this.init();
        return this.custodiaPort.eliminarDocumento_v2(this.usuario, this.password, codigoExterno);
    }

    public byte[] verificarDocumento(String codigoExterno) throws RemoteException {
        this.init();
        return this.custodiaPort.verificarDocumento_v2(this.usuario, this.password, codigoExterno);
    }

    public byte[] obtenerInformeDocumento(String codigoExterno) throws RemoteException {
        this.init();
        return this.custodiaPort.obtenerInformeDocumento_v2(this.usuario, this.password, codigoExterno);
    }

    public byte[] consultarDocumento(String codigoExterno) throws RemoteException {
        this.init();
        return this.custodiaPort.consultarDocumento_v2(this.usuario, this.password, codigoExterno);
    }

    public byte[] reservarDocumento(String codigoExterno) throws RemoteException {
        this.init();
        return this.custodiaPort.reservarDocumento(this.usuario, this.password, codigoExterno);
    }

    public byte[] reservarDocumento_v2(String codigoExterno) throws RemoteException {
        this.init();
        return this.custodiaPort.reservarDocumento_v2(this.usuario, this.password, codigoExterno);
    }

    public byte[] consultarReservaDocumento(String hash) throws RemoteException {
        this.init();
        return this.custodiaPort.consultarReservaDocumento(this.usuario, this.password, hash);
    }

    private byte[] uploadDocumento(ByteArrayInputStream documento, String claseDocumento, String nombreDocumento, String codigoExterno, String codigoExternoTipoDocumento, String usuario, String password) {
        try {
            String urlServlet = this.urlServicioCustodia.substring(0, this.urlServicioCustodia.indexOf("services/CustodiaDocumentos")) + "uploaddocument";
            ClientMultipartFormData client = new ClientMultipartFormData(urlServlet);
            client.addParameter("claseDoc", claseDocumento);
            client.addParameter("nombreDoc", nombreDocumento);
            client.addParameter("codExt", codigoExterno);
            client.addParameter("codExtTipDoc", codigoExternoTipoDocumento);
            client.addParameter("usuario", usuario);
            client.addParameter("password", password);
            String extension = ClienteCustodia.getExtension(claseDocumento, nombreDocumento);
            client.addParameter("datos", "datos." + extension, documento);
            InputStream input = client.send();
            byte[] resp = new byte[4096];
            ByteArrayOutputStream read = new ByteArrayOutputStream();
            int readed = 0;
            while ((readed = input.read(resp)) != -1) {
                read.write(resp, 0, readed);
            }
            input.close();
            return read.toByteArray();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static String getExtension(String claseDocumento, String nombreDocumento) {
        String extension = "";
        if (claseDocumento.equals(SMIME)) {
            return "smime";
        }
        if (claseDocumento.equals(PDF_FIRMADO)) {
            return "pdf";
        }
        if (claseDocumento.equals(XADES)) {
            return "xades";
        }
        if (claseDocumento.equals(SIN_FIRMAR)) {
            int index = nombreDocumento.lastIndexOf(".");
            if (index != -1) {
                return nombreDocumento.substring(index + 1, nombreDocumento.length());
            }
            return "";
        }
        return extension;
    }

    private static void testExtension() {
        System.out.println(ClienteCustodia.getExtension(SMIME, "doc.test"));
        System.out.println(ClienteCustodia.getExtension(PDF_FIRMADO, "doc.pdf"));
        System.out.println(ClienteCustodia.getExtension(XADES, "doc.xml"));
        System.out.println(ClienteCustodia.getExtension(SIN_FIRMAR, "doc.odt"));
        System.out.println(ClienteCustodia.getExtension(SIN_FIRMAR, "doc.kk.odt"));
        System.out.println(ClienteCustodia.getExtension(SIN_FIRMAR, "doc.kk."));
        System.out.println(ClienteCustodia.getExtension(SIN_FIRMAR, "doc"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] arg) {
        ClienteCustodia.testExtension();
        InputStream fis = null;
        try {
            ClienteCustodia client = new ClienteCustodia();
            client.setUsuario("ABC");
            client.setPassword("ABC");
            fis = new FileInputStream(new File("/home/eluengo/Documents/SMIMEBUENO"));
            byte[] currentBytes = client.getBytes(fis);
            System.out.println(new String(currentBytes));
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(currentBytes);
            client.custodiarDocumentoSMIME(byteArrayInputStream, "doc", "docSMIME", "ASI");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private byte[] getBytes(InputStream is) {
        try {
            int nRead;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] currentBytes = new byte[is.available()];
            while ((nRead = is.read(currentBytes, 0, 4096)) != -1) {
                buffer.write(currentBytes, 0, nRead);
            }
            buffer.flush();
            return currentBytes;
        }
        catch (IOException ex) {
            return null;
        }
    }
}

