/*
 * Decompiled with CFR 0.152.
 */
package es.caib.signatura.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Random;

public class ClientMultipartFormData {
    private static String boundary;
    private static String contentDisposition;
    private URLConnection connection;
    private OutputStream output = null;

    public ClientMultipartFormData(String urlString) throws IOException {
        URL url = new URL(urlString);
        this.connection = url.openConnection();
        this.connection.setDoOutput(true);
        this.connection.setDoInput(true);
        this.connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
        this.output = this.connection.getOutputStream();
    }

    private void write(char c) throws IOException {
        if (this.output == null) {
            throw new IOException("Conexion no establecida");
        }
        this.output.write(c);
    }

    private void write(String s) throws IOException {
        if (this.output == null) {
            throw new IOException("Conexion no establecida");
        }
        this.output.write(s.getBytes("UTF-8"));
    }

    private void write(byte[] b) throws IOException {
        if (this.output == null) {
            throw new IOException("Conexion no establecida");
        }
        this.output.write(b);
    }

    private void writeNewline() throws IOException {
        this.write("\r\n");
    }

    private void writeBoundary() throws IOException {
        this.write("--");
        this.write(boundary);
    }

    private void writeName(String name) throws IOException {
        this.writeNewline();
        this.write(contentDisposition);
        this.write(name);
        this.write('\"');
    }

    private void writeInputStream(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] buf = new byte[1024];
        while ((read = in.read(buf, 0, buf.length)) >= 0) {
            out.write(buf, 0, read);
            out.flush();
        }
        out.flush();
    }

    public void addParameter(String name, String value) throws IOException {
        this.writeBoundary();
        this.writeName(name);
        this.writeNewline();
        this.writeNewline();
        this.write(value);
        this.writeNewline();
    }

    public void addParameter(String name, String filename, byte[] buffer) throws IOException {
        this.writeBoundary();
        this.writeName(name);
        this.write("; filename=\"");
        this.write(filename);
        this.write('\"');
        this.writeNewline();
        this.write("Content-Type: ");
        String type = URLConnection.guessContentTypeFromName(filename);
        if (type == null) {
            type = "application/octet-stream";
        }
        this.write(type);
        this.writeNewline();
        this.writeNewline();
        this.write(buffer);
        this.writeNewline();
    }

    public void addParameter(String name, String filename, InputStream is) throws IOException {
        this.writeBoundary();
        this.writeName(name);
        this.write("; filename=\"");
        this.write(filename);
        this.write('\"');
        this.writeNewline();
        this.write("Content-Type: ");
        String type = URLConnection.guessContentTypeFromName(filename);
        if (type == null) {
            type = "application/octet-stream";
        }
        this.write(type);
        this.writeNewline();
        this.writeNewline();
        this.writeInputStream(is, this.output);
        this.writeNewline();
    }

    public void addParameter(String name, File file) throws IOException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            this.addParameter(name, file.getPath(), fis);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    public InputStream send() throws IOException {
        this.writeBoundary();
        this.write("--");
        this.output.flush();
        this.output.close();
        return this.connection.getInputStream();
    }

    static {
        contentDisposition = "Content-Disposition: form-data; name=\"";
        Random random = new Random();
        boundary = "----------------" + Long.toString(random.nextLong(), 48).toUpperCase() + Long.toString(random.nextLong(), 48).toUpperCase() + Long.toString(random.nextLong(), 48).toUpperCase() + Long.toString(random.nextLong(), 48).toUpperCase();
    }
}

