/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.firmaJava.configuracion;

import es.mityc.firmaJava.configuracion.ConstantesConfiguracion;
import es.mityc.firmaJava.configuracion.EnumAlmacenCertificados;
import es.mityc.firmaJava.configuracion.EnumFormatoFirma;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Configuracion
implements Serializable,
ConstantesConfiguracion {
    private static final long serialVersionUID = 1L;
    static Log log = LogFactory.getLog(Configuracion.class);
    protected HashMap<String, String> configuracion = new HashMap();

    private static boolean chequeaPermiteFicheroExterno() {
        boolean resultado = false;
        try {
            ResourceBundle propiedadesPorDefecto = ResourceBundle.getBundle("SignXML");
            String ficherExt = propiedadesPorDefecto.getString("ConfigExternAllowed");
            resultado = Configuracion.isTrue(ficherExt);
        }
        catch (MissingResourceException ex) {
            resultado = true;
        }
        return resultado;
    }

    private static String getNombreFicheroExterno() {
        String resultado = "/SignXML.properties";
        try {
            ResourceBundle propiedadesPorDefecto = ResourceBundle.getBundle("SignXML");
            resultado = propiedadesPorDefecto.getString("ConfigExternFile");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return resultado;
    }

    public static String getNombreDirExterno() {
        String resultado = "";
        try {
            ResourceBundle propiedadesPorDefecto = ResourceBundle.getBundle("SignXML");
            resultado = propiedadesPorDefecto.getString("ConfigExternDir");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return resultado;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cargarConfiguracion() {
        Enumeration<Object> enuClaves = null;
        if (Configuracion.chequeaPermiteFicheroExterno()) {
            Properties propiedades = new Properties();
            FileInputStream fis = null;
            try {
                File fichero = new File(System.getProperty("user.home") + File.separator + Configuracion.getNombreDirExterno(), Configuracion.getNombreFicheroExterno());
                fis = new FileInputStream(fichero);
                propiedades.load(fis);
                this.configuracion = new HashMap();
                enuClaves = propiedades.keys();
                boolean hasNext = enuClaves.hasMoreElements();
                while (hasNext) {
                    String clave = (String)enuClaves.nextElement();
                    hasNext = enuClaves.hasMoreElements();
                    this.configuracion.put(clave, propiedades.getProperty(clave));
                }
            }
            catch (FileNotFoundException e) {
                this.cargarConfiguracionPorDefecto();
            }
            catch (IOException e) {
                this.cargarConfiguracionPorDefecto();
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException e) {
                    log.error((Object)e);
                }
            }
        } else {
            this.cargarConfiguracionPorDefecto();
        }
    }

    private void cargarConfiguracionPorDefecto() {
        log.debug((Object)"Se carga la configuraci\u00f3n por defecto");
        Enumeration<String> enuClaves = null;
        ResourceBundle propiedadesPorDefecto = ResourceBundle.getBundle("SignXML");
        this.configuracion = new HashMap();
        enuClaves = propiedadesPorDefecto.getKeys();
        boolean hasNext = enuClaves.hasMoreElements();
        while (hasNext) {
            String clave = enuClaves.nextElement();
            hasNext = enuClaves.hasMoreElements();
            this.configuracion.put(clave, propiedadesPorDefecto.getString(clave));
        }
    }

    public void guardarConfiguracion() throws IOException {
        StringBuffer paraGrabar = new StringBuffer();
        File dir = new File(System.getProperty("user.home") + File.separator + Configuracion.getNombreDirExterno());
        if (!(dir.exists() && dir.isDirectory() || dir.mkdir())) {
            return;
        }
        File fichero = new File(dir, Configuracion.getNombreFicheroExterno());
        log.trace((Object)("Salva fichero de configuraci\u00f3n en: " + fichero.getAbsolutePath()));
        if (!fichero.exists()) {
            InputStream fis = this.getClass().getResourceAsStream("/SignXML.properties");
            BufferedInputStream bis = new BufferedInputStream(fis);
            FileOutputStream fos = new FileOutputStream(fichero);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            int length = bis.available();
            byte[] datos = new byte[length];
            bis.read(datos);
            bos.write(datos);
            bos.flush();
            bos.close();
            bis.close();
        }
        BufferedReader propiedades = new BufferedReader(new FileReader(fichero));
        String linea = propiedades.readLine();
        while (linea != null) {
            StringTokenizer token = new StringTokenizer(linea, "=");
            if (token.hasMoreTokens()) {
                String clave = token.nextToken().trim();
                if (this.configuracion.containsKey(clave)) {
                    paraGrabar.append(clave);
                    paraGrabar.append(" = ");
                    paraGrabar.append(this.getValor(clave));
                    paraGrabar.append("\n");
                } else {
                    paraGrabar.append(linea);
                    paraGrabar.append("\n");
                }
            } else {
                paraGrabar.append("\n");
            }
            linea = propiedades.readLine();
        }
        propiedades.close();
        FileWriter fw = new FileWriter(fichero);
        BufferedWriter bw = new BufferedWriter(fw);
        bw.write(String.valueOf(paraGrabar));
        bw.flush();
        bw.close();
    }

    public EnumAlmacenCertificados getAlmacenCertificados() {
        EnumAlmacenCertificados almacen = EnumAlmacenCertificados.ALMACEN_EXPLORER;
        String valor = this.configuracion.get("almacenCerts");
        String string = valor = valor == null ? "" : valor.toUpperCase().trim();
        if ("IEXPLORER".equalsIgnoreCase(valor)) {
            almacen = EnumAlmacenCertificados.ALMACEN_EXPLORER;
        } else if ("MOZILLA".equalsIgnoreCase(valor)) {
            almacen = EnumAlmacenCertificados.ALMACEN_MOZILLA;
        }
        return almacen;
    }

    public EnumFormatoFirma getFormatoXades() {
        EnumFormatoFirma formatoXades = EnumFormatoFirma.XAdES_BES;
        String valor = this.configuracion.get("FormatoXades");
        if (Configuracion.isEmpty(valor)) {
            log.warn((Object)"Fichero de configuracion: No se indico ningun formato XAdES. Se usa formato por defecto: XAdES-BES");
            formatoXades = EnumFormatoFirma.XAdES_BES;
        } else if ((valor = valor.toUpperCase().trim()).equals("XADES-BES".toUpperCase().trim())) {
            formatoXades = EnumFormatoFirma.XAdES_BES;
        } else if (valor.equals("XADES-T".toUpperCase().trim())) {
            formatoXades = EnumFormatoFirma.XAdES_T;
        } else if (valor.equals("XADES-C".toUpperCase().trim())) {
            formatoXades = EnumFormatoFirma.XAdES_C;
        } else if (valor.equals("XADES-X".toUpperCase().trim())) {
            formatoXades = EnumFormatoFirma.XAdES_X;
        } else if (valor.equals("XADES-XL".toUpperCase().trim())) {
            formatoXades = EnumFormatoFirma.XAdES_XL;
        }
        return formatoXades;
    }

    public void setFormatoXades(EnumFormatoFirma valor) {
        String clave = "FormatoXades";
        String sValor = "XADES-BES";
        switch (valor) {
            case XMLSignature: {
                sValor = "XADES-BES";
                break;
            }
            case XAdES_T: {
                sValor = "XADES-T";
                break;
            }
            case XAdES_C: {
                sValor = "XADES-C";
                break;
            }
            case XAdES_X: {
                sValor = "XADES-X";
                break;
            }
            case XAdES_XL: {
                sValor = "XADES-XL";
                break;
            }
            default: {
                sValor = "XADES-BES";
            }
        }
        this.setValor(clave, sValor);
    }

    public String getValor(String clave) {
        String valor = this.configuracion.get(clave);
        if ((valor == null || valor.equals("")) && clave != null) {
            if (clave.equals("xmlsn")) {
                valor = "ds";
            } else if (clave.equals("xmlXadesNS")) {
                valor = "etsi";
            } else if (clave.equals("pkcs7")) {
                valor = "N";
            } else if (clave.equals("isProxy")) {
                valor = "N";
            } else if (clave.equals("validateOCSP")) {
                valor = "N";
            } else if (clave.equals("SaveSign")) {
                valor = "N";
            } else if (clave.equals("xmldsigSchema")) {
                valor = "http://www.w3.org/2000/09/xmldsig#";
            } else if (clave.equals("xadesSchema")) {
                valor = "http://uri.etsi.org/01903/v1.3.2#";
            } else if (clave.equals("locale")) {
                valor = "es";
            } else if (clave.equals("encodingXML")) {
                valor = "UTF-8";
            }
        }
        return valor;
    }

    public void setValor(String clave, String valor) {
        this.configuracion.put(clave, valor);
    }

    public String toString() {
        StringBuffer cadena = new StringBuffer();
        Iterator<String> it = this.configuracion.keySet().iterator();
        boolean hasNext = it.hasNext();
        while (hasNext) {
            String claveTemporal = it.next();
            hasNext = it.hasNext();
            cadena.append("Key: ");
            cadena.append(claveTemporal);
            cadena.append(" Value: ");
            cadena.append(this.configuracion.get(claveTemporal));
            cadena.append("\n");
        }
        return String.valueOf(cadena);
    }

    public boolean comparar(String clave) {
        String parametro = this.getValor(clave.trim());
        if (parametro == null) {
            log.debug((Object)("Error: " + clave + "= null"));
        }
        return Configuracion.isTrue(parametro);
    }

    public static boolean isTrue(String parametro) {
        if (parametro == null) {
            return false;
        }
        return parametro.toLowerCase().trim().equals("s") || parametro.toLowerCase().trim().equals("y");
    }

    public int getInteger(String clave) {
        int number = -1;
        String valor = this.configuracion.get(clave);
        if ((valor == null || valor.equals("")) && clave != null) {
            try {
                number = Integer.parseInt(valor, 10);
            }
            catch (NumberFormatException e) {
                log.debug((Object)("Error: " + clave + e.getMessage()));
            }
        }
        return number;
    }

    public static boolean isEmpty(String valor) {
        return valor == null || valor.trim().equals("");
    }
}

