/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.firmaJava.configuracion;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DespliegueConfiguracionMng {
    private static Log log = LogFactory.getLog(DespliegueConfiguracionMng.class);
    private static DespliegueConfiguracionMng instance = new DespliegueConfiguracionMng();
    private ArrayList<ResourceBundle> props;
    private static final String ST_NO_RECURSOS_FILE = "No se ha encontrado el fichero de recursos";

    public static DespliegueConfiguracionMng getInstance() {
        return instance;
    }

    public static synchronized void reloadConfiguration() {
        instance = new DespliegueConfiguracionMng();
    }

    protected DespliegueConfiguracionMng() {
        try {
            ResourceBundle rb = ResourceBundle.getBundle("despliegue");
            String files = rb.getString("despliegue.conf.file");
            if (files != null) {
                StringTokenizer st = new StringTokenizer(files, ",");
                this.props = new ArrayList(st.countTokens());
                boolean hasNext = st.hasMoreTokens();
                while (hasNext) {
                    String file = st.nextToken();
                    hasNext = st.hasMoreTokens();
                    try {
                        this.props.add(ResourceBundle.getBundle(file));
                    }
                    catch (MissingResourceException ex) {
                        log.debug((Object)("No se ha encontrado el fichero de recursos " + file));
                    }
                }
            }
        }
        catch (MissingResourceException ex) {
            log.debug((Object)"Recurso no disponible", (Throwable)ex);
        }
    }

    protected String getValue(String key) {
        String value = null;
        if (this.props != null) {
            Iterator<ResourceBundle> it = this.props.iterator();
            boolean hasNext = it.hasNext();
            while (hasNext) {
                try {
                    value = it.next().getString(key);
                    hasNext = it.hasNext();
                    break;
                }
                catch (MissingResourceException ex) {
                }
            }
        }
        return value;
    }

    public String getString(String key) {
        return this.getValue(key);
    }

    public boolean getBoolean(String key) {
        boolean value = false;
        if (this.props != null) {
            try {
                value = Boolean.parseBoolean(this.getValue(key));
            }
            catch (MissingResourceException ex) {
                log.debug((Object)"Recurso no disponible", (Throwable)ex);
            }
        }
        return value;
    }
}

