package es.caib.signatura.afirma.rfc3161;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownServiceException;

public class RFC3161Connection extends URLConnection {
	Socket socket=null;
	private TsaInputStream tsaIn;
	private TsaOutputStream tsaOut;
	
	protected RFC3161Connection(URL url) {
		super(url);
		doInput=true;
		doOutput=true;
		useCaches=false;
	}

	/**
	 * connecta con el servidor estableciendo el valor del timeout de la conexión.
	 */
	public void connect() throws IOException {
		if(!connected){
			socket = new Socket(url.getHost(),url.getPort());
			socket.setSoTimeout(getReadTimeout());
			connected=true;
			
			tsaIn=null;
			tsaOut=null;
		}	
	}

	
	
    /**
     * Returns a RAW input stream that reads from this open connection.
     *
     * A SocketTimeoutException can be thrown when reading from the
     * returned input stream if the read timeout expires before data
     * is available for read.
     *
     * @return     an input stream that reads from this open connection.
     * @exception  IOException              if an I/O error occurs while
     *               creating the input stream.
     * @exception  UnknownServiceException  if the protocol does not support
     *               input.
     * @see #setReadTimeout(int)
     * @see #getReadTimeout()
     */
    public InputStream getInputStream() throws IOException {
    	return socket.getInputStream();
    }

    /**
     * Devuelve un Stream de entrada que es capaz de interpretar el mensaje en el formato de la TSA y devolver su contenido. 
     * @return
     * @throws IOException
     */
    public TsaInputStream getTsaInputStream() throws IOException {
    	if(tsaIn==null)
    		tsaIn=new TsaInputStream(socket.getInputStream());
    	
    	return tsaIn;
    }
    /**
     * Returns a RAW output stream that writes to this connection.
     *
     * @return     an output stream that writes to this connection.
     * @exception  IOException              if an I/O error occurs while
     *               creating the output stream.
     * @exception  UnknownServiceException  if the protocol does not support
     *               output.
     */
    public OutputStream getOutputStream() throws IOException {
	return socket.getOutputStream();
    }

    public TsaOutputStream getTsaOutputStream() throws IOException{
    	if(tsaOut==null) tsaOut=new TsaOutputStream(socket.getOutputStream());
    	return tsaOut;
    }
}
