package es.caib.signatura.afirma.rfc3161;

import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.Hashtable;
import java.util.StringTokenizer;

/**
 * Factoria de Handlers de URLS para usar de forma privada, sin tener que establecer las propiedades java.protocol.handler.pkgs
 * @author u91940
 *
 */
public class AFirmaURLStreamHandlerFactoryImpl implements URLStreamHandlerFactory {
    
	private static final String protocolPathProp = "java.protocol.handler.pkgs";
    
    /**
     * A table of protocol handlers.
     */
    static Hashtable handlers = new Hashtable();
    private static Object streamHandlerLock = new Object();

    
	public URLStreamHandler createURLStreamHandler(String protocol) {
		if("rfc3161".equals(protocol.toLowerCase()))
			return new es.caib.signatura.afirma.rfc3161.Handler();
		else
			return getURLStreamHandler(protocol);


	}
    /**
     * Returns the Stream Handler. This method is a copy of java.net.URL.getURLStreamHandler(String protocol)
     * @param protocol the protocol to use
     */
    static URLStreamHandler getURLStreamHandler(String protocol) {

	URLStreamHandler handler = (URLStreamHandler)handlers.get(protocol);
	if (handler == null) {

	    boolean checkedWithFactory = false;

	    // Try java protocol handler
	    if (handler == null) {
		String packagePrefixList = null;

		packagePrefixList
		    = (String) java.security.AccessController.doPrivileged(
                    new sun.security.action.GetPropertyAction(
		        protocolPathProp,""));
		if (packagePrefixList != "") {
		    packagePrefixList += "|";
		}

		// REMIND: decide whether to allow the "null" class prefix
		// or not.
		packagePrefixList += "sun.net.www.protocol";

		StringTokenizer packagePrefixIter =
		    new StringTokenizer(packagePrefixList, "|");

		while (handler == null &&
		       packagePrefixIter.hasMoreTokens()) {

		    String packagePrefix =
		      packagePrefixIter.nextToken().trim();
		    try {
		        String clsName = packagePrefix + "." + protocol +
			  ".Handler";
			Class cls = null;
			try {
                            cls = Class.forName(clsName);
                        } catch (ClassNotFoundException e) {
			    ClassLoader cl = ClassLoader.getSystemClassLoader();
			    if (cl != null) {
			        cls = cl.loadClass(clsName);
			    }
			}
			if (cls != null) {
			    handler  =
			      (URLStreamHandler)cls.newInstance();
			}
		    } catch (Exception e) {
			// any number of exceptions can get thrown here
		    }
		}
	    }

	    synchronized (streamHandlerLock) {

			// Insert this handler into the hashtable
			if (handler != null) {
			    handlers.put(protocol, handler);
			}

	    }
	}

	return handler;

    }
}
