package es.caib.signatura.afirma.rfc3161;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;

public class TsaOutputStream {
	int count=0;
	DataOutputStream outStr=null;
	ByteArrayOutputStream buf=null;
	
	public TsaOutputStream(OutputStream out) {
		outStr=new DataOutputStream(out);		
	}

    public void write(byte[] b) throws java.io.IOException {
    	if(buf==null)
    		buf=new ByteArrayOutputStream();
    	
    	buf.write(b);
    }
    
    public void flush() throws IOException{
    	byte [] byteBuf=buf.toByteArray();		
    	buf=null; 								//reseteamos el buffer
    	outStr.writeInt(byteBuf.length + 1);	//indicamos la longitud del mensaje
    	outStr.writeByte(0);
    	outStr.write(byteBuf);
    	outStr.flush();
    }
    
    public void close() throws IOException{
    	try{
    		outStr.close();
    	}catch(SocketException se){
    		if(!"Socket is closed".equals(se.getMessage())) throw se;
    	}
    }
	
}
