/*
 * Created on 02/09/2005
 *
 */
package es.caib.signatura.client.applet;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;

import es.caib.signatura.api.Signature;
import es.caib.signatura.api.SignatureCertNotFoundException;
import es.caib.signatura.api.SignaturePrivKeyException;
import es.caib.signatura.api.SignatureProviderException;
import es.caib.signatura.api.SignatureSignException;
import es.caib.signatura.api.SignatureVerifyException;
import es.caib.signatura.api.SignerFactory;
import es.caib.signatura.api.UpgradeNeededException;
//import es.caib.signatura.installer.Install;

/**
 * @author u07286
 *
 */
public class SignApplet extends Applet {
	public static final int WIDTH=700;
	public static final int HEIGHT=300;
	
	/**
	 * @throws java.awt.HeadlessException
	 */
	public SignApplet() throws HeadlessException {
	}
	
	/* (non-Javadoc)
	 * @see java.applet.Applet#start()
	 */
	public void start() {
		super.start();
		source = this.getParameter("source");
		target = this.getParameter("target");
		
		
		URL sourceURL;
		try {
			sourceURL = new URL (source);
		} catch (MalformedURLException e) {
			JOptionPane.showMessageDialog(null, "URL incorrecta "+source, "Firma electrònica", JOptionPane.ERROR_MESSAGE);
			return ;
		}
		try {
			sourceConnection = sourceURL.openConnection();
		} catch (IOException e1) {
			JOptionPane.showMessageDialog(null, "URL inaccesible "+source, "Firma electrònica", JOptionPane.ERROR_MESSAGE);
			return ;
		}
		
		try {
			sourceConnection.connect();
			contentType = sourceConnection.getContentType();
			jbInit();
		} catch (Exception e2) {
			JOptionPane.showMessageDialog(null, e2.toString(), "Firma electrònica", JOptionPane.ERROR_MESSAGE);
			e2.printStackTrace();
		}
	}
	
	private String contentType;
	boolean timeStamp;
	private JPanel panelCenter = new JPanel();
	private BorderLayout layoutMain = new BorderLayout();
	private JList list = new JList();
	private JScrollPane scrollPanel = new JScrollPane(list);
	private JTextField passwordText = new JPasswordField();
	private JLabel passwordLabel = new JLabel();
	private JButton signarBtn = new JButton();
	private JButton consultarBtn = new JButton();
	private JLabel jLabel1 = new JLabel();
	private JLabel jLabel2 = new JLabel();
	private JLabel jLabel3 = new JLabel();
	private PropertyResourceBundle signaturaProperties;
	private es.caib.signatura.api.Signer signer = null;
	private String source;
	private String target;
	private URLConnection sourceConnection;
	
	public void init ()
	{
		try
		{
			signaturaProperties =  (PropertyResourceBundle) ResourceBundle.getBundle("signatura");
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		
	}
	
	private void jbInit() throws Exception
	{
		setLayout(layoutMain);
		panelCenter.setLayout(null);
		
		scrollPanel.setBounds(new Rectangle(20, 25, 450, 120));
		passwordText.setBounds(new Rectangle(20, 170, 135, 20));
		passwordLabel.setText(signaturaProperties.getString ("insertPassword"));
		passwordLabel.setBounds(new Rectangle(20, 150, 195, 15));
		passwordText.addKeyListener( new KeyAdapter ()
			{
				public void keyPressed(KeyEvent e) {
					if (e.getKeyCode() == KeyEvent.VK_ENTER)
						signarBtn_mouseClicked();
				}
			}
		);
		signarBtn.setText(signaturaProperties.getString("sign"));
		signarBtn.setBounds(new Rectangle(160, 168, 85, 25));
		signarBtn.setFont(new Font("Arial", 1, 14));
		signarBtn.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e)
			{
				signarBtn_mouseClicked();
			}
		});
		consultarBtn.setText(signaturaProperties.getString("preview"));
		consultarBtn.setBounds(new Rectangle(80, 200, 125, 25));
		consultarBtn.setFont(new Font("Arial", 1, 14));
		consultarBtn.addActionListener(new ActionListener() {/* (non-Javadoc)
			* @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
			*/
			public void actionPerformed(ActionEvent e) {
				preview ();
			}
		});
		jLabel3.setText(signaturaProperties.getString("selectCert"));
		jLabel3.setBounds(new Rectangle(20, 5, 350, 20));
		add(panelCenter, BorderLayout.CENTER);
		panelCenter.add(jLabel3, null);
		panelCenter.add(jLabel2, null);
		panelCenter.add(jLabel1, null);
		panelCenter.add(signarBtn, null);
		panelCenter.add(passwordLabel, null);
		panelCenter.add(passwordText, null);
		scrollPanel.getViewport().add(list, null);
		panelCenter.add(scrollPanel, null);
		panelCenter.add(consultarBtn, null);

		initSignature();
		
	}
	
	private void preview ()
	{
		try {
			getAppletContext().showDocument(new URL (source), "_new");
		} catch (MalformedURLException e) {
			e.printStackTrace();
		}
	}

	private void initSignature()
	{
		
		SignerFactory sf = new SignerFactory();
		
		try {
			signer = sf.getSigner();
		} catch (UpgradeNeededException e) {
			e.printStackTrace();
			showMessageError ("upgradeneeded");
			// xTODO Prova.
			URL newUrl = e.getUrl();
			if (newUrl != null && !newUrl.equals("")) {
				// System.out.println( "Url orig: " + newUrl );
				try
				{
					//newUrl = Install.getHtmlInstallUrl( newUrl );
					newUrl = new URL(newUrl.toExternalForm().replaceAll("install\\.jnlp",
						"install.jsp"));
				}
				catch( Exception e2 ) 
				{
				}
				// System.out.println( "Url canviada: " + newUrl );
				this.getAppletContext().showDocument( newUrl );
			}
			return;
		}
		if (signer == null)
		{
			showMessageError("NoProvider");
			return;
		}
		String[] certList = {signaturaProperties.getString("certListNotFound")};
		list.setListData(certList);
		signarBtn.setEnabled(false);
		
		
		try {
			certList = signer.getCertList(contentType);
		}
		catch (SignaturePrivKeyException ex)
		{
			showMessageError("certListNotFound");
			ex.printStackTrace(); 
			return;
		}
		catch (SignatureCertNotFoundException cex)
		{
			showMessageError("certListNotFound");
			cex.printStackTrace(); 
			return;
		}
		
		if (certList!=null){
			list.setListData(certList);
			if (certList.length == 1)
			{
				list.setSelectedIndex(0);
				passwordText.requestFocus();
			}
			else
			{
				list.requestFocus();
			}
		}
		
		list.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		signarBtn.setEnabled(true);
		
	}
	
	
	
	
	
	private void signarBtn_mouseClicked()
	{
		if (!signarBtn.isEnabled())
		{
			return;
		}
		String certName = (String)list.getSelectedValue();
		
		if (certName==null)
		{
			showMessageBox("selectCert");
			return;
		}

		/* Permetem no possar contrassenya.
		if (passwordText.getText().equalsIgnoreCase(""))
		{
			showMessageBox("insertPassword");
			return;
		}
		*/
		
		setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));

		Signature signatureData = null;
		
		try{
			signatureData = signer.sign(sourceConnection.getInputStream(),
					certName, 
					passwordText.getText(), 
					contentType);
		}
		catch (FileNotFoundException fe)
		{
			showMessageError("documentFileNotFound");
			return;
		}
		catch (IOException io)
		{
			showMessageError("networkError");
			return;
		}
		catch (SignatureSignException e1)
		{
			JOptionPane.showMessageDialog(null, e1.getMessage(), 
					"Govern Balear: Signatura Digital", JOptionPane.ERROR_MESSAGE);
			return;
		}
		catch (Throwable se)
		{
			se.printStackTrace();
			Throwable root = se;
			while (root.getCause() != null)
				root = root.getCause();
			String message = signaturaProperties.getString("signatureError");
			if (root.getMessage() != null)
				message = message+" "+root.getMessage();
			else
				message = message+" ["+root.getClass().getName()+"]";
			JOptionPane.showMessageDialog(null, message, 
					"Govern Balear: Signatura Digital", JOptionPane.ERROR_MESSAGE);
			return;
		} finally {
			setCursor(Cursor.getDefaultCursor());
		}
		
		
		try{
			// Generar la firma
			HttpURLConnection c = (HttpURLConnection) new URL(target).openConnection();
			c.setDoInput(true);
			c.setDoOutput(true);
			c.setRequestMethod("POST");
			c.connect();
			OutputStream o = c.getOutputStream();
			ObjectOutputStream oout = new ObjectOutputStream(o);
			oout.writeObject(signatureData);
			oout.close();
			o.close();
			oout.close();
			if (signer.verify(sourceConnection.getURL(),signatureData)){
				System.out.println("La verificacion de la firma es correcta");
			}
			try {
				System.out.println(signatureData.getDate().toLocaleString());
				System.out.println(signatureData.getParsedCertificate().getName());
			} catch (Exception e) {
				System.out.println("No hay sello de tiempo");
			}
			System.out.println ("Result = "+c.getResponseMessage());
			if (c.getResponseCode() != 200)
			{
				throw new IOException ("Error enviando fichero");
			}
		}
		catch (FileNotFoundException fe)
		{
			fe.printStackTrace();
			showMessageError("signatureFileSaveError");
			return;
		}
		catch (IOException io)
		{
			io.printStackTrace();
			showMessageError("signatureFileSaveError");
			return;
		} catch (SignatureProviderException e) {
			e.printStackTrace();
		} catch (SignatureVerifyException e) {
			e.printStackTrace();
		}
		
		if (getParameter("jump") != null)
		{
			try {
				getAppletContext().showDocument(new URL(getParameter("jump")));
				return;
			} catch (MalformedURLException e) {
				e.printStackTrace();
			}
		}
		else
			showMessageBox("signatureOK");
	}
	
	
	private void showMessageBox(String message)
	{
		JOptionPane.showMessageDialog(null, signaturaProperties.getString(message), "Govern Balear: Signatura Digital", JOptionPane.INFORMATION_MESSAGE);
	}
	
	private void showMessageError(String message)
	{
		JOptionPane.showMessageDialog(null, signaturaProperties.getString(message), "Govern Balear: Signatura Digital", JOptionPane.ERROR_MESSAGE);
	}
	
	
}
