/*
 * Decompiled with CFR 0.152.
 */
package es.caib.signatura.client.applet;

import es.caib.signatura.api.Signature;
import es.caib.signatura.api.SignatureCertNotFoundException;
import es.caib.signatura.api.SignaturePrivKeyException;
import es.caib.signatura.api.SignatureProviderException;
import es.caib.signatura.api.SignatureSignException;
import es.caib.signatura.api.SignatureVerifyException;
import es.caib.signatura.api.Signer;
import es.caib.signatura.api.SignerFactory;
import es.caib.signatura.api.UpgradeNeededException;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class SignApplet
extends Applet {
    public static final int WIDTH = 700;
    public static final int HEIGHT = 300;
    private String contentType;
    boolean timeStamp;
    private JPanel panelCenter = new JPanel();
    private BorderLayout layoutMain = new BorderLayout();
    private JList list = new JList();
    private JScrollPane scrollPanel = new JScrollPane(this.list);
    private JTextField passwordText = new JPasswordField();
    private JLabel passwordLabel = new JLabel();
    private JButton signarBtn = new JButton();
    private JButton consultarBtn = new JButton();
    private JLabel jLabel1 = new JLabel();
    private JLabel jLabel2 = new JLabel();
    private JLabel jLabel3 = new JLabel();
    private PropertyResourceBundle signaturaProperties;
    private Signer signer = null;
    private String source;
    private String target;
    private URLConnection sourceConnection;

    public void start() {
        URL sourceURL;
        super.start();
        this.source = this.getParameter("source");
        this.target = this.getParameter("target");
        try {
            sourceURL = new URL(this.source);
        }
        catch (MalformedURLException e) {
            JOptionPane.showMessageDialog(null, "URL incorrecta " + this.source, "Firma electr\u00f2nica", 0);
            return;
        }
        try {
            this.sourceConnection = sourceURL.openConnection();
        }
        catch (IOException e1) {
            JOptionPane.showMessageDialog(null, "URL inaccesible " + this.source, "Firma electr\u00f2nica", 0);
            return;
        }
        try {
            this.sourceConnection.connect();
            this.contentType = this.sourceConnection.getContentType();
            this.jbInit();
        }
        catch (Exception e2) {
            JOptionPane.showMessageDialog(null, e2.toString(), "Firma electr\u00f2nica", 0);
            e2.printStackTrace();
        }
    }

    public void init() {
        try {
            this.signaturaProperties = (PropertyResourceBundle)ResourceBundle.getBundle("signatura");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.layoutMain);
        this.panelCenter.setLayout(null);
        this.scrollPanel.setBounds(new Rectangle(20, 25, 450, 120));
        this.passwordText.setBounds(new Rectangle(20, 170, 135, 20));
        this.passwordLabel.setText(this.signaturaProperties.getString("insertPassword"));
        this.passwordLabel.setBounds(new Rectangle(20, 150, 195, 15));
        this.passwordText.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SignApplet.this.signarBtn_mouseClicked();
                }
            }
        });
        this.signarBtn.setText(this.signaturaProperties.getString("sign"));
        this.signarBtn.setBounds(new Rectangle(160, 168, 85, 25));
        this.signarBtn.setFont(new Font("Arial", 1, 14));
        this.signarBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SignApplet.this.signarBtn_mouseClicked();
            }
        });
        this.consultarBtn.setText(this.signaturaProperties.getString("preview"));
        this.consultarBtn.setBounds(new Rectangle(80, 200, 125, 25));
        this.consultarBtn.setFont(new Font("Arial", 1, 14));
        this.consultarBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SignApplet.this.preview();
            }
        });
        this.jLabel3.setText(this.signaturaProperties.getString("selectCert"));
        this.jLabel3.setBounds(new Rectangle(20, 5, 350, 20));
        this.add((Component)this.panelCenter, "Center");
        this.panelCenter.add((Component)this.jLabel3, null);
        this.panelCenter.add((Component)this.jLabel2, null);
        this.panelCenter.add((Component)this.jLabel1, null);
        this.panelCenter.add((Component)this.signarBtn, null);
        this.panelCenter.add((Component)this.passwordLabel, null);
        this.panelCenter.add((Component)this.passwordText, null);
        this.scrollPanel.getViewport().add((Component)this.list, null);
        this.panelCenter.add((Component)this.scrollPanel, null);
        this.panelCenter.add((Component)this.consultarBtn, null);
        this.initSignature();
    }

    private void preview() {
        try {
            this.getAppletContext().showDocument(new URL(this.source), "_new");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    private void initSignature() {
        String signaturaPropertiesServletURL = this.getParameter("signaturaPropertiesServletURL");
        SignerFactory sf = null;
        try {
            if (signaturaPropertiesServletURL != null) {
                Properties p = new Properties();
                p.load(new URL(signaturaPropertiesServletURL).openStream());
                sf = new SignerFactory((Map)p);
            } else {
                sf = new SignerFactory();
            }
            this.signer = sf.getSigner();
        }
        catch (UpgradeNeededException e) {
            e.printStackTrace();
            this.showMessageError("upgradeneeded");
            URL newUrl = e.getUrl();
            if (newUrl != null && !newUrl.equals("")) {
                try {
                    newUrl = new URL(newUrl.toExternalForm().replaceAll("install\\.jnlp", "install.jsp"));
                }
                catch (Exception e2) {
                    // empty catch block
                }
                this.getAppletContext().showDocument(newUrl);
            }
            return;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            this.showMessageError("Error en la configuraci\u00f3n de la firma: " + e.getMessage());
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            this.showMessageError("Error en la configuraci\u00f3n de la firma: " + e.getMessage());
            return;
        }
        if (this.signer == null) {
            this.showMessageError("NoProvider");
            return;
        }
        String[] certList = new String[]{this.signaturaProperties.getString("certListNotFound")};
        this.list.setListData(certList);
        this.signarBtn.setEnabled(false);
        try {
            certList = this.signer.getCertList(this.contentType);
        }
        catch (SignaturePrivKeyException ex) {
            this.showMessageError("certListNotFound");
            ex.printStackTrace();
            return;
        }
        catch (SignatureCertNotFoundException cex) {
            this.showMessageError("certListNotFound");
            cex.printStackTrace();
            return;
        }
        if (certList != null) {
            this.list.setListData(certList);
            if (certList.length == 1) {
                this.list.setSelectedIndex(0);
                this.passwordText.requestFocus();
            } else {
                this.list.requestFocus();
            }
        }
        this.list.setSelectionMode(0);
        this.signarBtn.setEnabled(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signarBtn_mouseClicked() {
        if (!this.signarBtn.isEnabled()) {
            return;
        }
        String certName = (String)this.list.getSelectedValue();
        if (certName == null) {
            this.showMessageBox("selectCert");
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        Signature signatureData = null;
        try {
            signatureData = this.signer.sign(this.sourceConnection.getInputStream(), certName, this.passwordText.getText(), this.contentType);
        }
        catch (FileNotFoundException fe) {
            this.showMessageError("documentFileNotFound");
            return;
        }
        catch (IOException io) {
            this.showMessageError("networkError");
            return;
        }
        catch (SignatureSignException e1) {
            JOptionPane.showMessageDialog(null, e1.getMessage(), "Govern Balear: Signatura Digital", 0);
            return;
        }
        catch (Throwable se) {
            se.printStackTrace();
            Throwable root = se;
            while (root.getCause() != null) {
                root = root.getCause();
            }
            String message = this.signaturaProperties.getString("signatureError");
            message = root.getMessage() != null ? message + " " + root.getMessage() : message + " [" + root.getClass().getName() + "]";
            JOptionPane.showMessageDialog(null, message, "Govern Balear: Signatura Digital", 0);
            return;
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
        try {
            HttpURLConnection c = (HttpURLConnection)new URL(this.target).openConnection();
            c.setDoInput(true);
            c.setDoOutput(true);
            c.setRequestMethod("POST");
            c.connect();
            OutputStream o = c.getOutputStream();
            ObjectOutputStream oout = new ObjectOutputStream(o);
            oout.writeObject(signatureData);
            oout.close();
            o.close();
            oout.close();
            if (this.signer.verify(this.sourceConnection.getURL(), signatureData)) {
                System.out.println("La verificacion de la firma es correcta");
            }
            try {
                System.out.println(signatureData.getDate().toLocaleString());
                System.out.println(signatureData.getParsedCertificate().getName());
            }
            catch (Exception e) {
                System.out.println("No hay sello de tiempo");
            }
            System.out.println("Result = " + c.getResponseMessage());
            if (c.getResponseCode() != 200) {
                throw new IOException("Error enviando fichero");
            }
        }
        catch (FileNotFoundException fe) {
            fe.printStackTrace();
            this.showMessageError("signatureFileSaveError");
            return;
        }
        catch (IOException io) {
            io.printStackTrace();
            this.showMessageError("signatureFileSaveError");
            return;
        }
        catch (SignatureProviderException e) {
            e.printStackTrace();
        }
        catch (SignatureVerifyException e) {
            e.printStackTrace();
        }
        if (this.getParameter("jump") != null) {
            try {
                this.getAppletContext().showDocument(new URL(this.getParameter("jump")));
                return;
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        } else {
            this.showMessageBox("signatureOK");
        }
    }

    private void showMessageBox(String message) {
        JOptionPane.showMessageDialog(null, this.signaturaProperties.getString(message), "Govern Balear: Signatura Digital", 1);
    }

    private void showMessageError(String message) {
        JOptionPane.showMessageDialog(null, this.signaturaProperties.getString(message), "Govern Balear: Signatura Digital", 0);
    }
}

