package es.caib.signatura.client.applet;

import javax.swing.JPanel;

import java.awt.Cursor;
import java.awt.HeadlessException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;

import javax.swing.JApplet;
import javax.swing.JLabel;
import javax.swing.SwingConstants;

import es.caib.signatura.api.Signer;
import es.caib.signatura.api.SignerFactory;
import es.caib.signatura.api.UpgradeNeededException;

import java.util.*;

import java.awt.Font;

public class VerifyApplet extends JApplet {

	
	private static final long serialVersionUID = 1L;
	private JPanel jContentPane = null;
	private JLabel jLabel1 = null;
	private JLabel jLabel = null;
	private JLabel jMaquina = null;
	private JLabel jLibreria = null;
	private String ua;
	private String browser;
	private float browserVer;
	private JLabel jLabel2 = null;
	private JLabel jBrowser = null;
	private boolean mv = false;
	private boolean lt = false;
	private JLabel jLabel3 = null;
	private JLabel jLabel5 = null;
	private JLabel jLabel6 = null;
	private JLabel jLabel7 = null;
	private JLabel jMaquinaDesc = null;
	private JLabel jLibDesc = null;
	private String dir = null; 
	private ResourceBundle res = null;
	private String lng = null;
	private String installURL;
	public VerifyApplet() throws HeadlessException {
		super();
	}

	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	public void init() {
		this.setBounds(new java.awt.Rectangle(0,0,500,110));
		this.dir = this.getParameter("url");
		this.lng = this.getParameter("lng");
		Locale locale = null;
		if (lng==null) { lng="es";}
		if (lng.equals("es")){
			locale=new Locale("es","ES");
		}
		if (lng.equals("ca")) {
			locale=new Locale("ca","CA");
		}
	    res = ResourceBundle.getBundle("message", locale);
	    this.setContentPane(getJContentPane());
	}

	/**
	 * This method initializes jContentPane
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJContentPane() {
		if (jContentPane == null) {
			jLibDesc = new JLabel();
			jLibDesc.setBounds(new java.awt.Rectangle(336,60,94,17));
			jLibDesc.setForeground(new java.awt.Color(220,0,232));
			jLibDesc.setHorizontalAlignment(SwingConstants.LEFT);
			jLibDesc.setHorizontalTextPosition(SwingConstants.LEFT);
			jLibDesc.setText(res.getString("descargar"));
			jLibDesc.setFont(new java.awt.Font("Arial", java.awt.Font.PLAIN, 12));
			jLibDesc.addMouseListener(new java.awt.event.MouseAdapter() {   
				public void mouseExited(java.awt.event.MouseEvent e) {    
					jLibDesc.setText("<html><body>"+res.getString("descargar")+"</body></html>");
					setCursor( new Cursor( Cursor.DEFAULT_CURSOR ) );
				}   
				public void mouseEntered(java.awt.event.MouseEvent e) {    
					jLibDesc.setText("<html><body><u>"+res.getString("descargar")+"</u></body></html>");
					setCursor( new Cursor( Cursor.HAND_CURSOR ) );
				}
				public void mouseClicked(java.awt.event.MouseEvent e) {
					try {
						//getAppletContext().showDocument(new URL(installURL+"?jvm="+System.getProperty("java.home")),"_blank");
						getAppletContext().showDocument(new URL(installURL));
					} catch (MalformedURLException e1) {
						e1.printStackTrace();
					}
				}
			});
			jMaquinaDesc = new JLabel();
			jMaquinaDesc.setBounds(new java.awt.Rectangle(336,39,93,17));
			jMaquinaDesc.setHorizontalAlignment(SwingConstants.LEFT);
			jMaquinaDesc.setHorizontalTextPosition(SwingConstants.LEFT);
			jMaquinaDesc.setText(res.getString("descargar"));
			jMaquinaDesc.setForeground(new java.awt.Color(220,0,232));
			jMaquinaDesc.setFont(new java.awt.Font("Arial", java.awt.Font.PLAIN, 12));
			jMaquinaDesc.addMouseListener(new java.awt.event.MouseAdapter() {   
				public void mouseExited(java.awt.event.MouseEvent e) {    
					jMaquinaDesc.setText("<html><body>"+res.getString("descargar")+"</body></html>");
					setCursor( new Cursor( Cursor.DEFAULT_CURSOR ) );
				}   
				public void mouseEntered(java.awt.event.MouseEvent e) {    
					jMaquinaDesc.setText("<html><body><u>"+res.getString("descargar")+"</u></body></html>");
					setCursor( new Cursor( Cursor.HAND_CURSOR));
				}   
			
				public void mouseClicked(java.awt.event.MouseEvent e) {
					try {
						getAppletContext().showDocument(new URL("http://java.sun.com/javase/downloads/index.jsp"),"_blank");
					} catch (MalformedURLException e1) {
						e1.printStackTrace();
					}
				}
			});
			jLabel7 = new JLabel();
			jLabel7.setBounds(new java.awt.Rectangle(431,16,13,18));
			jLabel7.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
			jLabel7.setHorizontalTextPosition(SwingConstants.LEFT);
			jLabel7.setText("o");
			jLabel7.setFont(new Font("Arial", Font.PLAIN, 12));
			jLabel7.setVisible(false);
			jLabel6 = new JLabel();
			jLabel6.setBounds(new java.awt.Rectangle(444,16,44,18));
			jLabel6.setHorizontalAlignment(SwingConstants.LEFT);
			jLabel6.setHorizontalTextPosition(SwingConstants.LEFT);
			jLabel6.setText("Firefox");
			jLabel6.setForeground(new java.awt.Color(220,0,232));
			jLabel6.setFont(new Font("Dialog", Font.PLAIN, 12));
			jLabel6.setVisible(false);
			jLabel6.addMouseListener(new java.awt.event.MouseAdapter() {   
				public void mouseExited(java.awt.event.MouseEvent e) {    
					jLabel6.setText("<html><body>Firefox</body></html>");
					setCursor( new Cursor( Cursor.DEFAULT_CURSOR ) );
				}   
				public void mouseEntered(java.awt.event.MouseEvent e) {    
					jLabel6.setText("<html><body><u>Firefox</u></body></html>");
					setCursor( new Cursor( Cursor.HAND_CURSOR ) );
				}
				public void mouseClicked(java.awt.event.MouseEvent e) {
					try {
						getAppletContext().showDocument(new URL("http://www.mozilla.org/products/firefox/"),"_blank");
					} catch (MalformedURLException e1) {
						e1.printStackTrace();
					}
				}
			});
			jLabel5 = new JLabel();
			jLabel5.setBounds(new java.awt.Rectangle(336,16,95,18));
			jLabel5.setHorizontalAlignment(SwingConstants.LEFT);
			jLabel5.setHorizontalTextPosition(SwingConstants.LEFT);
			jLabel5.setText("Internet Explorer");
			jLabel5.setForeground(new java.awt.Color(220,0,232));
			jLabel5.setFont(new Font("Dialog", Font.PLAIN, 12));
			jLabel5.setVisible(false);
			jLabel5.addMouseListener(new java.awt.event.MouseAdapter() {   
				public void mouseExited(java.awt.event.MouseEvent e) {    
					jLabel5.setText("<html><body>Internet Explorer</body></html>");
					setCursor( new Cursor( Cursor.DEFAULT_CURSOR ) );
				}   
				public void mouseEntered(java.awt.event.MouseEvent e) {    
					jLabel5.setText("<html><body><u>Internet Explorer</u></body></html>");
					setCursor( new Cursor( Cursor.HAND_CURSOR ) );
				}   
				public void mouseClicked(java.awt.event.MouseEvent e) {
					try {
						getAppletContext().showDocument(new URL("http://www.microsoft.com/windows/ie/downloads/default.mspx#ENC"),"_blank");
					} catch (MalformedURLException e1) {
						e1.printStackTrace();
					}
				}
			});
			jLabel3 = new JLabel();
			jLabel3.setBounds(new java.awt.Rectangle(2,82,320,17));
			jLabel3.setHorizontalTextPosition(SwingConstants.RIGHT);
			jLabel3.setText(res.getString("bien"));
			jLabel3.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
			jLabel3.setForeground(new java.awt.Color(14,193,55));
			jLabel3.setFont(new java.awt.Font("Arial", java.awt.Font.BOLD, 12));
			jLabel3.setVisible(true);
			jBrowser = new JLabel();
			jBrowser.setBounds(new java.awt.Rectangle(126,16,206,18));
			jBrowser.setHorizontalAlignment(SwingConstants.LEFT);
			jBrowser.setHorizontalTextPosition(SwingConstants.LEFT);
			jBrowser.setText("Navegador no certificado se recomienda");
			jBrowser.setFont(new java.awt.Font("Arial", java.awt.Font.PLAIN, 12));
			jBrowser.addMouseListener(new java.awt.event.MouseAdapter() {
				public void mouseClicked(java.awt.event.MouseEvent e) {
					try {
						getAppletContext().showDocument(new URL("http://www.mozilla.org/products/firefox/"),"_blank");
					} catch (MalformedURLException e1) {
						e1.printStackTrace();
					}
				}
			});
			jLabel2 = new JLabel();
			jLabel2.setBounds(new java.awt.Rectangle(2,17,94,17));
			jLabel2.setHorizontalTextPosition(javax.swing.SwingConstants.LEFT);
			jLabel2.setText(res.getString("navegador"));
			jLabel2.setFont(new java.awt.Font("Arial", java.awt.Font.BOLD, 12));
			jLabel2.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
			jLibreria = new JLabel();
			jLibreria.setBounds(new java.awt.Rectangle(126,58,204,17));
			jLibreria.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
			jLibreria.setHorizontalTextPosition(javax.swing.SwingConstants.LEFT);
			jLibreria.setText("");
			jLibreria.setFont(new java.awt.Font("Arial", java.awt.Font.PLAIN, 12));
			jMaquina = new JLabel();
			jMaquina.setBounds(new java.awt.Rectangle(126,37,204,18));
			jMaquina.setHorizontalTextPosition(javax.swing.SwingConstants.LEFT);
			jMaquina.setText("");
			jMaquina.setFont(new java.awt.Font("Arial", java.awt.Font.PLAIN, 12));
			jMaquina.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
			jLabel = new JLabel();
			jLabel.setBounds(new java.awt.Rectangle(2,58,117,17));
			jLabel.setHorizontalTextPosition(javax.swing.SwingConstants.LEFT);
			jLabel.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
			jLabel.setFont(new java.awt.Font("Arial", java.awt.Font.BOLD, 12));
			jLabel.setText(res.getString("lib")+" :");
			jLabel1 = new JLabel();
			jLabel1.setBounds(new java.awt.Rectangle(2,37,94,17));
			jLabel1.setHorizontalTextPosition(javax.swing.SwingConstants.LEFT);
			jLabel1.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
			jLabel1.setFont(new java.awt.Font("Arial", java.awt.Font.BOLD, 12));
			jLabel1.setText(res.getString("mv")+" :");
			jContentPane = new JPanel();
			jContentPane.setLayout(null);
			jContentPane.setBackground(java.awt.Color.white);
			jContentPane.setVisible(true);
			jContentPane.add(jLabel1, null);
			jContentPane.add(jLabel, null);
			jContentPane.add(jMaquina, null);
			jContentPane.add(jLibreria, null);
			jContentPane.add(jLabel2, null);
			jContentPane.add(jBrowser, null);
			jContentPane.add(jLabel3, null);
			jContentPane.add(jLabel5, null);
			jContentPane.add(jLabel6, null);
			jContentPane.add(jLabel7, null);
			jContentPane.add(jMaquinaDesc, null);
			jContentPane.add(jLibDesc, null);
		}
		return jContentPane;
	}

	private void getBrowser(String ua){
		browser = "Navegador desconocido";
		int place = 0;
		if ((ua.indexOf("msie")+1) > 0) 
			 {
			   browser = "Internet Explorer";
			   place = ua.indexOf("msie")+1;
			   place = place+4;
			   String ver = ua.substring(place ,place+3);
			   browserVer = new Float(ver).floatValue();
			  }
		else
		{
			if ((ua.indexOf("firefox")+1) > 0) 
			 {
			  browser = "Firefox";
			  place = ua.indexOf("firefox")+1;
			  place = place+7;
			  String ver = ua.substring(place ,place+3);
			  browserVer = new Float(ver).floatValue();
			 } else{
				 browser = "Navegador no certificado";
			 }
		}		
	}
	
	private boolean checkVersion(String actVersion,Integer version){
		String ver = null;
		if (actVersion.length()>=5){
			ver = actVersion.substring(0 ,1)+actVersion.substring(2 ,3)+actVersion.substring(4 ,5);
		}
		else{
			ver = actVersion.substring(0 ,1)+actVersion.substring(2 ,3)+"0";
		}
		Integer ver1 = new Integer(ver);
		if (version.intValue() > ver1.intValue()){
			mv = false;
			return (false);
		}else{
			mv = true;
			return(true);
		}
	}
	
	private void check(){
		ua = this.getParameter("ua");
		String version = System.getProperty("java.version");
	    if (checkVersion(version,new Integer(142))){
	    	jMaquinaDesc.setVisible(false);
	    	this.jMaquina.setText(System.getProperty("java.version")+" ("+res.getString("actualizado")+")");
	    }else{
	    	jMaquinaDesc.setVisible(true);
	    	this.jMaquina.setText(System.getProperty("java.version")+" ("+res.getString("noact")+")");
	    }
	    getBrowser(ua);
	    if (browser!="Navegador no certificado"){
	    	jBrowser.setText(browser+" "+browserVer);
	    	jLabel5.setVisible(false);
	    	jLabel6.setVisible(false);
	    	jLabel7.setVisible(false);
	    }else{
	    	jBrowser.setText("<html><body>"+res.getString("nocert"));
	    	jLabel5.setVisible(true);
	    	jLabel6.setVisible(true);
	    	jLabel7.setVisible(true);
	    }
	    
	    Class c = null;
		try {
			Signer s = new SignerFactory ().getSigner();
			jLibreria.setText(s.getAPIVersion()+" ("+res.getString("actualizados")+")");
			jLibDesc.setVisible(false);
			lt = true;
		} catch (UpgradeNeededException e) {
			jLibreria.setText(e.getMessage()+" ("+res.getString("noact")+")");
			installURL = e.getUrl().toString();
			jLibDesc.setVisible(true);
		} 
		if ((mv) && (lt)){
			jLabel3.setForeground(new java.awt.Color(14,193,55));
			jLabel3.setText(res.getString("bien"));
			jLabel3.setVisible(true);
		}
		else{
			jLabel3.setForeground(java.awt.Color.red);
			jLabel3.setText(res.getString("red"));
			jLabel3.setVisible(true);
		}
	}

	public void start() {
		super.start();
		this.check();
	}
}

