package es.caib.signatura.provider.impl.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CRL;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Vector;

import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.MimeMessage;

import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedDataParser;
import org.bouncycastle.cms.CMSTypedStream;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.x509.NoSuchStoreException;

import es.caib.signatura.api.Signature;
import es.caib.signatura.api.SignatureDataException;
import es.caib.signatura.impl.SMIMESignatureProxy;

/**
 * Intérprete de SMIMEs de tipo multipart/signed (firmas adjuntas)
 * Desagrupa todas las firmas para tratarlas separadamente, y da acceso al contenido firmado.
 * @author u91940
 *
 */
public class DetachedSMIME extends SMIMEImpl {

	/**
	 * Procesa las partes de un documento smime de tipo  multipart/signed.
	 * La parte que no es de tipo  application/pkcs7-signature se considera el contenido firmado.
	 * 
	 * @param mime
	 * @throws MessagingException
	 * @throws IOException
	 * @throws SignatureDataException
	 * @throws NoSuchProviderException
	 * @throws NoSuchAlgorithmException
	 * @throws CertStoreException
	 * @throws CMSException
	 * @throws NoSuchStoreException
	 * @throws InvalidAlgorithmParameterException
	 */
	public void parse(MimeMessage mime) throws MessagingException, IOException, SignatureDataException, NoSuchProviderException, NoSuchAlgorithmException, CertStoreException, CMSException, NoSuchStoreException, InvalidAlgorithmParameterException{
        
	        //Si el mime es un MULTIPART_SIGNED, buscamos la parte que no es de firma, esa parte debe ser un nuevo mensaje MIME,  
	        //el cual volveremos a analizar. 
	        if (mime.isMimeType(MULTIPART_SIGNED)) {        
	          Multipart multipart = (Multipart)mime.getContent();                    
	          int ip;
	          for ( ip=0;ip<multipart.getCount();ip++) {
	            Part part = multipart.getBodyPart(ip);
	            
	            if (!part.isMimeType(DETACHED_SIGNATURE)) {              
	            	//si es documento mirar si contiene firmas en niveles inferiores

	            		//parseamos recursivamente
            			contentType=part.getContentType();
	            		//guardamos el documento en el String
	            	    signedObject=readStream(part.getInputStream());

        		    
	            }else{

	            	signatures=extractSignatures(readStream(part.getInputStream()));
	
     	
	            }
	          }//end.for
	          
	          
	        }else{          
	          		          
	        }        
		      


		
	}

	/**
	 * Procesa el bloque que contiene las firmas. Desagrupa las firmas, los certificados y las CRLS, generando un array de firmas que contiene la firma, certificados y CRLs de cada firmante.
	 *
	 * @param pkcs7
	 * @return
	 * @throws IOException
	 * @throws CMSException
	 * @throws SignatureDataException
	 * @throws NoSuchProviderException
	 * @throws NoSuchStoreException
	 * @throws NoSuchAlgorithmException
	 * @throws CertStoreException
	 * @throws InvalidAlgorithmParameterException
	 */
	private Signature [] extractSignatures(byte[] pkcs7) throws IOException, CMSException, SignatureDataException, NoSuchProviderException, NoSuchStoreException, NoSuchAlgorithmException, CertStoreException, InvalidAlgorithmParameterException {
		Vector signatures=new Vector();

		//Agafem la firma
		//mirem quants firmants té
		//per cada firmant clonem la firma i eliminem els firmant que no són el que estem tractant
		
		try{
			if(Security.getProvider("BC") == null){
				Provider p = (Provider) this.getClass().getClassLoader().loadClass("org.bouncycastle.jce.provider.BouncyCastleProvider").newInstance();
				Security.addProvider(p);
			}
			
		}catch(Exception e){
			e.printStackTrace();
		}
		
		ByteArrayInputStream voidContentData = new ByteArrayInputStream(new byte[0]);
		CMSTypedStream typedIn = new CMSTypedStream (voidContentData);
		CMSSignedDataParser parser = new CMSSignedDataParser(typedIn,pkcs7);		
		parser.getSignedContent().drain();
		
	    SignerInformationStore  signers = parser.getSignerInfos();
		Iterator it = signers.getSigners().iterator();
		
		//Per cada firmant
		while(it.hasNext()){
			SignerInformation signer = (SignerInformation) it.next();
			ByteArrayInputStream new_voidContentData = new ByteArrayInputStream(new byte[0]);
			CMSTypedStream new_typedIn = new CMSTypedStream (new_voidContentData);
			CMSSignedDataParser new_signedData = new CMSSignedDataParser (new_typedIn, pkcs7);		
			new_signedData.getSignedContent().drain();
			
			//reemplazamos los firmantes
			Vector new_signers=new Vector();
			new_signers.add(new_signedData.getSignerInfos().get(signer.getSID()));
			
			SignerInformationStore new_signersStore = new SignerInformationStore(new_signers);
			
			ByteArrayInputStream inStr=new ByteArrayInputStream(pkcs7);
			ByteArrayOutputStream outStr=new ByteArrayOutputStream();
			
			CMSSignedDataParser.replaceSigners(inStr,new_signersStore,outStr);

			try{
				inStr.close();
			}catch(IOException ex){}
			
			inStr=new ByteArrayInputStream(outStr.toByteArray());

			try{
				outStr.close();
			}catch(IOException ex){}
			
			outStr=new ByteArrayOutputStream();
			
			CertStore store=new_signedData.getCertificatesAndCRLs("Collection", "BC");
			Vector newCertStoreCollection=new Vector();
			
			//Cogemos los certificados
			X509Certificate[] new_certs;
			new_certs=extractCertificateChain(store,signer);
			for(int i=0;i<new_certs.length;i++)
				newCertStoreCollection.add(new_certs[i]);
			
			//cogemos las CRL
			CRL crls[]=(CRL [])store.getCRLs(new CertStoreCRLSelector(new_certs)).toArray(new CRL [0]);
			for(int i=0;i<crls.length;i++)
				newCertStoreCollection.add(crls[i]);			
			
			
			//reemplazamos ambas
			CollectionCertStoreParameters param = new CollectionCertStoreParameters(newCertStoreCollection);
			CertStore new_certsStore = CertStore.getInstance("Collection", param);
			
			CMSSignedDataParser.replaceCertificatesAndCRLs(inStr,new_certsStore,outStr);

			try{
				inStr.close();
			}catch(IOException ex){}
			
			byte new_pkcs7 []= outStr.toByteArray();

			try{
				outStr.close();
			}catch(IOException ex){}	
			
			SMIMESignatureProxy new_signature=new SMIMESignatureProxy(new_pkcs7,contentType);
			signatures.add(new_signature);
		}
		
		return (Signature [])signatures.toArray(new Signature [signatures.size()]);
	}
	
	/**
	 * Función que facilita la lectura de InputStreams
	 * 
	 * @param is
	 * @return
	 * @throws IOException
	 */
	public byte[] readStream(InputStream is) throws IOException{
		ByteArrayOutputStream out=new ByteArrayOutputStream();
		
		int c=-1;
		try{
			do{
				c=is.read();
				if(c!=-1)
					out.write(c);
				else{
					out.flush();
					out.close();
				}
			}while(c!=-1);
			
			return out.toByteArray();
			
		}catch(IOException ioex){
			try{
				is.close();
			}catch(IOException e1){ e1.printStackTrace(); }
			
			try{
				out.close();	
			}catch(IOException e2){ e2.printStackTrace(); }
			
			throw ioex;
		}finally{
			try{
				is.close();
			}catch(IOException e1){ e1.printStackTrace(); }
			
			try{
				out.close();	
			}catch(IOException e2){ e2.printStackTrace(); }
				
		}
	}

	/**
	 * Extrae la cadena de certificación asociada a un firmante de un CertStore.
	 *   
	 * @param certs
	 * @param signer
	 * @return
	 * @throws NoSuchAlgorithmException
	 * @throws NoSuchProviderException
	 * @throws CMSException
	 * @throws CertStoreException
	 */
	public X509Certificate[] extractCertificateChain(CertStore certs,SignerInformation signer) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException, CertStoreException{
		X509Certificate userCertificate = null;

		
		
		Collection certCollection = certs.getCertificates(signer.getSID());
		Iterator certIt = certCollection.iterator();
		if (certIt.hasNext()){
			userCertificate = (X509Certificate)certIt.next();
		}
		/*
		 * Se extrae la cadena de certificación
		 * 
		 */
		certCollection = certs.getCertificates(null);
		certIt = certCollection.iterator();
		LinkedList allCertificates = new LinkedList();			
		while (certIt.hasNext())
		{
			allCertificates.addFirst(certIt.next());
		}			
		boolean finishExtraction = allCertificates.size() == 0;
		X509Certificate currentCertificate = userCertificate; 
		LinkedList certificateChainList = new LinkedList();
		certificateChainList.addFirst(userCertificate);
		while(!finishExtraction){
			ListIterator iterator = allCertificates.listIterator();
			boolean nextCertificate = false;
			X509Certificate certificateFromIterator = null;
			while(iterator.hasNext() && !nextCertificate){	
				certificateFromIterator = (X509Certificate)iterator.next();
				nextCertificate = certificateFromIterator.getSubjectDN().toString().compareTo(currentCertificate.getIssuerDN().toString()) == 0;
			}
			if(nextCertificate){
				certificateChainList.addLast(certificateFromIterator);
				currentCertificate = certificateFromIterator;
			}
			finishExtraction = !nextCertificate || 
				currentCertificate.getIssuerDN().toString().compareTo(currentCertificate.getSubjectDN().toString()) == 0;
		}
        return (X509Certificate[]) certificateChainList.toArray(new X509Certificate[certificateChainList.size()]);

	}


}
