/**
 * 
 */
package es.caib.signatura.provider.impl.common;

import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;

import es.caib.signatura.api.ParsedCertificate;
import es.caib.signatura.impl.SigDebug;

/**
 * @author u91940
 *
 */
public class ANCERTParsedCertificate implements InternalParsedCertificate {

	X509CertificateStructure certificate;
	String nif;
	String fullName;
	String givenName;
	String surName;
	String nifResponsable;
	boolean personaFisica;
	boolean personaJuridica;
	
	
	
	public final static String CNP  = new String("1.3.6.1.4.1.18920.1.1.1.1");
	public final static String CNPR = new String("1.3.6.1.4.1.18920.1.1.2.1");
	public final static String CNCR = new String("1.3.6.1.4.1.18920.1.3.2.1");
	public final static String FERN = new String("1.3.6.1.4.1.18920.4.1.1.1");
	
	
	public ANCERTParsedCertificate (X509Certificate cert[], boolean securedevice ) throws CertificateEncodingException, IOException
	{
		init (cert, securedevice );
	}



	/**
	 * Hasta la versión 2.5 devolvía el nombre del representante. 
	 * A partir de la versión 2.5 devuelve el nombre del Representado
	 */
	public String getName() {
		if ( getFullName () != null)
			return getFullName();
		return certificate.getSubject().toString();
	}
	
	/* (non-Javadoc)
	 * @see es.caib.signatura.impl.CertificateParser#getNif()
	 */
	public String getNif ()
	{
		return nif;
	}
	
	public boolean equals(Object obj) {
		if (obj instanceof ANCERTParsedCertificate)
		{
			ANCERTParsedCertificate other = (ANCERTParsedCertificate) obj;
			if ( certificate != null && other.certificate != null ) 
				return certificate.equals(other.certificate);
		}

		return false;
	}
	
	public String toString() {
		String s;
		if (certificate !=null)
			s = certificate.getSubject().toString()+"("+certificate.getIssuer().toString()+")";
		else 
			s="";
			
		s = s + " FullName:"+fullName+" NIF:"+nif;
		if ( nifResponsable != null)
			s = s + " NIF Responsable:"+nifResponsable;

		return s;
	}

	public String getNifResponsable() {
		return nifResponsable;
	}

	public boolean isPersonaFisica() {
		return personaFisica;
	}
	
	public boolean isPersonaJuridica() {
		return personaJuridica;
	}
	
	/**
	 * Hasta la versión 2.5 devolvía el nombre del representante. 
	 * A partir de la versión 2.5 devuelve el nombre del Representado
	 */
	public String getFullName () {
		//if (givenName == null || surName == null)
			return fullName;
		//else
		//	return surName+" "+givenName;
	}

	public String getCommonName() {
		return fullName;
	}

	private void init(X509Certificate[] cert, boolean securedevice) throws CertificateEncodingException, IOException {
		byte b [] = cert[0].getEncoded ();
		ASN1InputStream asn1is = new ASN1InputStream ( b );
		DERObject obj = asn1is.readObject ();
		certificate = new X509CertificateStructure ((ASN1Sequence) obj);
		// Procesar el SUBJECT NAME

		// Procesar el ALTERNATE SUBJECT NAME
		TBSCertificateStructure tbs = certificate.getTBSCertificate ();
		X509Extensions exts = tbs.getExtensions ();

		if( SigDebug.isActive() )  SigDebug.write( "ParsedCertificateImp.init: extensionss null ?" + ( exts == null ? "si" : "no") );
		if( exts != null ) {

			// Procesar la política
			if( SigDebug.isActive() )  SigDebug.write( "ParsedCertificateImpl.init: calculant extensions CertificatePolicies" );
			X509Extension polext = exts.getExtension (X509Extensions.CertificatePolicies);
			if( SigDebug.isActive() )  SigDebug.write( "ParsedCertificateImpl.init: extensions CertificatePolicies null ?" + (polext == null ? "si" : "no") );
			if (polext != null) {
				ASN1Sequence asn1seq;
				asn1is = new ASN1InputStream ( polext.getValue ().getOctets() );
				asn1seq = (ASN1Sequence) asn1is.readObject ();
				Enumeration polInfo = asn1seq.getObjects();
				while (polInfo.hasMoreElements())
				{
					ASN1Sequence seq2 = (ASN1Sequence) polInfo.nextElement();
					PolicyInformation info = new PolicyInformation(seq2);
					processPolicy (certificate,info.getPolicyIdentifier().getId(), exts, securedevice);
				}
			}else{
				processPolicy (certificate,"", exts, securedevice);
			}
	

		}else{
			throw new ClassCastException();
		}
		
	}




	private void processPolicy(X509CertificateStructure certificate2,String policy_id, X509Extensions exts, boolean securedevice) {
		
		X509Name name = certificate2.getSubject();
		personaFisica = false;
		personaJuridica = false;

		if(policy_id.equals(CNP) || policy_id.equals(FERN)){
			nif=(String)name.getValues(name.SN).get(0);
			fullName=(String)name.getValues(name.CN).get(0);
			givenName=(String)name.getValues(name.GIVENNAME).get(0); //Nomnre del representante
			surName=(String)name.getValues(name.SURNAME).get(0); //Apellido del representante
			nifResponsable=null;
			
			personaFisica=true;
			personaJuridica=false;

		}else if(policy_id.equals(CNPR)){
			//s'ha de tractar com a la persona representada
			int i=0;
			for(i=0;i<name.getValues(name.OU).size();i++){
				String representado=(String)name.getValues(name.OU).get(i);
				if(representado.indexOf("Autorizado ante Notario")!=-1) continue;
				
				nif=representado.substring(representado.lastIndexOf("-")+5); //devuelve el CIF
				fullName=representado.substring(0,representado.lastIndexOf("-")-1); //devuelve el nombre de la empresa
				givenName=(String)name.getValues(name.GIVENNAME).get(0); //Nomnre del representante
				surName=(String)name.getValues(name.SURNAME).get(0); //Apellido del representante
				nifResponsable=(String)name.getValues(name.SN).get(0);;
				
				personaFisica=true;
				personaJuridica=false;
			}
		}else if(policy_id.equals(CNCR)){
			
			//s'ha de tractar com a l'empresa representada
			int i=0;
			for(i=0;i<name.getValues(name.OU).size();i++){
				String representado=(String)name.getValues(name.OU).get(i);
				if(representado.indexOf("Autorizado ante Notario")!=-1) continue;
				
				nif=representado.substring(representado.lastIndexOf("-")+6); //devuelve el CIF
				fullName=representado.substring(0,representado.lastIndexOf("-")-1); //devuelve el nombre de la empresa
				givenName=(String)name.getValues(name.GIVENNAME).get(0); //Nomnre del representante
				surName=(String)name.getValues(name.SURNAME).get(0); //Apellido del representante
				nifResponsable=(String)name.getValues(name.SN).get(0);;
				
				personaFisica=false;
				personaJuridica=true;
			}			
		}else{
			throw new ClassCastException();
		}
		
		
	}

	public Date getValidSince() {
		
		return certificate.getEndDate().getDate();
		
	}

	public Date getValidUntil() {
		
		return certificate.getStartDate().getDate();
		
	}
	
}
