package es.caib.signatura.provider.impl.common;

import java.security.cert.CRL;
import java.security.cert.CRLSelector;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;


/**
 * Selector de CRLS dentro de un CERTStore para una cadena de certificación dada.
 * @author u91940
 *
 */
public class CertStoreCRLSelector implements CRLSelector {
	X509Certificate[] chain;
	
	public Object clone() {	
		try {
			return super.clone();
		} catch (CloneNotSupportedException e) {
			return null;
		}
	}
	
	public CertStoreCRLSelector(X509Certificate[] certChain) {
		chain=certChain;
	}
	
	public boolean match(CRL crl) {
		X509CRL xCRL=(X509CRL)crl;
		for(int i=0;i<chain.length;i++)
			if(xCRL.getIssuerDN().equals(chain[i].getIssuerDN())) return true;

		return false;
	}

}
