/*
 * Created on 01/04/2005
 *
 */
package es.caib.signatura.provider.impl.common;

import java.io.IOException;

import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;

import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;

import es.caib.signatura.impl.SigDebug;
import es.caib.signatura.impl.SignaturaProperties;

/**
 * @author u07286
 *
 */
public class DefaultParsedCertificateImpl implements InternalParsedCertificate {
	
	X509CertificateStructure certificate;
	String nif;
	String fullName;
	String productor;
	String intranetUser;
	String policy;
	String givenName;
	String surName;
	boolean proxy = false;
	String nifResponsable;
	boolean personaFisica;
	boolean personaJuridica;

	private SignaturaProperties properties = new SignaturaProperties ();
	

	private static DERObjectIdentifier NIFOID = new DERObjectIdentifier("1.3.6.1.4.1.18838.1.1");
	private static DERObjectIdentifier productorOID  = new DERObjectIdentifier("1.3.6.1.4.1.22896.1.1");
	private static DERObjectIdentifier proxyOID = new DERObjectIdentifier("1.3.6.1.4.1.22896.1.2");
	

	public DefaultParsedCertificateImpl (X509Certificate cert[], boolean securedevice ) throws CertificateEncodingException, IOException
	{
		init (cert, securedevice );
	}

	/**
	 * Hasta la versión 2.5 devolvía el nombre del representante. 
	 * A partir de la versión 2.5 devuelve el nombre del Representado
	 */
	public String getName() {
		if ( getFullName () != null)
			return getFullName();
		return certificate.getSubject().toString();
	}
	
	/* (non-Javadoc)
	 * @see es.caib.signatura.impl.CertificateParser#getNif()
	 */
	public String getNif ()
	{
		return nif;
	}
	
	public boolean equals(Object obj) {
		if (obj instanceof DefaultParsedCertificateImpl)
		{
			DefaultParsedCertificateImpl other = (DefaultParsedCertificateImpl) obj;
			if ( certificate != null && other.certificate != null ) 
				return certificate.equals(other.certificate);
			if ( intranetUser != null && other.intranetUser != null)
				return intranetUser.equals(other.intranetUser);
		}

		return false;
	}

	
	public String toString() {
		String s;
		if (certificate !=null)
			s = certificate.getSubject().toString()+"("+certificate.getIssuer().toString()+")";
		else
			s = intranetUser;
		s = s + " FullName:"+fullName+" NIF:"+nif;
		if ( nifResponsable != null)
			s = s + " NIF Responsable:"+nifResponsable;
		if ( productor != null)
			s = s + " Número productor:"+productor;
		if ( proxy )
			s = s + " PROXY:YES";
		return s;
	}

	
	public String getNifResponsable() {
		return nifResponsable;
	}

	public boolean isPersonaFisica() {
		return personaFisica;
	}

	public boolean isPersonaJuridica() {
		return personaJuridica;
	}
	
	/**
	 * Hasta la versión 2.5 devolvía el nombre del representante. 
	 * A partir de la versión 2.5 devuelve el nombre del Representado
	 */
	public String getFullName () {

		//if (givenName == null || surName == null)
			return fullName;
		//else
		//	return surName+" "+givenName;
	}

	public String getCommonName() {
		return fullName;
	}
	
	public String getProductor () {
		return productor;
	}


	public String getIntranetUser () {
		if (intranetUser != null)
			return intranetUser;
		
		if (productor == null)
			return null;
		String user = productor;
     	while (user.length() < 5)
     		user = "0" + user;
     	user = "u"+user;
		return user;
	}

	public boolean isProxy () {
		return proxy;
	}
	
	public String getPolicy () {
		return policy;
	}
	


	private void processName (String cn)
	{
		if ( cn != null && cn.startsWith("NOMBRE "))
		{
			//CERTIFICADO PERSONA FÍSICA
			int i = cn.indexOf(" - ");
			if ( i > 0 && cn.substring(i).startsWith(" - NIF "))
			{
				nif = cn.substring(i+7);
				fullName = cn.substring(7, i);
				personaFisica = true;
				personaJuridica = false;
			}
		}
		else if ( cn != null && cn.startsWith("ENTIDAD "))
		{
			//CERTIFICADO PERSONA JURÍDICA
			personaFisica = false;
			personaJuridica = true;
			int i = cn.indexOf(" - ");
			if ( i > 0 && cn.substring(i).startsWith(" - CIF "))
			{
				int j = cn.indexOf(" - ", i+7);
				
				int l = cn.indexOf(" - NOMBRE ", i+7);

				int k = cn.indexOf(" - NIF ", i+7);

				if ( l > 0) {
					//nombre propio a partir de la última ocurrencia del caracter " "
					givenName=cn.substring(l+10+cn.substring(l+10,k).lastIndexOf(" ")+1,k);

					//apellidos hasta la última ocurrencia del caracter " "
					surName=cn.substring(l+10,l+11+cn.substring(l+10,k).lastIndexOf(" ")-1);
				}

				
				if ( j > 0 && k > 0) {
					nif = cn.substring(i + 7, j);
					fullName = cn.substring(8, i);
					nifResponsable = cn.substring(k + 7);
				}
			}
		}
		else if ( cn != null && cn.startsWith("DESCRIPCION "))
		{
			//CERTIFICADO COMPONENTE
			personaFisica = false;
			personaJuridica = false;
			int i = cn.lastIndexOf(" - ");
			if ( i > 0 && cn.substring(i).startsWith(" - CIF "))
			{
				int k = cn.indexOf(" - CIF ");
				if (k > 0) {
					nif = cn.substring(k+7);
					fullName = cn.substring(12, k).replaceAll(" - ENTIDAD "," - ");
				}
			}
		}
		else
		{
			fullName = cn;
		}
	}
	
	private void init (X509Certificate cert[], boolean securedevice ) 
		throws IOException, CertificateEncodingException
	{
		byte b [] = cert[0].getEncoded ();
		ASN1InputStream asn1is = new ASN1InputStream ( b );
		DERObject obj = asn1is.readObject ();
		certificate = new X509CertificateStructure ((ASN1Sequence) obj);
		// Procesar el SUBJECT NAME
		X509Name name = certificate.getSubject();
		personaFisica = false;
		personaJuridica = false;
		java.util.Vector v = name.getOIDs ();
		java.util.Vector value = name.getValues ();
		for ( int i = 0; i < v.size(); i++)
		{
			if (v.get(i).equals (X509Name.CN)){
				processName (value.get(i).toString());
			}
			if (v.get(i).equals (X509Name.SURNAME)){
				surName = value.get(i).toString();
			}
			if (v.get(i).equals (X509Name.GIVENNAME)){
				givenName = value.get(i).toString();
			}
			if (v.get(i).equals (X509Name.SN))
			{
				nif = value.get(i).toString();
				if (! personaJuridica ) personaFisica = true;
			}
			if (v.get(i).equals (NIFOID))
			{
				nifResponsable = value.get(i).toString();
				personaFisica = false;
				personaJuridica = true;
			}
		}
		// Procesar el ALTERNATE SUBJECT NAME
		TBSCertificateStructure tbs = certificate.getTBSCertificate ();
		X509Extensions exts = tbs.getExtensions ();

		if( SigDebug.isActive() )  SigDebug.write( "ParsedCertificateImp.init: extensionss null ?" + ( exts == null ? "si" : "no") );
		if( exts != null ) {
			X509Extension altName = exts.getExtension (X509Extensions.SubjectAlternativeName);
			if (altName != null)
			{
				ASN1Sequence asn1seq;
				asn1is = new ASN1InputStream ( altName.getValue ().getOctets() );
				asn1seq = (ASN1Sequence) asn1is.readObject ();
				GeneralNames gnames = new GeneralNames (asn1seq);
				GeneralName gname[] = gnames.getNames();
				for (int i = 0 ; i < gname.length; i++)
				{
					if ( gname[i].getTagNo () == 0 )
					{
						ASN1Sequence seq = (ASN1Sequence) gname[i].getName();
						if ( seq.getObjectAt(0).equals(productorOID))
							productor = DERUTF8String.getInstance (seq.getObjectAt(1)).getString();
						if ( seq.getObjectAt(0).equals(proxyOID))
							proxy = DERUTF8String.getInstance (seq.getObjectAt(1)).getString().equals("YES");
					}
				}
			}
			// Procesar la política
			if( SigDebug.isActive() )  SigDebug.write( "ParsedCertificateImpl.init: calculant extensions CertificatePolicies" );
			X509Extension polext = exts.getExtension (X509Extensions.CertificatePolicies);
			if( SigDebug.isActive() )  SigDebug.write( "ParsedCertificateImpl.init: extensions CertificatePolicies null ?" + (polext == null ? "si" : "no") );
			if (polext != null) {
				ASN1Sequence asn1seq;
				asn1is = new ASN1InputStream ( polext.getValue ().getOctets() );
				asn1seq = (ASN1Sequence) asn1is.readObject ();
				Enumeration polInfo = asn1seq.getObjects();
				while (polInfo.hasMoreElements())
				{
					ASN1Sequence seq2 = (ASN1Sequence) polInfo.nextElement();
					PolicyInformation info = new PolicyInformation(seq2);
					processPolicy (info.getPolicyIdentifier().getId(), exts, securedevice);
				}
			}else{
				processPolicy ("", exts, securedevice);
			}
	

		}

	}

	private String getCACommonName (X509Certificate cert) throws IOException, CertificateEncodingException
	{
		// En cas de no trobar el CN, retornem el CN (posat pel cas de la FNMT, que no inclou
		// el CN en el certificat de l'emissor.
		String ou = "";
		byte b [] = cert.getEncoded ();
		ASN1InputStream asn1is = new ASN1InputStream ( b );
		DERObject obj = asn1is.readObject ();
		certificate = new X509CertificateStructure ((ASN1Sequence) obj);
		asn1is.close();
		X509Name name = certificate.getIssuer();
		java.util.Vector v = name.getOIDs ();
		java.util.Vector value = name.getValues ();
		for ( int i = 0; i < v.size(); i++)
		{
			if (v.get(i).equals (X509Name.CN)){

				if(SigDebug.isActive())
					SigDebug.write("getCACommonName(): "+value.get(i).toString());
				return value.get(i).toString();
			}
			if (v.get(i).equals (X509Name.OU))
				ou = value.get(i).toString();
		}

		if(SigDebug.isActive())
			SigDebug.write("getCACommonName(): "+ou);

		// Si no troba el CN, retorna el OU.
		return ou;
	}
	
	
	private void processPolicy(String id, X509Extensions exts, boolean securedevice) {

	}

	private boolean isIncluded(String id, String[] policies) {
		for (int i = 0; i < policies.length; i++)
		{
			if (id.equals (policies[i]))
				return true;
		}
		return false;
	}

	public Date getValidSince() {
		
		return certificate.getEndDate().getDate();
		
	}

	public Date getValidUntil() {
		
		return certificate.getStartDate().getDate();
		
	}

} 
