package es.caib.signatura.provider.impl.common;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;

import javax.security.cert.CertificateException;

import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;

import es.caib.signatura.impl.SigDebug;
import es.caib.signatura.impl.SignaturaProperties;

public class FuncionariParsedCertificateImpl extends FuncionariParsedCertificate{
		
	// Campos que necesitamos para la compulsa:
	private String cargo;
	private String centroDirectivo;
	private String consejeria;
	private String nombre;
	private String apellidos;
	private String localidad;
	
	// Policy OID de certificado de empleado público
	static private final String CERTIFICATE_POLICY_OID = "1.3.6.1.4.1.17326.10.9.2.2.2";

	public static void main(String args[]) {
		
		try {

			FileInputStream fis = new FileInputStream("C:\\test\\miquel_mascaro_artigues.cer");
			CertificateFactory cf = CertificateFactory.getInstance("X.509");
			X509Certificate cert = (X509Certificate)cf.generateCertificate(fis);
			X509Certificate[] certs = {cert};
			FuncionariParsedCertificateImpl funcionariCert = new FuncionariParsedCertificateImpl(certs, false);
			System.out.println("Cargo: " + funcionariCert.getCargo());
			System.out.println("Centro directivo: " + funcionariCert.getCentroDirectivo());
			System.out.println("Consejería: " + funcionariCert.getConsejeria());
			System.out.println("Nombre: " + funcionariCert.getNombre());
			System.out.println("Apellidos: " + funcionariCert.getApellidos());
			System.out.println("Localidad: " + funcionariCert.getLocalidad());
			
		} catch (Exception e) {
		
			e.printStackTrace();
		
		}
		
	}
	
	public FuncionariParsedCertificateImpl(X509Certificate[] cert, boolean securedevice)
		throws Exception{
		super(cert, securedevice);
		
		init(cert, securedevice);
	
	}
	
	private void init(X509Certificate cert[], boolean securedevice)
		throws IOException, CertificateException, CertificateEncodingException {
	
		byte b[] = cert[0].getEncoded();
		ASN1InputStream asn1is = new ASN1InputStream( b );
		DERObject obj = asn1is.readObject();
		X509CertificateStructure certificate = new X509CertificateStructure((ASN1Sequence) obj);
		
		// Procesar el SUBJECT NAME
		X509Name name = certificate.getSubject();
		Vector v = name.getOIDs ();
		Vector value = name.getValues ();
		
		if( SigDebug.isActive() )  System.out.println("Hay " + v.size() + " oids en el subject");
		
		for ( int i = 0; i < v.size(); i++) {
						
			// X509Name.GIVENNAME
			// X509Name.SN o X509Name.SURNAME ¿?
			// X509Name.OU (1 y 2, centro directivo y consellería)
			// X509Name.T (título/cargo)
			// X509Name.L (localidad)
			if (v.get(i).equals (X509Name.GIVENNAME)) {
				
				if( SigDebug.isActive() )  System.out.println("Obteniendo GIVENNAME: " + value.get(i).toString());
				nombre = value.get(i).toString();
				
			} else if (v.get(i).equals (X509Name.SN)) {
				
				if( SigDebug.isActive() )  System.out.println("Obteniendo SN: " + value.get(i).toString());
				apellidos = value.get(i).toString();
			
			} else if (v.get(i).equals (X509Name.SURNAME)) {
				
				if( SigDebug.isActive() )  System.out.println("Obteniendo SURNAME: " + value.get(i).toString());
				apellidos = value.get(i).toString();
				
			} else if (v.get(i).equals (X509Name.OU)) {
				
				if( SigDebug.isActive() )  System.out.println("Obteniendo OU: " + value.get(i).toString());
				if (consejeria == null)
					consejeria = value.get(i).toString();
				else
					centroDirectivo = value.get(i).toString();
				
			} else if (v.get(i).equals (X509Name.L)) {
				
				if( SigDebug.isActive() )  System.out.println("Obteniendo L: " + value.get(i).toString());
				localidad = value.get(i).toString();
				
			} else if (v.get(i).equals (X509Name.T)) {
	
				if( SigDebug.isActive() )  System.out.println("Obteniendo T: " + value.get(i).toString());
				cargo = value.get(i).toString();
				
			} else {
			
				if( SigDebug.isActive() )  System.out.println("OID no contemplado: " + v.get(i).toString() + " => " + value.get(i).toString());
			
			}
					
		}
		
		TBSCertificateStructure tbs = certificate.getTBSCertificate();
		X509Extensions exts = tbs.getExtensions();
		X509Extension polext = exts.getExtension(X509Extensions.CertificatePolicies);
		Vector policies = new Vector();
		
		if (polext != null) {
			
			ASN1Sequence asn1seq;
			asn1is = new ASN1InputStream( polext.getValue().getOctets() );
			asn1seq = (ASN1Sequence)asn1is.readObject();
			Enumeration tempPolicies = asn1seq.getObjects();
			
			while (tempPolicies.hasMoreElements()) {
				
				ASN1Sequence seq2 = (ASN1Sequence)tempPolicies.nextElement();
				PolicyInformation info = new PolicyInformation(seq2);
				policies.add(info);
				
			}
			
		    int cnt = 0;
		    boolean found = false;
		    
		    SignaturaProperties properties = new SignaturaProperties();
		    String [] publicemployeeOID = properties.getPublicEmployeeOID();
		    int i=0;
			while ( cnt < policies.size() && !found ) {
			    for(i=0;i<publicemployeeOID.length && !found ;i++){
					
					PolicyInformation info = (PolicyInformation)policies.get(cnt);
					String policyOID = info.getPolicyIdentifier().getId();
					
					if ( publicemployeeOID[i].equals(policyOID) )
						found = true;
				}
			    cnt++;
		    }			
			// Comentar esta comprobación si se usan certificados que no son de 
			// tipo de funcionario público para hacer pruebas
			if (!found)
				throw new CertificateException("OID de certificado de funcionario público no encontrado en el certificado especificado para crear la compulsa.");
			
		} else {
			
			throw new CertificateException("OID de certificado de funcionario público no encontrado en el certificado especificado para crear la compulsa.");
			
		}
		
	}

	public String getCargo() {
		return cargo;
	}

	public String getLocalidad() {
		return localidad;
	}

	public String getCentroDirectivo() {
		return centroDirectivo;
	}

	public String getConsejeria() {
		return consejeria;
	}

	public String getNombre() {
		return nombre;
	}

	public String getApellidos() {
		return apellidos;
	}	
	
}
