package es.caib.signatura.provider.impl.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.AcroFields;
import com.lowagie.text.pdf.BarcodePDF417;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import com.lowagie.text.pdf.PdfTemplate;

import es.caib.signatura.api.SignatureException;
import es.caib.signatura.impl.locales.Messages;

public class PDFTest {

	
	private static final int SIGNATURE_HORIZONTAL_SPLIT_LEN = 65;
	private static final int SIGNATURE_VERTICAL_SPLIT_LEN = 100;
	private static final int SIGNATURE_SPLIT_RANGE = 10;
	private static final int SIGNATURE_SPLIT_MARGIN = 5;
	public static final String DATE_FORMAT = "dd-MM-yyyy"; //$NON-NLS-1$
	
	private static int SIGNATURE_DEF_WIDTH = 200;
	private static int SIGNATURE_DEF_HEIGHT = 50;
	
	
	public static void main(String[] args) {
		try{
			PDFTest test=new PDFTest();
			String url="http://www.opensubscriber.com/message/itext-questions@lists.sourceforge.net/7624146.html";
			int stampOptions=0;
			
			test.estampadoPDF417( url, stampOptions, 300, 300, 150, 350, 0);
			test.estampadoPDF417( url, stampOptions, 300, 300, 150, 300, 90);
			//test.estampadoPDF417( url, stampOptions, 100, 0, 100, 500, 270);
			test.estampadoPDF417( url, stampOptions, 300, 300, 500, 500, 30);
			test.estampadoPDF417( url, stampOptions, 300, 300, 500, 500, 120);
			test.estampadoPDF417( url, stampOptions, 300, 300, 500, 500, 240);
			test.estampadoPDF417( url, stampOptions, 300, 300, 500, 500, 300);
		}catch(Throwable t){
			t.printStackTrace();
			System.exit(1);
		}
	}
	
	private static void estampadoPDF417(
			 String url, int stampOptions,float top, float left, float height, float width,float rotation)
		throws Exception {
		
		InputStream in=new FileInputStream(new File("c:\\pkcs.pdf"));
		OutputStream out=new FileOutputStream(new File("c:\\pdf_out"+rotation+".pdf"));
		
		PdfReader reader;
		reader = new PdfReader(in);
		
		
		
		estampadoPDF417(reader, out, url, stampOptions,top,left,height,width,rotation);
		in.close();
		out.close();
	}
	
	private static void estampadoPDF417(PdfReader reader, OutputStream signedStream,
			 String url, int position,float top, float left, float height, float width, float rotation)
		throws Exception {
		

		try {

			int numberOfPages = reader.getNumberOfPages();

			AcroFields acroFields = reader.getAcroFields();
			ArrayList names = acroFields.getSignatureNames();
			

			SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_FORMAT);
	
			BaseFont bf = BaseFont.createFont(BaseFont.HELVETICA, BaseFont.WINANSI, BaseFont.EMBEDDED);
			String  line = "Pere Joseph Rodríguex" + " " + simpleDateFormat.format(new Date()) + " " + url; 

			PdfStamper stamp;
			
			// Comprobamos si queremos que el PDF contenga múltiples firmas
			stamp=new PdfStamper(reader, signedStream);
			
			// Template donde añadiremos la tabla con los datos de compulsa
			PdfTemplate template = PdfTemplate.createTemplate(stamp.getWriter(), width, height);
		
			
	
				int textAlign = PdfContentByte.ALIGN_LEFT;
	
				
				BarcodePDF417 pdf417 = new BarcodePDF417();
				pdf417.setText(url);
				Image image = pdf417.getImage();
				if(width<image.getWidth()) throw new SignatureException("Width too small, minumim: "+image.getWidth());
				if(height<image.getHeight()) throw new SignatureException("Height too small, minumim: "+image.getHeight());					
					
				for (int i = 1; i <=numberOfPages; i++) {
					PdfContentByte over = stamp.getOverContent(i);
					
					Rectangle pageSize = reader.getPageSize(i);
					float pageWidth = pageSize.getWidth();
					float pageHeight = pageSize.getHeight();
					
					int SIGNATURE_SPLIT_LEN=0;
					SIGNATURE_SPLIT_LEN=(int)(width-image.getWidth())/8;
					

		
					Vector lines=new Vector();
					int counter=0;
					boolean ampliat=false;
					
					while(counter!=-1){
						if(counter+SIGNATURE_SPLIT_LEN<line.length()){
							int prev=line.substring(counter,counter+SIGNATURE_SPLIT_LEN).lastIndexOf(" "); //$NON-NLS-1$
							String next_string=line.substring(counter+SIGNATURE_SPLIT_LEN,line.length());
							int next=next_string.indexOf(" "); //$NON-NLS-1$
							//prev [-1,SPLIT_LEN]
							//next[-1,inf]
		
							int splitPos=prev+1; 
							//splitpos [-1,SPLIT_LEN+1]
		
							if(!ampliat && next<SIGNATURE_SPLIT_RANGE && next!=-1){
								splitPos=SIGNATURE_SPLIT_LEN+next;
								SIGNATURE_SPLIT_LEN+=next; //per a què totes les línies quedin iguals
								ampliat=true;
								//next[0,inf]
								//splitpos [0,SPLIT_LEN+SPLIT_RANGE]
								
							}else if(prev==-1 && next>SIGNATURE_SPLIT_RANGE ){
								splitPos=SIGNATURE_SPLIT_LEN;
								//prev [0,SPLIT_LEN]
								//splitpos [0,SPLIT_LEN+SPLIT_RANGE]
							}else if(prev==-1 && next==-1){
								splitPos=SIGNATURE_SPLIT_LEN;
							}
							
							lines.add(line.substring(counter,counter+splitPos));
							if((counter+splitPos)<line.length() && line.charAt(counter+splitPos)==' ') counter++;
							counter+=splitPos; //+1= espai
						}else{
							lines.add(line.substring(counter,line.length()));
							counter=-1;
						}
					}
		
					float pdf417_X =0;
					float pdf417_Y =0;
					float text_X = image.getWidth()+20;
					float text_Y = 0;
					
					
					image.setAbsolutePosition(pdf417_X, ((lines.size())*(10+SIGNATURE_SPLIT_MARGIN))/2.0f-(image.getHeight()/2.0f));
					template.addImage(image);
					
					counter=0;
					
					
					//Imprimimos las líneas de la firma
					for(counter=0;counter<lines.size();counter++){
				
						template.beginText();
						template.setFontAndSize(bf, 10);
						float x= text_X;
						float y=text_Y+((lines.size()-1)-counter)*(10+SIGNATURE_SPLIT_MARGIN);
						template.showTextAligned(textAlign, (String)lines.get(counter),x ,y ,0);
						template.endText();		
					}
					
					
					
					float angle  = (float)(-rotation * (Math.PI / 180));
					float xScale = (float)(Math.cos(angle));
					float yScale = (float)(Math.cos(angle));
					float xRote  = (float)(-Math.sin(angle));
					float yRote  = (float)(Math.sin(angle)); 
					float leftTemplate=0.0f;
					float topTemplate=0.0f;
					
					over.addTemplate(template, xScale, xRote, yRote, yScale, leftTemplate+left, topTemplate+top);
				}
			stamp.close();
			reader.close();
			
			
		} catch (DocumentException e) {
			throw new SignatureException (Messages.getString("PDFSigner.error_firmando_pdf"), e); //$NON-NLS-1$
		}
		
	}

	
	
}
