package es.caib.signatura.provider.impl.common;

import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertStoreException;

import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;

import org.bouncycastle.cms.CMSException;
import org.bouncycastle.x509.NoSuchStoreException;

import es.caib.signatura.api.SMIMEParser;
import es.caib.signatura.api.Signature;
import es.caib.signatura.api.SignatureDataException;
import es.caib.signatura.api.SignatureException;

/**
 * Factoría de intérpretes de documentos smime, o intérprete abstracto.
 * 
 * @author u91940
 *
 */
public class SMIMEImpl implements SMIMEParser{
	//mime types
	protected static String MULTIPART_SIGNED = "multipart/signed";  
	protected static String DETACHED_SIGNATURE = "application/pkcs7-signature";
	protected static String ENVELOPED_SIGNATURE = "application/pkcs7-mime";
	
	
	//smime sub-types
	protected static String ENVELOPED_DATA = "enveloped-data";
	protected static String SIGNED_DATA = "signed-data";
	protected static String CERTS_ONLY = "certs-only";
	protected static String COMPRESSED_DATA = "compressed-data";
	
	
	protected String contentType=null;
	protected String smimeType=null;
	protected String name=null;
	protected String contentTransferEncoding=null;
	
	protected Object signedObject=null;
	protected String smimeDocument=null;
	protected Signature signatures []=null;
	
	public final SMIMEParser getInstance(InputStream smime)throws IOException, SignatureException {
	    Session session = null;
	    MimeMessage mime = null;
	       
	    //Obtenemos la session 
	    session = Session.getDefaultInstance(System.getProperties(), null);      
	    
	 
        //Creamos el mensaje mime
	    ClassLoader oldClassLoader=null;
        try {
        	oldClassLoader=Thread.currentThread().getContextClassLoader();
       	    ClassLoader newClassLoader=MimeMessage.class.getClassLoader();
       	    Thread.currentThread().setContextClassLoader(newClassLoader);
       	    
			mime = new MimeMessage(session,smime);


	        //Si el mime es un MULTIPART_SIGNED, buscamos la parte que no es de firma, esa parte debe ser un nuevo mensaje MIME,  
	        //el cual volveremos a analizar. 
	        if (mime.isMimeType(MULTIPART_SIGNED)) {   
	          DetachedSMIME parsed=new DetachedSMIME();
	          parsed.parse(mime);
	          return parsed;
	        }else{
	        	throw new ClassCastException("Tipo de fichero mime no soportado");
	        }
		} catch (MessagingException e) {
			throw new SignatureException(e.getMessage(),e);
		} catch (NoSuchProviderException e) {
			throw new SignatureException(e.getMessage(),e);
		} catch (NoSuchAlgorithmException e) {
			throw new SignatureException(e.getMessage(),e);
		} catch (CertStoreException e) {
			throw new SignatureException(e.getMessage(),e);
		} catch (InvalidAlgorithmParameterException e) {
			throw new SignatureException(e.getMessage(),e);
		} catch (CMSException e) {
			throw new SignatureException(e.getMessage(),e);
		} catch (NoSuchStoreException e) {
			throw new SignatureException(e.getMessage(),e);
		} catch (SignatureDataException e) {		
			throw e;
		} catch (IOException e) {
			throw e;
		}finally{
			Thread.currentThread().setContextClassLoader(oldClassLoader);
		}
	    
 	}
		

	public final Object getSignedObject() {
		return signedObject;
	}


	public final Signature[] getSignatures() {
		return signatures;
	}


	public void parse(InputStream mimeIS) throws SignatureDataException, IOException, InstantiationException, IllegalAccessException {
		return;		
	}
	
		
}
