/*
 * Decompiled with CFR 0.152.
 */
package es.caib.signatura.provider.impl.common;

import es.caib.signatura.impl.SigDebug;
import es.caib.signatura.provider.impl.common.InternalParsedCertificate;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;

public class ANCERTParsedCertificate
implements InternalParsedCertificate {
    X509CertificateStructure certificate;
    String nif;
    String fullName;
    String givenName;
    String surName;
    String nifResponsable;
    boolean personaFisica;
    boolean personaJuridica;
    public static final String CNP = new String("1.3.6.1.4.1.18920.1.1.1.1");
    public static final String CNPR = new String("1.3.6.1.4.1.18920.1.1.2.1");
    public static final String CNCR = new String("1.3.6.1.4.1.18920.1.3.2.1");
    public static final String FERN = new String("1.3.6.1.4.1.18920.4.1.1.1");

    public ANCERTParsedCertificate(X509Certificate[] cert, boolean securedevice) throws CertificateEncodingException, IOException {
        this.init(cert, securedevice);
    }

    public String getName() {
        if (this.getFullName() != null) {
            return this.getFullName();
        }
        return this.certificate.getSubject().toString();
    }

    public String getNif() {
        return this.nif;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ANCERTParsedCertificate) {
            ANCERTParsedCertificate other = (ANCERTParsedCertificate)obj;
            if (this.certificate != null && other.certificate != null) {
                return this.certificate.equals((Object)other.certificate);
            }
        }
        return false;
    }

    public String toString() {
        String s = this.certificate != null ? this.certificate.getSubject().toString() + "(" + this.certificate.getIssuer().toString() + ")" : "";
        s = s + " FullName:" + this.fullName + " NIF:" + this.nif;
        if (this.nifResponsable != null) {
            s = s + " NIF Responsable:" + this.nifResponsable;
        }
        return s;
    }

    public String getNifResponsable() {
        return this.nifResponsable;
    }

    public boolean isPersonaFisica() {
        return this.personaFisica;
    }

    public boolean isPersonaJuridica() {
        return this.personaJuridica;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getCommonName() {
        return this.fullName;
    }

    private void init(X509Certificate[] cert, boolean securedevice) throws CertificateEncodingException, IOException {
        byte[] b = cert[0].getEncoded();
        ASN1InputStream asn1is = new ASN1InputStream(b);
        DERObject obj = asn1is.readObject();
        this.certificate = new X509CertificateStructure((ASN1Sequence)obj);
        TBSCertificateStructure tbs = this.certificate.getTBSCertificate();
        X509Extensions exts = tbs.getExtensions();
        if (SigDebug.isActive()) {
            SigDebug.write((String)("ParsedCertificateImp.init: extensionss null ?" + (exts == null ? "si" : "no")));
        }
        if (exts != null) {
            if (SigDebug.isActive()) {
                SigDebug.write((String)"ParsedCertificateImpl.init: calculant extensions CertificatePolicies");
            }
            X509Extension polext = exts.getExtension(X509Extensions.CertificatePolicies);
            if (SigDebug.isActive()) {
                SigDebug.write((String)("ParsedCertificateImpl.init: extensions CertificatePolicies null ?" + (polext == null ? "si" : "no")));
            }
            if (polext != null) {
                asn1is = new ASN1InputStream(polext.getValue().getOctets());
                ASN1Sequence asn1seq = (ASN1Sequence)asn1is.readObject();
                Enumeration polInfo = asn1seq.getObjects();
                while (polInfo.hasMoreElements()) {
                    ASN1Sequence seq2 = (ASN1Sequence)polInfo.nextElement();
                    PolicyInformation info = new PolicyInformation(seq2);
                    this.processPolicy(this.certificate, info.getPolicyIdentifier().getId(), exts, securedevice);
                }
            } else {
                this.processPolicy(this.certificate, "", exts, securedevice);
            }
        } else {
            throw new ClassCastException();
        }
    }

    private void processPolicy(X509CertificateStructure certificate2, String policy_id, X509Extensions exts, boolean securedevice) {
        X509Name name = certificate2.getSubject();
        this.personaFisica = false;
        this.personaJuridica = false;
        if (policy_id.equals(CNP) || policy_id.equals(FERN)) {
            this.nif = (String)name.getValues(X509Name.SN).get(0);
            this.fullName = (String)name.getValues(X509Name.CN).get(0);
            this.givenName = (String)name.getValues(X509Name.GIVENNAME).get(0);
            this.surName = (String)name.getValues(X509Name.SURNAME).get(0);
            this.nifResponsable = null;
            this.personaFisica = true;
            this.personaJuridica = false;
        } else if (policy_id.equals(CNPR)) {
            int i = 0;
            i = 0;
            while (true) {
                if (i < name.getValues(X509Name.OU).size()) {
                    String representado = (String)name.getValues(X509Name.OU).get(i);
                    if (representado.indexOf("Autorizado ante Notario") == -1) {
                        this.nif = representado.substring(representado.lastIndexOf("-") + 5);
                        this.fullName = representado.substring(0, representado.lastIndexOf("-") - 1);
                        this.givenName = (String)name.getValues(X509Name.GIVENNAME).get(0);
                        this.surName = (String)name.getValues(X509Name.SURNAME).get(0);
                        this.nifResponsable = (String)name.getValues(X509Name.SN).get(0);
                        this.personaFisica = true;
                        this.personaJuridica = false;
                    }
                    ++i;
                    continue;
                }
                break;
            }
        } else if (policy_id.equals(CNCR)) {
            int i = 0;
            i = 0;
            while (true) {
                if (i < name.getValues(X509Name.OU).size()) {
                    String representado = (String)name.getValues(X509Name.OU).get(i);
                    if (representado.indexOf("Autorizado ante Notario") == -1) {
                        this.nif = representado.substring(representado.lastIndexOf("-") + 6);
                        this.fullName = representado.substring(0, representado.lastIndexOf("-") - 1);
                        this.givenName = (String)name.getValues(X509Name.GIVENNAME).get(0);
                        this.surName = (String)name.getValues(X509Name.SURNAME).get(0);
                        this.nifResponsable = (String)name.getValues(X509Name.SN).get(0);
                        this.personaFisica = false;
                        this.personaJuridica = true;
                    }
                    ++i;
                    continue;
                }
                break;
            }
        } else {
            throw new ClassCastException();
        }
    }

    public Date getValidSince() {
        return this.certificate.getEndDate().getDate();
    }

    public Date getValidUntil() {
        return this.certificate.getStartDate().getDate();
    }
}

